#!/bin/sh
#----------------------------------------------------------------------------
# Creation:    21.10.2006
# Author:      Roland Spitzer
#
# Last Update: 22.12.2006 22:22 v1.0.1 Einbau manual_start und manual_stop (manuell)
#              11.01.2007 21:24 v1.0.2 only_start und only_stop eingebaut
#              16.02.2007 09:48 v1.1.0 Parameter 3 als VALUE, skript immer
#                               neu schreiben, bei Type 3 kein Logging
#              19.04.2007 05:35 v1.1.1 default eingebaut
#              20.04.2007 20:58 v1.1.1 log= eingebaut um logging temporr auszuschalten
#                                      (ersetzt das Ausschalten des Logging bei Type 3)
#              03.05.2007 02:24 v1.1.1 Fehlerbehebung ersetzen " anstatt mit @ durch  ersetzen
#                                      Hinweis von T.Albrecht
#              03.12.2007 06:12 v1.1.4 keine Log-Schreibung bei explizitem log-Command
#
# Skript to generate automation-commands
#
#----------------------------------------------------------------------------

. /usr/local/bin/automation/prolog.inc

####################################################
# Parameter prfen und setzen
####################################################

HOST=$1
FUNKTION=$2
set -f
VALUE=`echo $3 | sed 's/'\"'/'\''/g'`
set +f

debug "command $FUNKTION generation for $HOST started"

if [ $# -ne 2 -a $# -ne 3 ]
then
        echo "Aufruf $BASE Host start/stop/backup/... Wert"
        debug "Aufruf $BASE Host start/stop/backup/... Wert"
        exit $EXIT_ERROR
fi

skript=$BIN"/"$HOST"_"$FUNKTION".sh"

####################################################
# If skript exists use it
####################################################

if [ -e $skript -a "$VALUE" = "" ]
then
    $skript 
    exit $EXIT_SUCCESS
fi

####################################################
# Command exists ?
####################################################

case $FUNKTION in
      "start"|"stop"|"manual_start"|"manual_stop"|"only_stop"|"only_start") : ;;
      *) if [ ! `grep "^"$HOST"_command_[0-9]*=\""$FUNKTION"\"" $CONF` ]
         then
             if [ ! `grep "^"$HOST"_command_[0-9]*=\"default\"" $CONF` ]
             then
                 log "command $skript not found"
                 exit $EXIT_ERROR
             else
                 set -f
                 VALUE=`echo $2 | sed 's/'\"'/'\''/g'`
                 set +f
                 FUNKTION="default"
             fi
         fi
         ;;
esac

{
####################################################
# Skript Vorspann
####################################################

echo "#!/bin/sh"
echo "#----------------------------------------------------------------"
echo "#"
echo "# Creation:    14.01.2007"
echo "# Author:      Roland Spitzer"
echo "#"
echo "# Skript generated by OPT_AUTOMATION"
echo "#"
echo "#----------------------------------------------------------------"
echo ""
echo ". /usr/local/bin/automation/prolog.inc"
echo ""
echo "####################################################"
echo "# Verarbeitung "$1"_"$2".sh Start"
echo "####################################################"
echo ""
echo "HOST=\""$HOST"\""
echo "FUNKTION=\""$FUNKTION"\""
echo "STATUS=\`\$BIN/status.sh "$HOST" status\`"
set -f
echo "VALUE=\""$VALUE"\""
set +f
echo ""

case $FUNKTION in

      stop|0)          echo "\$BIN/status.sh "$HOST" stopping"
                       echo ""
                       ;;
      start|1)         echo "\$BIN/status.sh "$HOST" starting"
                       echo ""
                       ;;
      manual_stop|10)  echo "\$BIN/status.sh "$HOST" manual_stopping"
                       echo ""
                       ;;
      manual_start|11) echo "\$BIN/status.sh "$HOST" manual_starting"
                       echo ""
                       ;;
      only_stop|30)    if [ `grep "^"$HOST"_groups=" $CONF | cut -f 2 -d '"'` -eq 0 ]
                       then
                           echo "\$BIN/status.sh "$HOST" stopping"
                       else
                           echo "\$BIN/status.sh "$HOST" only_off"
                       fi
                       echo ""
                       FUNKTION="stop"
                       ;;
      only_start|31)   if [ `grep "^"$HOST"_groups=" $CONF | cut -f 2 -d '"'` -eq 0 ]
                       then
                           echo "\$BIN/status.sh "$HOST" starting"
                       else
                           echo "\$BIN/status.sh "$HOST" only_on"
                       fi
                       echo ""
                       FUNKTION="start"
                       ;;
esac

####################################################
# Host Commands Verarbeitung
####################################################

set -f
command=`grep "^"$HOST"_command_[0-9]*=\""$FUNKTION"\"" $CONF | cut -f 1 -d '='`
if [ $command ]
then
    grep "^"$command"_[0-9]*=" $CONF | sed 's/'\"'//;s/'\"'$//' | cut -f 2 -d '' |
    while read commandrec
    do
        if [ ! "`echo $commandrec | grep "[Ll][Oo][Gg]="`" = "" ] 
        then
            LOG=`echo $commandrec | cut -f 2 -d "=" |  tr "[A-Z]" "[a-z]"`
        fi

        echo "$commandrec"
        if [ "$LOG" = "yes" ]
        then
            if [ "`echo $commandrec | grep "[Ll][Oo][Gg] `" = "" ] 
            then
                echo "log \""`echo $commandrec | sed 's/'\"'/\\\\"/g'`"\""
            fi
        fi
    done
fi
set +f

####################################################
# Skript Ende
####################################################

echo ""
echo "####################################################"
echo "# Verarbeitung "$1"_"$2".sh Ende"
echo "####################################################"
echo ""
echo "exit \$EXIT_SUCCESS"

} > $skript

####################################################
# Ende Generierung und Submit Skript
####################################################

chmod 555 $skript
$skript

debug "command $skript ended"
exit $EXIT_SUCCESS