#!/bin/sh
#----------------------------------------------------------------------------
# Creation:    21.10.2006
# Author:      Roland Spitzer
#
# Last Update: 12.01.2007 06:13 grep eingebaut
#
# Server in berwachung stellen wenn keine abhngigen
# Server mehr online sind
#
#----------------------------------------------------------------------------

. /usr/local/bin/automation/prolog.inc

####################################################
# Parameter prfen
####################################################

HOST=$1

if [ $# -ne 1 ]
then
    echo "Aufruf $BASE Host"
    debug "Aufruf $BASE Host"
    exit $EXIT_ERROR
fi

#######################################################
# Prfen ob child-Hosts verfgbar
#######################################################

host_offline ()
{
    for host_child in `grep "^"$1"_child_[0-9]*=" $CONF | cut -f 2 -d '"'`
    do
        status_child=`$BIN/status.sh $host_child status`
        case $status_child in
              1|11|31) if [ ! "$host_child" = "$1" ]
                       then
                           echo $EXIT_ERROR
                           return
                       fi
                       ;;
        esac
    done

    echo $EXIT_SUCCESS
}

port_offline ()
{
    for host_port in `grep "^"$1"_port_[0-9]*=" $CONF | cut -f 2 -d '"'`
    do
         if  cat /proc/net/ip_conntrack | grep dport="$host_port " > /dev/null
         then
             echo $EXIT_ERROR
             debug "$host - $host_port is in use by host\(s\) `cat /proc/net/ip_conntrack | grep dport="$port " | cut -f 10 -d ' ' | cut -f 2 -d '='`"
             return
         fi
    done

    echo $EXIT_SUCCESS
}

###################################################
# Child Check Verarbeitung
####################################################

debug "child check for $HOST started"

for host in `grep "^".*_child_[0-9]*=\""$HOST"\" $CONF | cut -f 1 -d '=' | sed 's/_child_[0-9]*$//;'`
do
       status=`$BIN/status.sh $host status`

       if [ $status -eq 1 -o $status -eq 5 -o $status -eq 11 -o $status -eq 31 ]
       then
           if [ `host_offline $host` -eq $EXIT_SUCCESS -a `port_offline $host` -eq $EXIT_SUCCESS ]
           then
               if [ $status -ne 5 ]
               then
                   $BIN/status.sh $host parent_wait
                   debug "$host put in parent_wait"
               fi
           else
               if [ $status -eq 5 ]
               then
                   $BIN/status.sh $host on
                   debug "$host kill parent_wait"
               fi
           fi
       fi
done

####################################################
# Ende Child Check
####################################################

debug "child check ended"
exit $EXIT_SUCCESS