#!/bin/sh
#----------------------------------------------------------------------------
# Creation:    21.10.2006
# Author:      Roland Spitzer
#
# Last Update: 13.12.2006 05:22 Status 10 und 11 bei manuell ergnzt (0|10) und (1|11)
#              14.12.2006 19:39 Status 2 und 3 eingebaut wenn start oder stop fehlschlgt
#
#              22.12.2006 22:22 V1.0.1 Erweiterung der Status-Codes (manuell)
#
#              01.01.2007 12:13 v1.0.2 type 0, 1, 2 eingebaut und actorpoll
#                               Tabelle eingebaut zur Performance-Verbesserung
#                               Bei Status-Wechsel nur im Debug-Modus Logfile 
#                               fping und sleep eingebaut
#              15.02.2007 23:17 v1.1.0 type 3 eingebaut
#              18.04.2007 06:43 v1.1.1 start.sh eingebaut
#              07.05.2007 03:22 v1.1.2 Anlegen status-files nach rc511.automation 
#              08.05.2007 21:30 v1.1.2 trap eingebaut
#              12.05.2007 11:43 v1.1.3 start.sh und trap ausgebaut 
#                               v1.1.3 Verarbeitung in den Hintergrund gelegt
#              07.06.2007 07:44 v1.1.3 beim ps grep, grep ausgeklammert
#
# Steuerungs-Skript fr PC's
# Ablage der Status-Informationen in Dateien und Start bestimmter
# Aktionen abhngig von Zustnden
#
#----------------------------------------------------------------------------

. /usr/local/bin/automation/prolog.inc

####################################################
# Prfen ob bereits aktiv, ansonsten beenden
####################################################

LOCKFILE="/var/run/automation.pid"
if [ -f $LOCKFILE ]
then
    /usr/bin/logger Automation already running
    log "Automation already running"
    exit $EXIT_ERROR
fi
echo $$ > $LOCKFILE

####################################################
# Start der Automation
####################################################

/usr/bin/logger Automation started
log "Automation observing $HOSTS host\(s\)"

####################################################
# Variablen auslesen
# Dateien und Tabelle anlegen
####################################################

sleeph=`grep "^sleeph=" $CONF | cut -f 2 -d '"'`
sleepv=`grep "^sleepv=" $CONF | cut -f 2 -d '"'`

for host in `grep "^host_[0-9]*=" $CONF | cut -f 2 -d '"'`
do
       delay=`grep "^"$host"_delay=" $CONF | cut -f 2 -d '"'`
       boottime=`grep "^"$host"_boottime=" $CONF | cut -f 2 -d '"'`
       type=`grep "^"$host"_type=" $CONF | cut -f 2 -d '"'`
          
       type0_default=`grep "^"$host"_type0_default=" $CONF | cut -f 2 -d '"'`
       if [ "$type0_default" = "" ]
       then
           type0_default="no"
       fi
       
       type2_server=`grep "^"$host"_type2_server=" $CONF | cut -f 2 -d '"'`
       if [ "$type2_server" = "" ]
       then
           type2_server="no"
       fi
       type2_parm=`grep "^"$host"_type2_parm=" $CONF | cut -f 2 -d '"'`
       if [ "$type2_parm" = "" ]
       then
           type2_parm=0
       fi
       type3_file=`grep "^"$host"_type3_file=" $CONF | cut -f 2 -d '"'`
       if [ "$type3_file" = "" ]
       then
           type3_file="no"
       fi

       host_tab=$host_tab"$host $delay $boottime $type $type0_default $type2_server $type2_parm $type3_file " 
done

log "Parameter-Table initialized"

####################################################
# Fllen Variablen aus Tabellenwerten
####################################################

set_parm ()
{
    while [ "x$1" != "x" ]
    do
           if [ "$HOST" = "$1" ]
           then
               HOST=$1 
               delay=$2
               boottime=$3
               type=$4
               type0_default=$5
               type2_server=$6
               type2_parm=$7    
               type3_file=$8 
               return
           fi
            
           shift 8
    done
}

{
####################################################
# Pidfile schreiben
####################################################

echo $(ps | grep "$BIN_ROOT/automation.sh" | grep -v grep | cut -c 1-5) | cut -f 1 -d " " > $LOCKFILE

####################################################
# Prfen Status fr alle Gerte
####################################################

while [ true ]
do
       for HOST in `ls $WORK/pcs`; do

           ####################################################
           # Lesen aktueller Status aus Datei
           ####################################################
           
           set_parm $host_tab         
           read_file $HOST
           command=

           debug "Device $HOST current state $status"

           ####################################################
           # Verfgbarkeitstest
           ####################################################

           ###########
           # Manuell #
           ###########

           if [ $type -eq 0 ]
           then
               case $status in
                   0|10|20|30) newping=1
                               ;;
                  3|4|6|13|14) newping=1
                               ;;
                   1|11|21|31) newping=0
                               ;;
                       2|5|12) newping=0
                               ;;
                            9) if [ "$type0_default" = "start" ]
                               then
                                   newping=0
                               else                 
                                   newping=1
                               fi
                               ;;
               esac
           fi
           
           #################
           # Netzwerkfhig #
           #################
           
           if [ $type -eq 1 ]
           then
               fping -q -r 1 -t 500 -a $HOST >/dev/null 2>&1
               newping=$?
           fi
           
           #########################
           # Schalter mittels T-10 #
           #########################
           
           if [ $type -eq 2 ]
           then
               if [ `$BIN_ROOT/actorpoll $type2_server $type2_parm` -eq 0 ]
               then
                   newping=1
               else
                   newping=0
               fi
           fi  

           ###################
           # Logfile-Adapter #
           ###################
           
           if [ $type -eq 3 ]
           then
               if [ "$(ps | grep "tail" | grep -v grep | grep $type3_file)" = "" ]
               then
                   newping=1
               else
                   newping=0
               fi
           fi  

           ####################################################
           # verfgbar (ping ok)
           ####################################################

           if [ $newping -eq 0 ]
           then
               case $status in

          1|6|11|21|31) newstatus=$status
                        ;;

             0|4|10|14) newstatus=11
                        command=manual_start
                        ;;

                  2|12) newstatus=`expr $status - 1`
                        if [ `grep "^"$HOST"_groups=" $CONF | cut -f 2 -d '"'` -gt 0 ]
                        then
                            command=group_start
                        fi
                        ;; 

                  3|13) now=`date +%s`                     
                        diff=`expr $now - $timestamp`
                        if [ $diff -gt $boottime ]
                        then
                            newstatus=`expr $status - 2`
                        fi
                        ;;

                     5) now=`date +%s`
                        diff=`expr $now - $timestamp`
                        if [ $diff -gt $delay ]
                        then
                            newstatus=0
                            command=stop
                        fi
                        ;;

                     9) newstatus=1
                        ;;
               esac
           fi

           ####################################################
           # nicht verfgbar (ping nicht ok)
           ####################################################

           if [ $newping -ne 0 ]
           then
               case $status in

          0|6|10|20|30) newstatus=$status
                        ;;

                  1|11) newstatus=10
                        command=manual_stop
                        ;;

                  2|12) now=`date +%s`
                        diff=`expr $now - $timestamp`
                        if [ $diff -gt $boottime ]
                        then
                            newstatus=`expr $status - 2`
                        fi
                        ;;

                  3|13) if [ `grep "^"$HOST"_groups=" $CONF | cut -f 2 -d '"'` -gt 0 ]
                        then
                            if [ $delay -gt 0 ]
                            then
                                newstatus=`expr $status + 1`
                            else
                                newstatus=`expr $status - 3`
                                command=group_stop                                
                            fi
                        else
                            newstatus=`expr $status - 3`
                        fi
                        ;;

                  4|14) now=`date +%s`
                        diff=`expr $now - $timestamp`
                        if [ $diff -gt $delay ]
                        then
                            newstatus=`expr $status - 4`
                            command=group_stop
                        fi
                        ;;

                   5|9) newstatus=0
                        ;;
               esac
           fi

           ####################################################
           # neuen Status setzen und Groups verarbeiten
           ####################################################

           if [ $status != $newstatus ]
           then
               $BIN/status.sh $HOST $newstatus

               log "Device $HOST new state $newstatus"

               if [ `$BIN/status.sh $HOST maint` -eq 8 ]
               then
                   debug "Device $HOST in maintenance mode"
               else
                   if [ $command ]
                   then
                       $BIN/group.sh $HOST $command &
                       debug "Device $HOST command $command"
                   fi
               
                   case $newstatus in 
                         0|1|10|11|30|31) $BIN/child.sh $HOST &
                                          debug "Device $HOST child processing"
                                          ;;
                   esac
               fi
           fi


           if [ $ping != $newping ]
           then
               $BIN/status.sh $HOST `expr $newping + 40`
           fi

           newping=
           newstatus=

           sleep $sleeph
       done
       sleep $sleepv
done
} &

####################################################
# Ende
####################################################

exit $EXIT_SUCCESS