###########################################################################
# Anzeigen Tabelle Hosts
#
# Last Update: 24.06.2007 12:41 Einbau http-Link
#              18.10.2007 02:09 einmal lesen der Gertedatei anstatt grep
#
###########################################################################

echo '<table border=1 cellpadding=2 cellspacing=0 bgcolor=f0f0f0 bordercolor=#FFFFFF>'

echo '<tr bgcolor=000000>'
echo '<td align="center"><b><font color=#FFFFFF>'$_AUTO_host'</font></b></td>'
echo '<td align="left"><b><font color=#FFFFFF>'$_AUTO_text'</font></b></td>'
echo '<td align="center"><b><font color=#FFFFFF>'$_AUTO_type'</font></b></td>'
echo '<td align="center"><b><font color=#FFFFFF>'$_AUTO_ping'</font></b></td>'
echo '<td align="center"><b><font color=#FFFFFF>'$_AUTO_status'</font></b></td>'
echo '<td align="left"><b><font color=#FFFFFF>'$_AUTO_since'</font></b></td>'
echo '</tr>'

for host in `grep "^host_[0-9]*=" $CONF | cut -f 2 -d '"'`
do
      type=`grep "^"$host"_type=" $CONF | cut -f 2 -d '"'`
      http=`grep "^"$host"_http=" $CONF | cut -f 2 -d '"'`

      while read line
      do
            case $line in
                "status="*) status=`echo $line | cut -f 2 -d '"'` ;;
                  "ping="*) ping=`echo $line | cut -f 2 -d '"'` ;;
                  "date="*) date=`echo $line | cut -f 2 -d '"'` ;;
           esac
      done < $WORK/pcs/$host

      echo '<tr>'
      if [ "$http" = "" ]
      then
          echo '<td align="left">'$host'</td>'
      else
          echo '<td bgcolor="#F0E68C" align="left"><a href="'$http'" target="_self">'$host'</a></td>'
      fi
      if [ -e $WORK/maintenance/$host ]
      then
          echo '<td bgcolor="#999999" align="left"><b>'$_AUTO_maintenance'<b></td>'
      else
          case $status in
                0)  echo '<td bgcolor="#FF4D00" align="left">'$_AUTO_offline'</td>' ;;
                1)  echo '<td bgcolor="#66E500" align="left">'$_AUTO_online'</td>' ;;
                2)  echo '<td bgcolor="#E5FF00" align="left">'$_AUTO_starting'</td>' ;;
                3)  echo '<td bgcolor="#E5FF00" align="left">'$_AUTO_stopping'</td>' ;;
                4)  echo '<td bgcolor="#FF4D00" align="left">'$_AUTO_offline_group_wait'</td>' ;;
                5)  echo '<td bgcolor="#66E500" align="left">'$_AUTO_online_parent_wait'</td>' ;;
                6)  echo '<td bgcolor="#E5FF00" align="left">'$_AUTO_empty'</td>' ;;
                9)  echo '<td bgcolor="#E5FF00" align="left">'$_AUTO_initializing'</td>' ;;
               10)  echo '<td bgcolor="#FF4D00" align="left">'$_AUTO_manual_offline'</td>' ;;
               11)  echo '<td bgcolor="#66E500" align="left">'$_AUTO_manual_online'</td>' ;;
               12)  echo '<td bgcolor="#E5FF00" align="left">'$_AUTO_manual_starting'</td>' ;;
               13)  echo '<td bgcolor="#E5FF00" align="left">'$_AUTO_manual_stopping'</td>' ;;
               14)  echo '<td bgcolor="#FF4D00" align="left">'$_AUTO_manual_offline_group_wait'</td>' ;;
               30)  echo '<td bgcolor="#FF4D00" align="left">'$_AUTO_only_host_offline'</td>' ;;
               31)  echo '<td bgcolor="#66E500" align="left">'$_AUTO_only_host_online'</td>' ;;
                *)  echo '<td bgcolor="#66F0F0" align="left">'$_AUTO_unknown'</td>' ;;
          esac
      fi

      case $type in
            0) echo '<td align="center">'$_AUTO_manual'</td>' ;;
            1) echo '<td align="center">'$_AUTO_network'</td>' ;;
            2) echo '<td align="center">'$_AUTO_switch'</td>' ;;
            3) echo '<td align="center">'$_AUTO_logfile'</td>' ;;
            *) echo '<td align="center">'$type'</td>' ;;
      esac

      if [ $ping -eq 0 ]
      then
          echo '<td align="center">'$_AUTO_ok'</td>'
      else
          echo '<td align="center">'$_AUTO_not_ok'</td>'
      fi

      echo '<td align="center">'$status'</td>'
      echo '<td align="left">'$date'</td>'
      echo '</tr>'
done

echo '</table>'

###################### Ende ########################
