#!/bin/sh
#----------------------------------------------------------------------------
# Creation:    21.10.2006
# Author:      Roland Spitzer
#
# Last Update: 22.12.2006 22:24 v1.0.1 Einbau manual_start und manual_stop (manuell)
#              05.01.2007 05:27 v1.0.2 Befehle eingebaut
#                                      Bindestrich im Hostnamen auf Unterstrich gendert
#              03.02.2007 04:53 v1.0.2 Mehrspachigkeit
#              16.02.2007 00:19 v1.1.0 type 3 eingebaut
#              05.04.2007 04:24 v1.1.1 auf verschiedene cgi-files aufgeteilt
#              20.04.2007 03:14 v1.1.1 automation_action.cgi Eingaeb default eingebaut
#              29.05.2007 05:56 v1.1.3 Refresh fr Hosts eingebaut
#
#----------------------------------------------------------------------------
# get main helper functions
. /srv/www/include/cgi-helper

. /usr/local/bin/automation/prolog.inc

check_rights "automation" "view"

####################################################
# Variablen
####################################################

_start=$_AUTO_start
_stop=$_AUTO_stop
_showStatus=$_AUTO_showStatus
_showHosts=$_AUTO_showHosts
_showBefehle=$_AUTO_showBefehle
_showParameter=$_AUTO_showParameter
_showLogfile=$_AUTO_showLogfile
_showInfo=$_AUTO_showInfo
_refresh=`grep "^refresh=" $CONF | cut -f 2 -d '"'`

####################################################
# Standardaktion
####################################################

myname=`basename $0`
: ${FORM_action:=showStatus}

####################################################
# Routinen
####################################################

tab_kopf ()
{
    if [ "$LOG" = "yes" ]
    then
        show_tab_header "$_showStatus" "$myname?action=showStatus" \
                        "$_showHosts" "$myname?action=showHosts" \
                        "$_showBefehle" "$myname?action=showBefehle" \
                        "$_showParameter" "$myname?action=showParameter" \
                        "$_showInfo" "$myname?action=showInfo" \
                        "$_showLogfile" "$myname?action=showLogfile"
    else
        show_tab_header "$_showStatus" "$myname?action=showStatus" \
                        "$_showHosts" "$myname?action=showHosts" \
                        "$_showBefehle" "$myname?action=showBefehle" \
                        "$_showParameter" "$myname?action=showParameter" \
                        "$_showInfo" "$myname?action=showInfo" \
                        "no"
    fi
}

####################################################
# Verarbeitung
####################################################

if [ "$FORM_action" = "showHosts" ]
then 
    show_html_header "Automation-$_AUTO_version" "refresh=$_refresh;url=$myname?action=$FORM_action"
else
    show_html_header "Automation-$_AUTO_version"
fi

    # tab_kopf

####################################################
# Aktionen
####################################################

    case $FORM_extAction in

            $_start) . automation_start.cgi
                     tab_kopf
                     ;;

             $_stop) . automation_stop.cgi
                     tab_kopf
                     ;;

                 "") tab_kopf
                     break
                     ;;

                  *) . automation_action.cgi
                     tab_kopf
                     ;;
    esac

####################################################
# Anzeige-Aktionen
####################################################

    case $FORM_action in

            showStatus) . automation_status.cgi
                        ;;

             showHosts) . automation_hosts.cgi
                        ;;

           showBefehle) if [ $HOSTS -eq 0 ]
                        then
                            break
                        fi
                         
                        . automation_befehle.cgi 
                        ;;

         showParameter) if [ ! -f $CONF ]
                        then
                            echo $_AUTO_no_parm
                            break
                        fi
         
                        . automation_parameter.cgi
                        ;;

              showInfo) . automation_info.cgi
                        ;;

           showLogfile) if [ ! -f $LOGFILE ]
                        then
                            echo $_AUTO_no_logfile
                            break
                        fi
           
                        . automation_logfile.cgi
                        ;;
    esac

    show_tab_footer

show_html_footer