
#define REMOTE_CNT	11

#define F_ENABLEGROUP		0
#define F_COMMAND			1
#define F_VOLUMEMACRO		2
#define F_VOLUMEMACROD		3
#define F_CONFIG			4
#define F_REMOTE			5
#define F_SEND				6
#define F_PREKEY			7
#define IRDB_REM			8
#define IRDB_TYPEHEADER		9
#define IRDB_TYPEACTION		10

#define F_ERROR				99
#define F_MACRO				100

#define F_MAGIC				0x3542


#define PC_MASK				3
#define PC_RECV				1
#define PC_TRANS			2
#define PC_OFF				3

#ifdef	DETOMA

#define TRANSM_MASK			124

#define TRANSM_EXT1			4
#define TRANSM_EXT2			8
#define TRANSM_EXT3			16
#define TRANSM_EXT4			32
#define TRANSM_INTERN		64

#define TRANSM_ALL			TRANSM_MASK

#else

#define SBUS_MASK			12
#define SBUS_RECV			4
#define SBUS_TRANS			8
#define SBUS_OFF			12

#define TRANSM_MASK			48
#define TRANSM_INTERN		16
#define TRANSM_EXTERN		32
#define TRANSM_BOTH			TRANSM_MASK

#endif

#define ACC_WAIT			0xf0
#define ACC_REPEAT			0xf

#ifndef AVR
#pragma pack(1)
#endif

// Remote = 0: Globale Informationen

typedef struct {
	word dir_cnt;
	word data_pnt;
	word end_pnt;
	word magic;
	word checksum;

	byte trans_setup[REMOTE_CNT];
	byte align;
	word target_mask[REMOTE_CNT];
	word source_mask[REMOTE_CNT];
	unsigned long group_flags[REMOTE_CNT];
} FLASH_CONTENT;

typedef struct {
	FLASH_CONTENT f_content;
	word last_flashcommand;
	word command_repeat;
	unsigned long last_command_time;
	unsigned long prekey_timeout;
	byte pre_key;
} FLASH_CONTENT_MEMORY;


extern byte flash_mode;

#define	FLASH_MODE_TRANSLATOR		1
#define FLASH_MODE_IRDB				2


/* Struktur IRDB:

Alle Adressen relativ auf Nr. des Eintrags ??

0:	IRDB_TABLE
4:	IRDB_HEADER

hi:	HASH_ENTRY fr jedes IR Command -> PNT auf IRDB_IRCOMMAND
hc:	HASH_ENTRY fr jedes Command -> PNT auf IRDB_COMMAND
hr: HASH_ENTRY fr jede Remote -> PNT auf IRDB_REMOTE
c:	IRDB_COMMAND fr jedes Command -> PNT auf IRDB_REMOTE + IRDB_TIMING + IRDB_IRCOMMAND
i:	IRDB_IRCOMMAND fr jedes Command -> PNT auf IRDB_COMMAND 
r:	IRDB_REMOTE
t:	IRDB_TIMING
a:	IRDB_ACTION

*/


typedef struct {
	word remote_cnt;
	word remote_adr;
	word remote_hash_adr;
	word command_cnt;
	word ircommand_adr;
	word ircommand_hash_adr;
	byte return_stat_ok[21];
	byte return_stat_err[21];
	byte default_action[100];
} IRDB_TABLE;

typedef struct {
	word crc;
	word type;
	word len;
	IRDB_TABLE table;
} IRDB_HEADER;

typedef struct {
	word crc;
	word type;
	word len;
} IRDB_HEADER_ONLY;

typedef union {
	FLASH_CONTENT_MEMORY translation_mem;
	IRDB_TABLE irdb_mem;
} FLASH_COMMON_HEADER;

extern FLASH_COMMON_HEADER f_common;

typedef struct {
	byte name[80];
	word command_cnt;
	word command_hash;
	word command_adr;
} IRDB_REMOTE;


typedef struct {
	byte name[20];
	word timing_adr;
	word remote_adr;
	word ird_adr;
	word action_adr;
} IRDB_COMMAND;


typedef struct {
	byte ir_length;
	byte transmit_freq;
	byte mode;
	word pause_len[TIME_LEN];
	word pulse_len[TIME_LEN];
	byte time_cnt;
	byte ir_repeat;
	byte repeat_pause;
} IRDB_TIMING;

typedef struct {
	byte action_len;
	byte action_type;
	byte relais;
	byte action[1];
} IRDB_ACTION;

typedef struct {
	word command_adr;
	byte ir_length;
	byte ir_data[1];
} IRDB_IRCOMMAND;


#define IRDB_REMOTE_LEN ((sizeof (IRDB_REMOTE) + 1) / 2)
#define IRDB_COMMAND_LEN ((sizeof (IRDB_COMMAND) + 1) / 2)
#define IRDB_HEADER_LEN ((sizeof (IRDB_HEADER) + 1) / 2)
#define IRDB_TIMING_LEN ((sizeof (IRDB_TIMING) + 1) / 2)


#define CONTENT_LEN ((sizeof (FLASH_CONTENT) + 1) / 2)
#define HASH_LEN ((sizeof (HASH_ENTRY) + 1) / 2)


typedef struct {
	byte type;
	byte len;
	byte remote;
	byte group;
	word flash_adr;
	word source_mask;
	byte accelerator_timeout;
	byte accelerator_repeat;
	byte trans_setup;
	byte pre_key;
	byte data[1];
} FLASH_ENTRY;

typedef struct {
	byte type;
	byte len;
	byte remote;
	byte group;
	word flash_adr;
	word source_mask;
	byte accelerator_timeout;
	byte accelerator_repeat;
	byte trans_setup;
	byte cdata[1];
} FLASH_ENTRY_1;

typedef struct {
	word hashcode;
	word adr;
} HASH_ENTRY;

#ifdef AVR

typedef union {
   uint32_t Whole;
   struct 
   {
      byte Data;
      word Remainder;
      byte Head;
   } Part;
} CRC_BUFFER;

void PutCRC(byte b,CRC_BUFFER *crcb);
void CRCStart (CRC_BUFFER *crcb);
void CRCSet (CRC_BUFFER *crcb,byte *Data, word Length);
word CRC (CRC_BUFFER *crcb);

#endif

void flash_lan (void);
void init_irdb (void);
void flash_init (void);
void flash_ioinit (void);
void read_flash_directory (void);
byte flash_exec (byte adr,byte data[],byte len);
void load_flashcommand (word adr,IRDATA *ird);
void send_flashcommand (FLASH_ENTRY *fentry,byte num);
word find_flashentry (byte data[],byte len,word hpnt,FLASH_ENTRY *fentry);
byte compare_code (byte data[],byte len,word adr,FLASH_ENTRY *fentry);
word get_hashcode (byte data[],byte len);
void read_flashdata (byte *pnt,word adr,word cnt);
void write_flashdata (byte *pnt,word adr,word cnt);
void set_flashadr (word adr);
void read_nextflashdata (byte *pnt,word cnt);
void signal_error (void);
void set_commanddata (int pos,IRDATA *irpnt);
void switch_relay (byte val);
byte irdb_findircommand (byte ircommand[],byte irlen,byte adr,byte *data);
byte irdb_send_string (byte *str,byte len);
byte irdb_send (byte remote[],byte command[],byte led,word mask);
byte irdb_receive (byte ircommand[],byte len,IRRECEIVE *ir);
byte irdb_format_receive (byte ircommand[],byte len,IRRECEIVE *ir,word adr);
byte udp_format_data (IRRECEIVE *ir,byte *data);

