#!/bin/sh
#------------------------------------------------------------------------------
# main_lmsensors.cgi - show hardware sensor information                v 3.1.x
#                                                                        v 0.91
# Creation:     03.03.2005  gero
# Last Update:  01.10.2007  BGehl
#
#------------------------------------------------------------------------------

# Vaiables
FORM_action="view"
RTIME=60

# set lmsensors config variables
. /var/run/lmsensors.conf

# get main helper functions
. /srv/www/include/cgi-helper

# Security
check_rights "info" "$FORM_action"

# Check if sensors is running
#if [ ! -d /proc/sys/dev/sensors -o ! -f /usr/bin/sensors ]
if [ ! -f /usr/bin/sensors ]
then
    show_html_header "lm_sensors"
    show_error "lm_sensors v$lmsensors_version - Error" "lm_sensors not running or /usr/bin/sensors missing."
    show_html_footer
    exit 1
fi

# Check if sensor chip is available
#chips=`cat /proc/sys/dev/sensors/chips`
#if [ "$chips" = "" ] 
#then
#	show_html_header "lm_sensors"
#	show_error "lm_sensors v$lmsensors_version - Error" "No sensor chip found."
#	show_html_footer
#	exit 1
#fi

# HTML-Body
show_html_header "lm_sensors" "refresh=$RTIME;url=$myname;showmenu=yes"

show_tab_header "Hardware Sensor Status" "no"
echo "<p align=\"right\"> Last update: `date -R`</p>"
echo "<p><pre>"

/usr/bin/sensors | sed 's/[°]/\&deg;/g' | sed 's/\(.*ALARM*\)/<font color="#FD0000">\1 <\/font>/g'
  #| sed 's/.$/<br>/g'   CR ersetzen

echo "</pre></font></p>"
echo "<p align=\"center\"><br><small>Diese Seite erneuert sich automatisch alle $RTIME Sekunden.<br>lmsensors v$lmsensors_version</small></p>"

show_tab_footer

show_html_footer