#!/bin/sh

. /srv/www/include/cgi-helper

show_html_header "OPT_HTTP_Leases"

OPT_HTTP_LEASES_FILE="$DNSDHCP_LEASES_DIR/dnsmasq.leases"

#Sind berhaupt leases vorhanden?
if [ ! -f $OPT_HTTP_LEASES_FILE ];
then
		
		show_error "Fehler!" "Die Leasedatei <strong>$OPT_HTTP_LEASES_FILE</strong> ist nicht vorhanden.<br>Bitte berprfen Sie ob Sie den DHCP Server laufen haben."
	
else
	
	if [ -s $OPT_HTTP_LEASES_FILE ];
	then
		
		show_tab_header "DCHP-Leases aus $OPT_HTTP_LEASES_FILE" "no"
		
		echo "<table class=\"normtable\">"
		echo "<tr><td><center><b>Hostname</b></center></td><td><center><b>IP-Adresse</b></center></td><td><center><b>Mac-Adresse</b></center></td><td><center><b>Luft ab<br>(Datum-Uhrzeit)</b></center></td></tr>"

		datediff=`date +%z`
		datediff2=`expr $datediff "*" 36`

		cat $OPT_HTTP_LEASES_FILE |

		while read line
		do
			#Die Daten aus dem Leasefile einlesen und in Variablen packen
			
            set -f
			set -- `echo $line`
			
			time=$1
			mac=$2
			ip=$3
			hostname=$4
			
            set +f
            
			#Zeit umrechnen und nachschauen ob der Lease berhaupt abluft
			
			if [ $time -eq 0 ];
			then
				time2="niemals"
			else
				time=`expr $time "+" $datediff2`
				time2=`date -d "1970.1.1-0:0:$time" +%d.%m.%Y'&nbsp;'%H:%M:%S`
			fi
	
			#Alles ausgeben
			echo "<tr><td><center>$hostname</center></td><td><center>$ip</center></td><td><center>$mac</center></td><td><center>$time2</center></td></tr>"

		done
		
		echo "</table>"
		show_tab_footer
		
	else
	
		show_info "Information" "Es sind keine Leases in der Datei <strong>$OPT_HTTP_LEASES_FILE</strong> vorhanden."
		
	
	fi
	
fi

# HTML Ende 
show_html_footer