/* fax.cpp

demonstration routines for the fax capabilities of the SimpleCapi interface.

Part of the caiviar package. 

Copyright (c) 2002 Matthias Kramm <kramm@quiss.org>

This file is distributed under the GPL, see file COPYING for details. */

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <malloc.h>
#include <SimpleCapi.h>

/*
   Notice:
   All data to be faxed must either be ASCII or SFF.

   You can convert to SFF from pnm (pnm2sff) and 
   postscript.  (ghostscript -sDEVICE=cfax)

*/

int main(int argn, char*argv[]) 
{
    Logger * log = new Logger(5);
    SimpleCapi capi(log);
    int line=capi.open("33");
    if (line<0) {
	printf("no free line\n");
	return 1;
    }
    int ret;
    ret = capi.fax (line, "1234567", "myfax.sff");
    if(!ret)
	printf("Fax failed\n");
    capi.close(line);
    return 0;
}

