public class CapiEvent
{
    static final int TIMEOUT=0;
    static final int CAPI_EVENT_HANGUP=1;    // connection got terminated
    static final int CAPI_EVENT_INCOMING=2;  // incoming call
    static final int CAPI_EVENT_DONE=3;      // job is done
    static final int CAPI_EVENT_DIALTONE=4;  // other end pressed some keys
    static final int CAPI_EVENT_CONNECTED=5; // an outgoing call got answered
    
    static final int CAPI_REASON_TECHNICAL=1;
    static final int CAPI_REASON_BUSY=2;
    static final int CAPI_REASON_WRONGNUMBER=3; //"kein anschluss unter dieser nummer" - in germany
    static final int CAPI_REASON_REJECTED=4;
    static final int CAPI_REASON_NOANSWER=5;   //other end didn't answer in time

    public int id;
    public int type;
    public String msisdn;
    public String called_msisdn;

    public int jobid;  // only set if type==CAPI_EVENT_DONE
    public char tone;   // only set if type==CAPI_EVENT_DIALTONE
    public int reason; // only set if type==CAPI_EVENT_HANGUP
    
    /**
     * convert an event to a string.
     * @returns  The event string. e.g. "INCOMING msisdn=1234"
     */
    public String toString()
    {
	String name = "";
	switch(type)
	{
	    case TIMEOUT:
		name="TIMEOUT";
	    break;
	    case CAPI_EVENT_HANGUP:
		name="HANGUP"+" reason="+reason;
	    break;
	    case CAPI_EVENT_INCOMING:
		name="INCOMING";
	    break;
	    case CAPI_EVENT_DONE:
		name="DONE"+" job="+jobid;
	    break;
	    case CAPI_EVENT_DIALTONE:
		name="DIALTONE"+" tone="+tone;
	    break;
	    case CAPI_EVENT_CONNECTED:
		name="CONNECTED";
	    break;
	    default:
		name="*UNKNOWN*";
	    break;
	}
	name += " msisdn="+msisdn;
        return name;
    }
    
};

