/* outgoing.cpp

some demonstration routines for the SimpleCapi interface.

Part of the caiviar package. 

Copyright (c) 2002 MobileX AG, http://www.mobilexag.de
Copyright (c) 2002 Matthias Kramm <kramm@quiss.org>

This file is distributed under the GPL, see file COPYING for details. */

#include <stdlib.h>
#include <stdio.h>
#include <SimpleCapi.h>

int main(int argn, char*argv[]) 
{
    Logger* log = new Logger(LOGLEVEL_DEBUG);
    SimpleCapi capi(log);
    
    int line=capi.open("33");
    if (line<0) {
	printf("no free line\n");
	return 1;
    }
    int ret;
    ret = capi.call (line, "45", 60);
    if (ret) {
	if(ret == CAPI_REASON_TECHNICAL)
	    printf("couldn't call\n");
	else if(ret == CAPI_REASON_BUSY)
	    printf("busy\n");
	else if(ret == CAPI_REASON_REJECTED)
	    printf("rejected\n");
	else if(ret == CAPI_REASON_NOANSWER)
	    printf("didn't pick up\n");
	else if(ret == CAPI_REASON_WRONGNUMBER)
	    printf("unassigned number\n");
	return 0;
    }

    int playjob = capi.play (line,"welcome.wav");
    int playing = 1;
    char tonebuf[5];
    int tonepos = 0;
    int done = 0;
    while (playing) {
	ISDNEvent event = capi.listen(line, 0);
	switch (event.type) {
	case CAPI_EVENT_HANGUP:
	    printf ("hung up\n");
	    return 0;

	case CAPI_EVENT_DONE:
	    if (event.jobid == playjob)
		playing = 0;
	    break;

	case CAPI_EVENT_DIALTONE:
	    if (playing) {/* barge in */
		capi.stop (line, playjob);
		playing = 0;
	    }
	    if (event.tone >= '0' && event.tone <= '9')
		tonebuf[tonepos++] = event.tone;
	    if (tonepos == 5)
		done=1;
	    break;
	default:
	    printf ("Unexpected: %s\n", capi.eventToString (&event));
	    break;
	}
    }
    capi.hangup (line);
    capi.close (line);
    return 0;
}

