/*
 * Decompiled with CFR 0.152.
 */
package caivar;

import caivar.CapiEvent;
import caivar.CommandFailedException;
import caivar.NoLineFreeException;
import caivar.SimpleCapi;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public final class Main {
    private static SimpleCapi capi = null;
    private static Options options = null;
    private static final int ERRORCODE = -1;
    private static final String RX_NUMBER2CALLFORMAT = "[+]?[\\d ]+";
    private static final String RX_DTMFFORMAT = "[\\d*#]+";
    private static final String RX_NUMBERFORMAT = "[\\d]+";
    private static final int DEFAULTTIMEOUT = 60;
    private static final int DEFAULTPORT = 7474;
    private static final String DEFAULTHOST = "127.0.0.1";
    private static final int MAXPORT = 65535;
    private static final int MAXREADOUTLENGTH = 65535;
    private static final int CALL = 0;
    private static final int FAX = 1;
    private static final int PLAY = 2;
    private static final int DTMF = 3;
    private static final int READOUT = 4;
    private static int iAction = -1;
    private static boolean debug = false;
    private static CommandLine line = null;
    private static String dtmf = null;
    private static String number2call = null;
    private static String action = null;
    private static int callTimeout;
    private static String filename;
    private static String leftOverArg0;
    private static int serverPort;
    private static String serverAddress;
    private static InetAddress serverInetAddress;
    private static final ArrayList allowed_actions;
    private static final ArrayList allowed_faxExtension;
    private static final ArrayList allowed_playExtension;
    private static File faxFile;
    private static File playFile;

    public static void main(String[] args) {
        block22: {
            allowed_actions.add("call");
            allowed_actions.add("dtmf");
            allowed_actions.add("fax");
            allowed_actions.add("speak");
            allowed_actions.add("play");
            allowed_faxExtension.add("html");
            allowed_faxExtension.add("ps");
            allowed_faxExtension.add("sff");
            allowed_playExtension.add("wav");
            allowed_playExtension.add("la");
            Main.buildOptions();
            Main.parseOptions(args);
            if (number2call.equalsIgnoreCase("")) {
                Main.log("Number2call not specified", true);
                System.exit(-1);
            }
            if (action.equalsIgnoreCase("call")) {
                iAction = 0;
            } else if (action.equalsIgnoreCase("fax")) {
                iAction = 1;
                faxFile = new File(filename);
                if (!Main.validFile(faxFile, allowed_faxExtension)) {
                    Main.log("invalid file " + faxFile.getName() + " to fax", true);
                    System.exit(-1);
                }
            } else if (action.equalsIgnoreCase("play")) {
                iAction = 2;
                playFile = new File(filename);
                if (!Main.validFile(playFile, allowed_playExtension)) {
                    Main.log("invalid file " + playFile.getName() + " to play", true);
                    System.exit(-1);
                }
            } else if (action.equalsIgnoreCase("dtmf")) {
                iAction = 3;
                if (leftOverArg0.equals("") || !leftOverArg0.matches(RX_DTMFFORMAT)) {
                    Main.log("DTMF " + leftOverArg0 + " has invalid format", true);
                    System.exit(-1);
                }
            } else if (action.equalsIgnoreCase("speak")) {
                iAction = 4;
                if (leftOverArg0.equals("")) {
                    Main.log("You have to specify text to speak to callee", true);
                    System.exit(-1);
                }
            }
            Main.log("Connecting to " + serverInetAddress.getHostName() + " (" + serverInetAddress.getHostAddress() + ") + Port: " + serverPort, false);
            try {
                capi = new SimpleCapi(serverInetAddress.getHostName(), serverPort);
                if (capi.call(number2call, callTimeout) == 0) {
                    block21: {
                        Main.perform_action();
                        while (true) {
                            CapiEvent event = capi.listen(7);
                            Main.log("Event: " + event, false);
                            if (event.type == 0) {
                                if (iAction != 1 && iAction != 3) continue;
                                capi.hangup();
                                break block21;
                            }
                            if (event.type == 1) break block21;
                            if (event.type == 3) break;
                        }
                        capi.hangup();
                    }
                    Main.log("Call to " + number2call + " ended", false);
                    break block22;
                }
                Main.log("Couldn't connect to " + number2call + " within " + callTimeout + " sec!", false);
            }
            catch (IOException ex) {
                Main.log("IOException occured", true);
                ex.printStackTrace();
            }
            catch (NoLineFreeException ex) {
                Main.log("NoLineFreeException occured", true);
                ex.printStackTrace();
            }
            catch (CommandFailedException ex) {
                Main.log("CommandFailedException occured", true);
                ex.printStackTrace();
            }
        }
    }

    private static void play(File file) throws IOException, CommandFailedException {
        Main.transferFile(file);
        Main.log("playing file...", false);
        capi.play(file.getName());
        capi.del(file.getName());
    }

    private static void beep(String beepcode) throws IOException, CommandFailedException {
        Main.log("sending " + beepcode, false);
        capi.beep(beepcode);
    }

    private static void readOut(String text) throws IOException, CommandFailedException {
        Main.log("Speaking " + text, false);
        capi.speak(text);
    }

    private static void fax(File file) throws IOException, CommandFailedException {
        Main.transferFile(file);
        Main.log("faxing file" + file.getName() + " to number " + number2call, false);
        capi.fax(number2call, file.getName());
        Main.log("file faxed", false);
        capi.del(file.getName());
    }

    private static void transferFile(File file) {
        Main.log("Transfering file " + file.getAbsolutePath() + file.getName() + "...", false);
        try {
            capi.put(file.getAbsolutePath(), file.getName());
        }
        catch (CommandFailedException ex) {
            Main.log("Transfer of File " + file.getName() + " failed", true);
            System.exit(-1);
        }
        catch (IOException ex) {
            Main.log("IOException occured while transfering file " + file.getName(), true);
            System.exit(-1);
        }
        Main.log("File transfered", false);
    }

    private static void log(String message, boolean is_error) {
        if (is_error) {
            System.err.println("ERROR - " + message);
        } else if (debug) {
            System.out.println("INFO - " + message);
        }
    }

    private static boolean validFile(File file, ArrayList allowed_extensions) {
        String ext;
        boolean returncode = false;
        String filename = file.getName();
        String string = ext = filename.lastIndexOf(".") == -1 ? "" : filename.substring(filename.lastIndexOf(".") + 1, filename.length());
        if (file.isFile() && file.canRead() && allowed_extensions.contains(ext.toLowerCase())) {
            returncode = true;
            Main.log(ext + " is a valid extension for action " + action, false);
        }
        return returncode;
    }

    private static void showUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("caiviarclient", options);
    }

    private static void buildOptions() {
        options = new Options();
        Option o_help = new Option("h", "help", false, "print this message");
        Option o_file = new Option("f", "file", true, "played to callee");
        o_file.setArgName("file");
        Option o_debug = new Option("v", "verbose", false, "show extended status messages");
        Option o_action = new Option("a", "action", true, "specifies action to perform\nmust be one of call|dtmf|play|fax|speak");
        o_action.setArgName("action");
        Option o_number2call = new Option("n", "number", true, "number to call");
        o_number2call.setArgName("nr");
        Option o_serverport = new Option("p", "port", true, "port capiserver is listening on");
        o_serverport.setArgName("port");
        Option o_serveraddress = new Option("s", "server", true, "address of capiserver");
        o_serveraddress.setArgName("server");
        Option o_timeout = new Option("t", "timeout", true, "number of seconds to wait for an answer while calling");
        o_timeout.setArgName("s");
        options.addOption(o_help);
        options.addOption(o_debug);
        options.addOption(o_action);
        options.addOption(o_number2call);
        options.addOption(o_file);
        options.addOption(o_serverport);
        options.addOption(o_serveraddress);
        options.addOption(o_timeout);
    }

    private static void parseOptions(String[] args) {
        GnuParser parser = new GnuParser();
        try {
            line = parser.parse(options, args);
            if (line.getOptions().length == 0 || line.hasOption("h")) {
                Main.showUsage();
                System.exit(0);
            }
            if (line.hasOption("v")) {
                debug = true;
            }
            if (allowed_actions.contains((action = line.getOptionValue("a", "")).toLowerCase())) {
                Main.log("performing action " + action, false);
            } else {
                Main.log("action \"" + action + "\" not valid", true);
                Main.showUsage();
                System.exit(-1);
            }
            number2call = line.getOptionValue("n", "");
            Main.log("number2call: " + number2call, false);
            if (number2call.matches(RX_NUMBER2CALLFORMAT)) {
                Main.log("Calling " + number2call, false);
            } else {
                Main.log("number " + number2call + " has wrong format\n" + "try something like [+] 49 111 12341 4231", true);
                System.exit(-1);
            }
            if (line.hasOption("p")) {
                if (line.getOptionValue("p").matches(RX_NUMBERFORMAT)) {
                    serverPort = Integer.parseInt(line.getOptionValue("p"));
                    if (serverPort > 65535) {
                        Main.log("WARNING - Invalid server port: " + line.getOptionValue("p"), false);
                        Main.log("          using default value: 7474", false);
                        serverPort = 7474;
                    }
                } else {
                    Main.log("WARNING - Wrong format of server port: " + line.getOptionValue("p"), false);
                    Main.log("          using default value: 7474", false);
                    serverPort = 7474;
                }
            } else {
                serverPort = 7474;
                Main.log("using default server port: 7474", false);
            }
            serverAddress = line.getOptionValue("s", String.valueOf(DEFAULTHOST));
            try {
                serverInetAddress = InetAddress.getByName(serverAddress);
            }
            catch (UnknownHostException ex) {
                Main.log("ERROR - Invalid server address", true);
                System.exit(-1);
            }
            if (line.hasOption("t")) {
                if (line.getOptionValue("t").matches(RX_NUMBERFORMAT)) {
                    callTimeout = Integer.parseInt(line.getOptionValue("t"));
                } else {
                    Main.log("WARNING - Wrong format of call timeout: " + line.getOptionValue("t"), false);
                    Main.log("          using default value: 60s", false);
                    callTimeout = 60;
                }
            } else {
                Main.log("using default timeout for call: 60s", false);
            }
            Main.log("Connecting to " + serverPort + serverAddress + callTimeout, false);
            if (line.getArgs().length > 0) {
                leftOverArg0 = line.getArgs()[0];
            }
            filename = line.getOptionValue("f", "");
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            Main.showUsage();
            System.exit(-1);
        }
    }

    private static void perform_action() {
        try {
            switch (iAction) {
                case 1: {
                    Main.log("faxing file " + faxFile.getName(), false);
                    Main.fax(faxFile);
                    break;
                }
                case 0: {
                    Main.log("call", true);
                    break;
                }
                case 3: {
                    Main.log("DTMF", true);
                    Main.beep(leftOverArg0);
                    break;
                }
                case 4: {
                    Main.log("Reading out text " + leftOverArg0 + " to callee", false);
                    Main.readOut(leftOverArg0);
                    break;
                }
                case 2: {
                    Main.log("Play file " + playFile.getName(), false);
                    Main.play(playFile);
                    break;
                }
                default: {
                    Main.log("unknown action", true);
                    break;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CommandFailedException e) {
            e.printStackTrace();
        }
    }

    private static String readTextFile(File f) throws IOException {
        String ret = null;
        char[] buffer = new char[65535];
        InputStreamReader r = new InputStreamReader(new FileInputStream(f));
        if (f.length() > 65535L) {
            Main.log("File " + f + " to long to read out", true);
            System.exit(-1);
        } else {
            r.read(buffer);
            ret = new String(buffer);
            Main.log("Content to read out: " + ret, false);
            ((Reader)r).close();
        }
        return ret;
    }

    static {
        leftOverArg0 = "";
        allowed_actions = new ArrayList();
        allowed_faxExtension = new ArrayList();
        allowed_playExtension = new ArrayList();
        faxFile = null;
        playFile = null;
    }
}

