#!/bin/sh
#------------------------------------------------------------------------------
# EditDNS - Updaten der DNS-Eintrge
#
# Creation:      27.03.2006	Christoph Fritsch <fli4l@dechristo.net>
# Last modified: 22.08.2007	Christoph Fritsch <fli4l@dechristo.net>
#
#------------------------------------------------------------------------------

. /srv/www/include/cgi-helper

is_running() {
	if ps | grep dnsmasq | grep -v grep >> /dev/null
	then
		return 1
	else
		return 0
	fi
}

case "$FORM_DNSENTRIES" in
"")
	check_rights "editdns" "show"
	show_html_header "EditDNS"
	show_tab_header "$_EDITDNS_header" "no"
	# show current hosts
	cat <<EOF
<FORM ACTION="$myname" method="post">
<DIV ALIGN=CENTER>
<P><TEXTAREA NAME="DNSENTRIES" ROWS="25" COLS="90" WRAP=OFF>
EOF

cat /etc/hosts

	cat <<EOF
</TEXTAREA></P></DIV>
<DIV ALIGN="CENTER"><P>
<INPUT TYPE="SUBMIT" NAME="$_EDITDNS_button" VALUE="$_EDITDNS_button">
</P></DIV></FORM>
EOF

;;
*)
	check_rights "editdns" "update"
	show_html_header "EditDNS" "refresh=5;url=main_editdns.cgi"
	show_tab_header "$_EDITDNS_header" "no"
	#Backup old config
	cp /etc/hosts /tmp/hosts.backup
	echo "$FORM_DNSENTRIES" >/etc/hosts
	dtou -s /etc/hosts

	killall -HUP dnsmasq
	#test if dnsmasq is running again; otherwise restore old config
	is_running
	if [ "$?" -eq "1" ]; then
		show_info "$_EDITDNS_update_info" "$_EDITDNS_update_message<a href=$myname>$_EDITDNS_update_url</a>."
	else
		show_error "$_EDITDNS_update_error"
		cp /tmp/hosts.backup /etc/hosts
		dnsmasq
	fi
;;
esac

show_tab_footer
show_html_footer
