#!/bin/sh

## -----------------------------------------------------------------------------
## cups.cgi - web interface for cups_epson_ink_view fli4l 3.0.0 version 0.1
##
## Erstell:              22.06.2006     chb
## Letzte Aenderung:     
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation in Version 2; Not any previous or future
## version.
##-------------------------------------------------------------------------------

# get main helper functions
. /srv/www/include/cgi-helper

# read fli4l-config for cups-device
. /boot/rc.cfg

# Security
check_rights "cups" "view"

myname=`basename $0`
: ${FORM_action:=CUPS_epson_ink}

show_html_header "$_CUPS_header - `eval echo '$_'$FORM_action`"
show_tab_header "$_CUPS_epson_ink" "$myname?action=CUPS_epson_ink"

case $FORM_action in

   *|epson_ink|CUPS_epson_ink)
       if [ -f /tmp/cups_epson.ink ]
       then
          rm /tmp/cups_epson.ink
       fi
       
       echo "<br><b><center>$_CUPS_epson_ink_scan1 '$CUPS_EPSON_PRINTER_DEV' $_CUPS_epson_ink_scan2</center></b>"
       echo "<b><center>---------------------------------------------------------------------------------------------------------------------</center></b>"      

       printer_info=`escputil -d -q -r $CUPS_EPSON_PRINTER_DEV`

       echo "<br><b>$_CUPS_epson_printer_info $printer_info </b></br>"
       echo "<br>"
       
       escputil -e -q -r $CUPS_EPSON_PRINTER_DEV | grep -v "Ink color" | sed s/'Photo Black'/\Photo_Black/g | sed s/'Light Cyan'/\Light_Cyan/g | sed s/'Light Magenta'/\Light_Magenta/g >> /tmp/cups_epson.ink

       # eigentlich ein bloeder Hack, aber da die Busybox cat, grep und die sonstigen Tools nur rudimentaer implementiert hat, muss man sich halt so behelfen ;-))
       if cat /tmp/cups_epson.ink | grep -n " " > /dev/null
       then
         echo "<table class=\"normtable\">"
         echo "<tr><th>$_CUPS_epson_color</th><th>$_CUPS_epson_percent</th><th>$_CUPS_epson_partnumber</th><th>$_CUPS_epson_date</th></tr>"
         cat /tmp/cups_epson.ink | while read color percent partnumber date
         do
            echo "<tr>"
            echo "   <td>"
            echo "        <center><b>$color</b></center>"
            echo "   </td>"
            echo "   <td>"
            echo "   <table class=\"normtable\">"
            echo "      <tr>"
            echo "         <td><form action=\"$myname\" method=\"get\" class=\"usagetext\"><input type=\"Text\" name=\"inkusage\" id=\"inkusage\" value=\"$percent %\" size=\"6\" readonly></form></td>"
            echo "         <td id=\"ink1\" width=\"$percent\"></td>"
            echo "         <td id=\"ink2\" width=\"`expr 100 - $percent`\"></td>"
            echo "      </tr>"
            echo "   </table>"
            echo "   </td>"
            echo "   <td>"
            echo "        <center><b>$partnumber</b></center>"
            echo "   </td>"
            echo "   <td>"
            echo "        <center><b>$date</b></center>"
            echo "   </td>"
            echo "</tr>"
         done
         echo "</table>"   
       else        
          show_error "Information" "$_CUPS_epson_ink_scan_failure"
       fi
       ;;
esac

show_tab_footer
show_html_footer
