#!/bin/sh
# -----------------------------------------------------------------------------
# /usr/local/bin/forbiddendom.sh                         fli4l 3.0.[0|1]  0.9.0
#
# Creation:     24.09.2003  jml
# Last Update:  28.06.2006  mm
#
# Copyright (c) 2003 - 2005 Jrgen Mackiol <fli4l@juemac.de>
# Copyright (c) 2006        Matthias Mickler <mmweb@gmx.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# -----------------------------------------------------------------------------

. /var/run/forbiddendom.cfg

domconf="$FORBIDDENDOM_DIR/forbiddendom.conf"
dnsmasq_domconf="/etc/dnsmasq_forbiddendom.conf"
dnsmasq_pid=`cat /var/run/dnsmasq.pid`

dtou -s $domconf

if [ -f $dnsmasq_domconf ]
   then
       > $dnsmasq_domconf
       sed 's/^\(.*\)$/address=\/\1\/127.0.0.1/' $domconf >> $dnsmasq_domconf
       chown dns:dns $dnsmasq_domconf
       chmod 644 $dnsmasq_domconf
       kill $dnsmasq_pid
       sleep 2
       /usr/sbin/dnsmasq
       colecho 'new forbidden domains added to dnsmasq.conf' gn
    else
       colecho 'ups, NO /etc/dnsmasq_forbiddendom.conf available' rd
fi
