#----------------------------------------------------------------------------
# /usr/local/bin/newfax.sh - process received faxes              3.0.1
#
# Creation:     28.09.2003  felix
# Last Update:  $Id: newfax.sh 10938 2006-02-06 00:51:18Z hh $
#----------------------------------------------------------------------------

exec > /dev/null 2>&1 < /dev/null

gzip < "$1" > "$1.sff.gz"

case $? in
    0)
        rm "$1"
        file="$1.sff.gz"
    ;;
    *)
        # remove the damaged file just to be sure
        rm -f "$1.sff.gz"
        # rename the file to make it recognizeable
        mv "$1" "$1.sff"
        file="$1.sff"
        # and output a warning
        facility="newfax.sh"
        message="ERROR gzipping the file $file! Probably not enough memory?"
        if [ -f /usr/bin/logger -o -L /usr/bin/logger ]
        then
            logger -t "$facility" "$message"
        else
            colecho "$facility: $message" br x br > /dev/console 2>&1
        fi
    ;;
esac

case x$FAXRCV_DIRECTORY in
    x) ;;
    *)
        SENDER=`echo $1 | cut -c 14-`
        PAGES=`echo $1 | cut -c 3-5 | sed 's/^[0]*//'`
        case x$SENDER in
            x) SENDER="?" ;;
        esac
        LANGDATUM=`date +%d.%m.%y`
        LANGZEIT=`date +%H:%M:%S`
        echo "$LANGDATUM $LANGZEIT $SENDER $PAGES $file" >> $FAXRCV_DIRECTORY/mfax.log
        case x"$FAXRCV_IMONC_DIR" in
            x) ;;
            *) echo "$LANGDATUM $LANGZEIT $SENDER $PAGES $FAXRCV_DIRECTORY/$file" >> $IMOND_DIRECTORY/mfax.log ;;
        esac
    ;;
esac

[ 0$FAXRCV_NTFYCMD_N -eq 0 ] || for idx in `seq 1 $FAXRCV_NTFYCMD_N`
do
    eval ntfycmd='$FAXRCV_NTFYCMD'_$idx
    $ntfycmd "$FAXRCV_DIRECTORY/$file" $FAXRCV_CSID
done
