#!/bin/sh
#-----------------------------------------------------------------------------
#                                                                 3.0.1
# /srv/www/admin/faxrcv.cgi - display received faxes from OPT_FAXRCV
#
# Creation:     28.09.2003  felix
# Last Update:  $Id: faxrcv.cgi 10901 2006-01-31 12:31:25Z hh $
#-----------------------------------------------------------------------------

# get main helper functions
. /srv/www/include/cgi-helper

# some necessary language variables
_faxrcvtitle="Faxempfang Weboberflche  (3.0.1)"
_showfaxes="Faxe anzeigen"
_showcontrol="Faxempfang starten / stoppen"

# This script can be called with the following parameters
# ----------------------------------------------------------------------------
# Parameter    | Value                    | Meaning
# ----------------------------------------------------------------------------
# action       | showfaxes                | Show faxes in the tab "item"
#              | showcontrol              | Show Deamon-Control in the tab "item"
#              | deletefax                | Delete the fax in "item"
#              | viewfax                  | Display fax in "item" in browser
#              | downloadfax              | Download fax in "item"
#              | start, stop              | Start or stop the capifaxrcvd
# item         | depening on action       | The item "action" should process
# page         | number                   | Used in conjunction with viewfax
#              |                          | Returns given page as JPG
# number       | number                   | selects capifaxrcvd with specified number
# message      | string                   | some status message that is shown
#              |                          | on the generated page

## sanitize the input
FORM_action=`echo "$FORM_action"   | sed "s/[^a-zA-Z]//g"`
FORM_item=`echo "$FORM_item"       | sed "s/[^-_+.a-zA-Z0-9]//g"`
FORM_page=`echo "$FORM_page"       | sed "s/[^0-9]//g"`
FORM_number=`echo "$FORM_number"   | sed "s/[^0-9]//g"`

SEC_REALM='isdnfax'
case $FORM_action in
	deletefax) SEC_ACTION='delete' ;;
	start|stop) SEC_ACTION='startstop' ;;
	*) SEC_ACTION='view' ;;
esac

# Security
check_rights 'isdnfax' "$SEC_ACTION"

## get some internal variables
. /var/run/fax.conf

: ${FORM_number:="1"}
: ${FORM_action:="showfaxes"}
eval FAXDIR='$FAXRCV_'$FORM_number'_DIRECTORY'
MFAX_LOG="$FAXDIR""/mfax.log"
MFAX_TMP="$FAXDIR""/mfax.tmp"
CONVERTDIR="$FAXDIR/converttemp"
CONVERTNAME="fax"


## ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
## show_page_header: output opening html-statements
## ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#
# background: this function outputs not only html-headers such as title but
#     but also the selection box for the fax number and a user message
#     requested through http-get if any.
show_page_header ()
{
	show_html_header "$_faxrcvtitle"
	show_tab_header "" no
	cat <<EOF
      <form name="num_select" action="$myname">
        Faxnummer:
        <input type="hidden" name="action" value="$FORM_action">
        <input type="hidden" name="item" value="$FORM_item">
        <select name="number" class="inputs" onchange="JavaScript:submit()">
          <option disabled>FaxMSN &nbsp; &nbsp; &nbsp;Status Anz</option>
EOF
	FAX_STATUS_ALL=`ps -ax | grep capifaxrcvd | grep -v grep`
	for NUMBER_IDX in `seq 1 $FAXRCV_N`
	do
		FAX_STATUS="$( [ "`echo "$FAX_STATUS_ALL" | grep -e "-l \`eval echo $'FAXRCV_'$NUMBER_IDX'_NUMBER'\`"`" ] && echo 'Ein' || echo 'Aus' )"
		FAX_COUNT="(`grep -c "" \`eval echo $'FAXRCV_'$NUMBER_IDX'_DIRECTORY'\`/mfax.log`)"
		echo "    <option `[ "$NUMBER_IDX" = "$FORM_number" ] && echo "selected " `value=\"$NUMBER_IDX\">\
		`echo \`eval echo $'FAXRCV_'$NUMBER_IDX'_NUMBER'\`........... | cut -c-12 | sed "s/\./\&nbsp;/g"`>$FAX_STATUS< &nbsp;$FAX_COUNT</option>"
	done
	echo "  </select>&nbsp;&nbsp;<input type=submit value=\" Zeige \"></form>"

	show_tab_footer

	if [ -n "$FORM_message" ]
	then
		echo "<br />"
		message_type=`echo "$FORM_message"   | cut -d"|" -f1 -s`
		message_header=`echo "$FORM_message" | cut -d"|" -f2 -s`
		message_body=`echo "$FORM_message"   | cut -d"|" -f3-`
		
		case $message_type in
			E) show_error "$message_header" "$message_body" ;;
			*) show_info  "$message_header" "$message_body" ;;
		esac
	fi
	
	echo '<br />'
	show_tab_header "$_showfaxes" "$myname?action=showfaxes&amp;number=$FORM_number" \
	                "$_showcontrol" "$myname?action=showcontrol&amp;number=$FORM_number"
}

## ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
## show_page_footer: output closing html-statements on bottom of page
## ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
show_page_footer ()
{
	show_tab_footer
	show_html_footer
}

## ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
## url_encode: encode string for usage in HTTP-GET-URL
## ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#
# background: this function does not encode any string. it only encodes
#     characters usually found textual strings. so exspect things to break on
#     user input!
#
# @ params    string        string to be encoded
# @ returns   enc_string    the url-encoded version of string
url_encode ()
{
	echo "$1" |
		sed 's/%/%25/g
		     s/ /%20/g
		     s/	/%09/g
		     s/!/%21/g
		     s/"/%22/g
		     s/#/%23/g
		     s/\$/%24/g
		     s/\&/%26/g
		     s/'\''/%27/g
		     s/(/%28/g
		     s/)/%29/g
		     s/\*/%2a/g
		     s/+/%2b/g
		     s/,/%2c/g
		     s/-/%2d/g
		     s/\./%2e/g
		     s/\//%2f/g
		     s/:/%3a/g
		     s/;/%3b/g
		     s/</%3c/g
		     s/\=/%3d/g
		     s/>/%3e/g
		     s/?/%3f/g
		     s/@/%40/g
		     s/\[/%5b/g
		     s/\\/%5c/g
		     s/\]/%5d/g
		     s/\^/%5e/g
		     s/_/%5f/g
		     s/`/%60/g
		     s/{/%7b/g
		     s/|/%7c/g
		     s/}/%7d/g
		     s/~/%7e/g
		     s//%f6/g
		     s//%fc/g
		     s//%e4/g
		     s//%d6/g
		     s//%dc/g
		     s//%c4/g
		     :a
		     $!{N
		     ba
		     }
		     s/\n/%0d/' || return 1
		     # the last five lines are the reason why sed is uncool - just
		     # replacing the newlines by %0d
}

## ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
## ensure_compatibility: backwards compatibility with older version of faxrcv
## ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# background: in earlier version of OPT_FAXRCV mfax.log always contained
#     something.sff in mfax.log even if the actual local file was compressed
#     using gzip (something.sff.gz). This behaviour changed as of 2.1.12 so
#     now we may have gzipped and non-gzipped files peacefully side by side.
#     this function may be used to make sure things dont break anyhow.
#
# @ params    filename      the filename to check
#             faxdir        where to look for the file (will _not_ be returned)
#                           may be empty
# @ returns   filename      if filename exists or filename.gz does not exists
#             filename.gz   otherwise (! -f filename && -f filename.gz)
ensure_compatibility ()
{
	filename="$1"
	faxdir="$2"
	
	case x"$faxdir" in
		x) fullname="$filename" ;;
		*) fullname="$faxdir/$filename" ;;
	esac
	
	if [ -n "$filename" -a ! -f "$fullname" -a -f "$fullname".gz ]
	then
		echo "$filename".gz
	else
		echo "$filename"
	fi
}

## ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
## find_mfax_entry: return mfax-infoline for the respective fax file
## ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# background: to preserve mgetty compatibility, faxrcv stores information on
#     the received files in mfax.log format. each line contains the following
#     information:
#       date_received time_received remote_stationid num_pages filename
#     this function returnes the matching lines from mfaxfile for the
#     respective faxfile. as filename used to be file.sff in earlier versions
#     regardless of gzip being used (in that case the actual filename was
#     file.sff.gz on the disk) we use some magic to allow for backwards
#     compatibility.
#
# @ params    mfaxfile      full path to the mfax.log file to read from
#             faxname       name of the filename on disk to look for
# @ returns   infoline      the full line as described above
find_mfax_entry ()
{
	mfaxfile="$1"
	faxname="$2"
	
	faxname_comp=`echo $faxname|sed 's/\.gz$//'`
	echo `grep "\($faxname\|$faxname_comp\)$" "$mfaxfile"`
}

## ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
## delete_mfax_entry: deletes mfax entry for specified file
## ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# @ params    mfaxfile      full path to the mfax.log file to read from
#             faxname       name of the filename on disk to look for
# @ returns   0             if deletions have been made
#             1             if the entry for faxname could not be found or
#                           an error occurred
delete_mfax_entry ()
{
	mfaxfile="$1"
	mfaxfile_temp="`dirname "$mfaxfile"`/mfax.tmp"
	faxname="$2"
	faxname_sed=`echo "$faxname" | sed 's/\./\\\./g'` # escape "." for sed
	#	(its the only char we need to escape - see sanity-check above)
	
	# return if we dont have such an entry
	grep -qe " $faxname\$" "$mfaxfile" || return 1
	# remove the line corresponding with the deleted file
	sed "/ $faxname_sed\$/d" "$mfaxfile" > "$mfaxfile_temp"
	# replace mfax.log
	mv -f "$mfaxfile_temp" "$mfaxfile" || return 1
}

# Main stuff
case "$FORM_action" in

showfaxes)
### SHOWFAXES #################################################################
	case "$FORM_item" in
		"") MENU_SELECTED="Faxe" ;;
		*) MENU_SELECTED="$FORM_item" ;;
	esac

	show_page_header

	if [ -s "$MFAX_LOG" ]
	then
		cat <<EOF
<table class="normtable">
  <tr>
    <th>Datum/Zeit</th>
    <th>Fax-ID</th>
    <th>Seiten</th>
    <th>Datei</th>
    <th>Aktionen</th>
  </tr>
EOF
		sed '1!G;h;$!d' "$MFAX_LOG" | while read d z i p f
		do
			# + is not allowed in QUERY_STRING but in filenames
			qf=`echo "$f" | sed "s/\+/%2B/g"`
			# "_" is a replacement for " "
			# i=`echo "$i" | sed "s/_/\&nbsp;/g"`
			cat <<EOF
<tr class="listitem$ITERATE">
  <td align="center">$d/$z</td>
  <td><b>$i</b></td>
  <td align="center">$p</td>
  <td>$f</td>
  <td align="center">
EOF
			case $FAXRCV_HTTPGUI_CONVERT in
				yes)
					cat <<EOF
    <a href="$myname?action=viewfax&amp;number=$FORM_number&amp;item=$qf">
      <img src="/img/fax_view.gif" border="0" width="21" height="16" alt="Ansehen" title="Ansehen">
    </a>
EOF
				;;
			esac
			cat <<EOF
    <a href="$myname?action=downloadfax&amp;number=$FORM_number&amp;item=$qf">
      <img src="/img/fax_download.gif" border="0" width="21" height="16" alt="Download" title="Download">
    </a>
    <a href="$myname?action=deletefax&amp;number=$FORM_number&amp;item=$qf" onclick="return confirm('Wirklich lschen?');">
      <img src="/img/fax_delete.gif" border="0" width="21" height="16" alt="Lschen" title="Lschen">
    </a>
  </td>
</tr>
EOF

			case "$ITERATE" in
				"") ITERATE="2" ;;
				*) ITERATE="" ;;
			esac
		done
		echo "</table>"
	else
		echo "Keine Faxe"
	fi
	show_page_footer
;;

showcontrol)
### SHOWCONTROL ###############################################################
	show_page_header

	cat <<EOF
<table class="normtable">
  <tr><th>
EOF
	echo "Faxempfang fr `eval echo $'FAXRCV_'$FORM_number'_NUMBER'` ist "

	if ps -ax | grep capifaxrcvd | grep -v grep | grep -qe "-l `eval echo $'FAXRCV_'$FORM_number'_NUMBER'`"
	then
		echo "<span class=\"faxrcvon\">AN</span>"
	else
		echo "<span class=\"faxrcvoff\">AUS</span>"
	fi
	cat <<EOF
    </th>
  </tr>
  <tr>
    <td align="center">
      [<a href="$myname?action=start&amp;number=$FORM_number">einschalten</a>]&nbsp;
      [<a href="$myname?action=stop&amp;number=$FORM_number">ausschalten</a>]
    </td>
  </tr>
</table>
EOF
	show_page_footer
;;

deletefax)
### DELETEFAX #################################################################
	# only go ahead if there was an entry in mfax.log that we could delete
	# in the first place
	if delete_mfax_entry "$MFAX_LOG" "$FORM_item"
	then
		# if it exists, we must delete the entry from the
		# imonc-log as well
		delete_mfax_entry "$FAXRCV_IMONC_DIR/mfax.log" "$FAXDIR/$FORM_item"
		file_on_hd=`ensure_compatibility "$FORM_item" "$FAXDIR"`
		rm -f "$FAXDIR/$file_on_hd"
		if [ "$?" = 1 -a -f "$FAXDIR/$file_on_hd" ]
		then
			# lschen war nicht erfolgreich und die datei existiert noch
			delete_error="Die Datei $FAXDIR/$file_on_hd konnte nicht entfernt werden!"
		fi
	else
		delete_error="Die Datei $FAXDIR/$FORM_item ist im Fax-Log nicht verzeichnet!"
	fi
	
	case $delete_error in
		"") message=`url_encode "I|Erfolgreich entfernt|Das Fax "$FAXDIR/$FORM_item" wurde erfolgreich entfernt."` ;;
		*)  message=`url_encode "E|Fehler beim Entfernen|$delete_error"` ;;
	esac
	
	echo "Location: $myname?action=showfaxes&number=$FORM_number&message=$message"
	echo
;;

viewfax)
### VIEWFAX ###################################################################
	case $FORM_page in
	"")
		# convert the fax and
		# show the page where all the images are included
		mkdir -p $CONVERTDIR
		rm -f "$CONVERTDIR/$CONVERTNAME"*

		file_on_hd=`ensure_compatibility "$FORM_item" "$FAXDIR"`

		if [ -f "$FAXDIR/$file_on_hd" ]
		then
			show_html_header "$_faxrcvtitle"

			if echo $file_on_hd | grep -qe "\.gz$"
			then
			    gzip -cd "$FAXDIR/$file_on_hd" > "$CONVERTDIR/$CONVERTNAME.sff" 2>/dev/console || show_error "Entpacken fehlgeschlagen" "gzip konnte $file_on_hd nicht erfolgreich entpacken.<br /> Mglicherweise ist die Datei beschdigt?"
			else
			    cp "$FAXDIR/$FORM_item" "$CONVERTDIR/$CONVERTNAME.sff" 2>/dev/console || show_error "Konnte nicht kopieren" "Die Faxdatei konnte nicht ins temporre Verzeichnis zum Konvertieren kopiert werden. Mglicherweise nicht genug Speicherplatz im Faxverzeichnis?"
			fi
			case "`echo $file_on_hd | cut -b1-2`" in
				fn) conv_option="-d" ;;
				*) conv_option="-j" ;;
			esac
				
			# creates $CONVERTDIR/$CONVERTNAME.001.jpg $CONVERTNAME.002.jpg etc.
			sff2misc $conv_option "$CONVERTDIR/$CONVERTNAME.sff" "$CONVERTDIR/$CONVERTNAME" >/dev/console 2>&1 || show_error "Konvertieren fehlgeschlagen" "sff2misc konnte $file_on_hd nicht erfolgreich nach JPG konvertieren.<br />Mglichweise ist die Datei beschdigt? "
			
			INFOLINE=`find_mfax_entry "$MFAX_LOG" "$file_on_hd"`
			case "$INFOLINE" in
				"") show_error "Nicht gefunden" "Die Datei $file_on_hd ist in $MFAX_LOG nicht als empfangenes Fax verzeichnet." ;;
				*)
					# d z i p f
					set -- $INFOLINE
					echo "<h1>$1 ($2) - Fax von $3</h1><h2>$file_on_hd</h2>"
					for idx in `seq 1 "$4"`
					do
						echo "<h3>Seite $idx</h3><br>"
						cat <<EOF
<div class="faxpage">
  <a href="$myname?action=viewfax&amp;number=$FORM_number&amp;item=&amp;page=$idx" target="_blank">
    <img align="center" src="$myname?action=viewfax&amp;number=$FORM_number&amp;page=$idx" alt="Seite $idx" width="500" border="0">
  </a>
</div>
EOF
					done
				;;
			esac
			show_html_footer
		else
			# we dont have that file...
			echo "Location: $myname?action=showfaxes&number=$FORM_number&message=`url_encode "E|Datei nicht gefunden|Die Datei "$FAXDIR"/"$FORM_item" existiert nicht."`"
			echo
		fi
	;;
	*)
		# return a specific page as JPG
		PADDED_PAGE=`echo "000$FORM_page" | sed "s/.*\([0-9]\{3\}\)/\1/"`
		echo "Content-Type: image/jpeg"
		echo
		cat "$CONVERTDIR/$CONVERTNAME.$PADDED_PAGE.jpg"
	;;
	esac
;;

downloadfax)
### DOWNLOADFAX ###############################################################
	FORM_item=`ensure_compatibility "$FORM_item" "$FAXDIR"`

	if [ -f "$FAXDIR/$FORM_item" ]
	then
		http_header download "ctype=application/download;filename=`echo "$FORM_item" | sed 's/\.gz$//'`"
		if echo $FORM_item | grep -qe "\.gz$"
		then
			gzip -cd "$FAXDIR/$FORM_item"
		else
			cat "$FAXDIR/$FORM_item"
		fi
	else
		echo "Location: $myname?action=showfaxes&number=$FORM_number&message=`url_encode "E|Datei nicht gefunden|Die Datei "$FAXDIR/$FORM_item" existiert nicht!"`"
		echo
	fi
;;

start)
### START #####################################################################
	# remove ANSI colors from output
	result=`faxrcv.sh start $FORM_number 2>&1 | sed "s/\[[0-9]*m//g"`
	case "$result" in
		"") result_message="";;
		*)  result_message="<pre>$result</pre>" ;;
	esac
	echo "Location: $myname?action=showcontrol&number=$FORM_number&message=`url_encode "$result_message"`"
	echo
;;

stop)
### STOP ######################################################################
	# remove ANSI colors from output
	result=`faxrcv.sh stop $FORM_number 2>&1 | sed "s/\[[0-9]*m//g"`
	case "$result" in
		"") result_message="";;
		*)  result_message="<pre>$result</pre>" ;;
	esac
	echo "Location: $myname?action=showcontrol&number=$FORM_number&message=`url_encode "$result_message"`"
	echo
;;

*)
	echo "Location: $myname?action=showfaxes&number=$FORM_number&message=`url_encode "E|Interner Fehler|Unbekannter Parameter. Bitte pr&uuml;fen sie die URL."`"
	echo
;;

esac

