
read_hosts ()
{
> /tmp/infobox.hosts

GetStatus () {
	status=`fping -r 1 -t 50 -a $1`
	if [ ! $status ]
	then
		status="offline"
	else
		status="online"
	fi
	echo $status
}

while read line
do
	case $line in 
		"# hostnames"*) break ;;
	esac
	case $line in 
		"#"*|*localhost*) continue ;;
	esac

	set -- $line
	status=`GetStatus $1`
	echo "$1 $2 $status" >> /tmp/infobox.hosts

done < /etc/hosts

if [ "$DHCPTYPE" = "DNSDHCP" ]
then
	case $LEASEFILE in
	"") ;;
	*)
		set -f
		while read line
		do
		set -- $line
		status=`GetStatus $3`
		grep -q "^$3 " /tmp/infobox.hosts || echo $3 $4 $status  >> /tmp/infobox.hosts
		done < $LEASEFILE
		set +f
	;;
	esac
fi
if [ "$DHCPTYPE" = "DHCP" ]
then

 echo #$DHCPTYPE

fi

sed -e "s/\([0-9]\{1,3\}\)\.\([0-9]\{1,3\}\)\.\([0-9]\{1,3\}\)\.\([0-9]\{1,3\}\)/00\1.00\2.00\3.00\4~\1.\2.\3.\4/" \
 -e "s/0\{0,2\}\([0-9]\{3\}\.\)0\{0,2\}\([0-9]\{3\}\.\)0\{0,2\}\([0-9]\{3\}\.\)0\{0,2\}\([0-9]\{3\}\)/\1\2\3\4/" \
 /tmp/infobox.hosts | sort -n | cut -d~ -f2- > /tmp/infobox.hosts
}

: ${FORM_action:="hosts"}



#--------------------------------------------------------------------------------------- Output
case $FORM_action in
hosts)
	read_hosts
echo '<div style="width:500px;text-align:right;margin-bottom:10px;"><a href="infobox.cgi?main=routing&action=show_forwarding">details &gt;</a></div>'	
	echo "<table class=\"normtable\">
			<tr>
			<th width=\"90\">ip</th>
			<th width=\"100\">name</th>
			<th width=\"120\">mac</th>
			<th width=\"32\">&#160;</th>
			<th width=\"32\">&#160;</th>
			</tr>"
	
	while read ip name status
	do
		if [ $name != $HOSTNAME ]
		then
		echo "<tr><td style=\"padding-left:5px;\">$ip</td><td style=\"padding-left:5px;\">$name</td>"
		
		case $ip in
			"") ;;
			*)
			set -f
			set -- `grep "$ip " /proc/net/arp`
			set +f
			#adress="$1" ; hwtype="$2" ; hwadress="$4" ; flag="$3" ; iface="$6" 
	
			if [ $4 ] && [ $4 != "00:00:00:00:00:00" ]
			then
				echo "<td style=\"padding-left:5px;\">$4</td>" 
			else
				echo "<td>&#160;</td>" 
			fi
		;;
		esac
		
		case $status in
			offline)
				echo "<td style=\"text-align: center;\"><img src=\"infobox/offline.gif\" border=0 alt=\"offline\"></td>"
			;;
			online)
				echo "<td style=\"text-align: center;\"><img src=\"infobox/online.gif\" border=0 alt=\"online\"></td>"
			;;
		esac
		
		case $ip in
		$HOSTNAME)
		echo "<td style=\"text-align: center\">&#160;</td>"
		;;
		*)
		state_host=`iptables -L FORWARD -n --line-numbers | grep "$ip " | grep "fw-drp-log"`
		state_est=`iptables -L FORWARD -n --line-numbers | grep "$ip " | grep "state RELATED,ESTABLISHED"`
			if [ "$state_host" = "" -a "$state_est" = "" ]
			then
				echo "<td style=\"text-align: center;padding:0px;\"><a href=\"infobox.cgi?main=routing&action=block&amp;host=$ip\"><img src=\"infobox/open.gif\" border=0  alt=\"open\"></a></td>"
			else
				echo "<td style=\"text-align: center;padding:0px;\"><a href=\"infobox.cgi?main=routing&action=unblock&amp;host=$ip\"><img src=\"infobox/locked.gif\" border=0 alt=\"locked\"></a></td>"
			fi
		;;
		esac
		echo "</tr>"
		fi
	done < /tmp/infobox.hosts
#--------------------------------------

	routerIp=`grep $HOSTNAME /tmp/infobox.hosts | cut -d " " -f 1`
	netSeq1=`echo $routerIp | cut -d "." -f 1`
	netSeq2=`echo $routerIp | cut -d "." -f 2`
	netSeq3=`echo $routerIp | cut -d "." -f 3`
	shortIp="$netSeq1.$netSeq2.$netSeq3."

		echo '<tr><th colspan="5" style="text-align:right;"><br>'

		echo '
			<style>
			input{
			background-color:white;
			}.button{
			border:solid 1px black;
			color:black;
			width:60px;
			height:19px;
			}</style>'
	echo "
			<table class="none">
			<tr>
			<form methode=post action=infobox.cgi>
			<td align=\"right\" style=\"border:none 0px;\">Ping all Clients from<input type=\"hidden\" name=\"offset\" value=\"$shortIp\"></td>
			<td style=\"border:none 0px;\"><input type=\"text\" size=\"3\" name=\"from\" value=\"1\" maxlength=\"3\"></td>
			<td align=\"right\" style=\"border:none 0px;\">to</td>
			<td style=\"border:none 0px;\"><input type=\"text\" size=\"3\" name=\"to\" value=\"254\" maxlength=\"3\"></td>
			<td align=\"right\" width=\"70\" style=\"border:none 0px;\"><input class=\"button\" type=\"submit\" value=\"Ping\"><input type=\"hidden\" name=\"main\" value=\"routing\"><input type=\"hidden\" name=\"action\" value=\"ping\"></td>
			</form>
			</tr></table>"

echo '</th></tr>'
#--------------------------------------	
	echo '</table>'

;;
block)
	sh /usr/local/bin/infobox_hosts.sh block $FORM_host
	echo "<script>location.href = \"infobox.cgi?main=routing&action=hosts\";</script>"
;;
unblock)
	sh /usr/local/bin/infobox_hosts.sh unblock $FORM_host
	echo "<script>location.href = \"infobox.cgi?main=routing&action=hosts\";</script>"
;;
ping)

    echo "<h3>Online Clients</h3>"
    echo "<pre>"

ip="$FORM_offset"
i="$FORM_from"
while [ $i -le "$FORM_to" ]
do
 fping -r 1 -t 10 -a $ip$i
 i=`expr $i + 1`
done
    echo "</pre>"
    echo '<a href="infobox.cgi?main=routing&action=hosts">back</a>'


;;
"show_forwarding")
echo '<div style="width:500px;text-align:left;margin-bottom:10px;"><a href="infobox.cgi?main=routing&action=hosts">&lt; back</a></div>'

chainName="FORWARD"
. infobox_chains.cgi





;;
esac
