#!/bin/sh
set_debug=no
. /srv/www/include/cgi-helper
. /var/run/infobox.conf
check_rights "infobox" "view"
show_html_header "Infobox"
cat <<-EOF
<style>
/* for MSIE only*/
* html, * html body {
    overflow:auto;
}
* html #header_container {
    padding-right: 0px;
}
* html #content {
    height: auto;
    width: auto;
}
</style>
<script type="text/javascript" src="infobox.js"></script>
EOF
echo '<table><tr><td>'
: ${FORM_main:=infobox}
case $FORM_main in
infobox)
: ${FORM_action:=fli4l}
if [ ! $FORM_action = "viewer" ] && [ ! $FORM_action = "shell" ]
then
echo '<table class="tabmain"><tr>'
echo "<th class=\"lbtab\"></th><th width=\"150\">Infobox</th><th class=\"rbtab\"></th>"
echo "<th class=\"lgtab\"></th><th class=\"link\" width=\"150\"><a href=\"infobox.cgi?main=routing\">Routing</a></th><th class=\"rgtab\"></th>"
echo "</tr></table>"
fi
Node_1="fli4l "
NodeTarget_1="infobox.cgi "
Node_2="Hardware "
NodeTarget_2="infobox.cgi?action=hardware "
if [ "$INFOBOX_PS" = "yes" ]
then
Node_3="Processes "
NodeTarget_3="infobox.cgi?action=prozesse "
fi
if [ "$INFOBOX_FILES" = "yes" ]
then
Node_4="Files "
NodeTarget_4="infobox.cgi?action=browser "
fi
case $FORM_action in
fli4l)
show_tab_header $Node_1 no $Node_2$NodeTarget_2$Node_3$NodeTarget_3$Node_4$NodeTarget_4
;;
hardware)
show_tab_header $Node_1$NodeTarget_1$Node_2 no $Node_3$NodeTarget_3$Node_4$NodeTarget_4
;;
prozesse)
show_tab_header $Node_1$NodeTarget_1$Node_2$NodeTarget_2$Node_3 no $Node_4$NodeTarget_4
;;
browser)
show_tab_header $Node_1$NodeTarget_1$Node_2$NodeTarget_2$Node_3$NodeTarget_3$Node_4 no
;;
esac
;;
routing)
: ${FORM_action:=routeinfo}
if [ ! $FORM_action = "ping" ]
then
echo '<table class="tabmain"><tr>'
echo "<th class=\"lgtab\"></th><th class=\"link\" width=\"150\"><a href=\"infobox.cgi\">Infobox</a></th><th class=\"rgtab\"></th>"
echo "<th class=\"lbtab\"></th><th width=\"150\">Routing</th><th class=\"rbtab\"></th>"
echo "</tr></table>"
fi

Node_1="Info "
NodeTarget_1="infobox.cgi?main=routing "

if [ "$INFOBOX_HOSTS" = "yes" ]
then
	Node_2="Hosts "
	NodeTarget_2="infobox.cgi?main=routing&action=hosts "
fi
if [ "$INFOBOX_INPUT" = "yes" ]
then
	Node_3="Input "
	NodeTarget_3="infobox.cgi?main=routing&action=input "
fi
if [ "$INFOBOX_FWD" = "yes" ]
then
	Node_4="Forward "
	NodeTarget_4="infobox.cgi?main=routing&action=fwrd "
fi
if [ "$INFOBOX_PORTFWD" = "yes" ]
then
	Node_5="Prerouting "
	NodeTarget_5="infobox.cgi?main=routing&action=portfwrd "
fi

case $FORM_action in
routeinfo)
show_tab_header $Node_1 no $Node_2$NodeTarget_2$Node_3$NodeTarget_3$Node_4$NodeTarget_4$Node_5$NodeTarget_5
;;
hosts|show_forwarding)
show_tab_header $Node_1$NodeTarget_1$Node_2 no $Node_3$NodeTarget_3$Node_4$NodeTarget_4$Node_5$NodeTarget_5
;;
input|show_input)
show_tab_header $Node_1$NodeTarget_1$Node_2$NodeTarget_2$Node_3 no $Node_4$NodeTarget_4$Node_5$NodeTarget_5
;;
fwrd|add_fwrd|del_fwrd|show_fwrd)
show_tab_header $Node_1$NodeTarget_1$Node_2$NodeTarget_2$Node_3$NodeTarget_3$Node_4 no $Node_5$NodeTarget_5
;;
portfwrd|add_portfwrd|del_portfwrd|show_portfwrd)
show_tab_header $Node_1$NodeTarget_1$Node_2$NodeTarget_2$Node_3$NodeTarget_3$Node_4$NodeTarget_4$Node_5 no
;;

esac
;;
esac
echo '<center><div style="margin:5px;margin-bottom:8px; width:550px;"><br>'
case $FORM_action in
fli4l)
	. infobox_fli4l.cgi
;;
hardware)
	. infobox_hw.cgi
;;
prozesse)
	. infobox_ps.cgi
;;
browser)
	. infobox_files.cgi
;;
viewer)
	. infobox_viewer.cgi
;;
shell)
	. infobox_shell.cgi
;;
routeinfo)
	. infobox_routing.cgi
;;
hosts|show_forwarding|block|unblock|ping)
	. infobox_hosts.cgi
;;
input|show_input|inp_new|inp_rem)
	. infobox_input.cgi
;;
fwrd|add_fwrd|del_fwrd|show_fwrd)
	. infobox_fwd.cgi
;;
portfwrd|add_portfwrd|del_portfwrd|show_portfwrd)
	. infobox_portfwd.cgi
;;
esac
echo '</div></center>'

show_tab_footer
cat <<-EOF


<form name="form_MouseXY">
<input type="hidden" name="MouseX" id="MouseX" size="5" value="300"><input type="hidden" name="MouseY" id="MouseY" size="5" value="200">
</form>


<script>
MouseInit();
document.onmousemove = MouseMove;
</script>



EOF
echo "<br><br><br><br><br><br>"
echo '</td></tr></table>'
show_html_footer