#!/bin/sh
#------------------------------------------------------------------------------
# BLOCKGROUPS
# this script uses code-snips form opt_cgiconfig2, written by Benjamin Hering <bosborros@gmx.net>
#
# Last Update:  24.04.2006  Axel Beilhartz <abeilhartz@schul-office.de>
#------------------------------------------------------------------------------

# get main helper functions
. /srv/www/include/cgi-helper
. /var/run/blockgroups.conf

#--------------------------------------------------
do_blockgroup ()
{ # blocks or unblocks all hosts of one group

host=1
eval host_n='$BLOCKGROUPS_'$1'_HOSTS_N'
for host in `seq 1 $host_n`
do
  eval ip='$BLOCKGROUPS_'$1'_HOST_'$host'_IP'
  do_blockhost $ip $2
done
}

#--------------------------------------------------
do_blockhost ()
{ # blocks or unblocks the router for one host

state_host=`iptables -L FORWARD -n --line-numbers | grep "$1 " | grep "fw-drp-log"`
state_est=`iptables -L FORWARD -n --line-numbers | grep "$1 " | grep "state RELATED,ESTABLISHED"`
case $state_host$state_est in
"")
  case $2 in
  "1") # block
    iptables -I FORWARD 1 -p all -s $1 -m state --state ESTABLISHED,RELATED -j fw-drp-log
    iptables -I FORWARD 1 -p all -s $1 -j fw-drp-log
    ;;
  esac
  ;;
*)
  case $2 in
  "0") # unblock
    num_fw=`iptables -L FORWARD -n --line-numbers | grep "$1 " | grep -v "state RELATED,ESTABLISHED" | grep "fw-drp-log" | sed "s/[fw-].*//"`
    iptables -D FORWARD $num_fw

    num_est=`iptables -L FORWARD -n --line-numbers | grep "$1 " | grep "state RELATED,ESTABLISHED" | sed "s/[fw-].*//"`
    iptables -D FORWARD $num_est
    ;;
  esac
  ;;
esac
}

#--------------------------------------------------
show_one_group ()
{ # shows settings for one group

isanyhoston="no"
group_id=$1
case $2 in
"")
  go_back="0"
  ;;
*)
  go_back="$2"
  ;;
esac
eval group_name='$BLOCKGROUPS_'$group_id'_NAME'

host_id=1
eval host_n='$BLOCKGROUPS_'$group_id'_HOSTS_N'
for host_id in `seq 1 $host_n`
do
  eval host_name='$BLOCKGROUPS_'$group_id'_HOST_'$host_id'_NAME'
  eval host_ip='$BLOCKGROUPS_'$group_id'_HOST_'$host_id'_IP'

  set -f
  set -- `grep "$host_ip " /proc/net/arp`
  set +f
  adress="$1" ; hwtype="$2" ; hwadress="$4" ; flag="$3" ; iface="$6"
  # online state
  case $host_name in
  $HOSTNAME)
    status=""
    ;;
  *)
    if [ "$hwadress" = "00:00:00:00:00:00" ] || [ "$hwadress" = "" ] || [ "$flag" != "0x2" ]
    then
      status=""
    else
      status="on"
    fi
  esac

  case $status in
  on)
    case $isanyhoston in
    no)
      action="$myname?action=blockgroup&amp;group=$group_id&amp;goback=$go_back"
      show_tab_header "<table class='tabmain' width=100% border=0 cellpadding=0 cellspacing=0><tr><td style='color: white;'><a href='$myname?action=ping_all&amp;group=$group_id&amp;goback=$go_back'><img src=../img/group.gif border=0 title='Alle Computer dieser Gruppe anpingen'></a>&nbsp;<b>$group_name</b></td><td style='color: white; text-align: right;'><a href='$action&amp;block=1'>&nbsp;<img src=../img/bgrot.gif border=0 title='Blockiert den Zugang zum Router fr alle Computer dieser Gruppe'></a>&nbsp;<a href='$action&amp;block=0'><img src=../img/bggruen.gif border=0 title='Schaltet den Zugang zum Router fr alle Computer dieser Gruppe frei'></a></td></tr></table>" no

      action="$myname?action=blockgroup&amp;group=$group_id&amp;goback=$go_back"
cat <<EOF
<table border="0">
 <tr>
  <td style="text-align: center; vertical-align: top;">
   <table class="normtable">
    <tr>
     <th>&nbsp;Computer / IP&nbsp;</th>
     <th style="text-align: center;">&nbsp;Routerzugang&nbsp;</th>
    </tr>
EOF
      isanyhoston="yes"
      ;;
    esac

    echo "<tr>"
    echo "<td><a href=\"$myname?action=ping&amp;host=$host_ip&amp;goback=$go_back\"><img src=\"../img/host.gif\" border=0 title=\"Ping an $host_name\"></a>&nbsp;$host_name / $host_ip&nbsp;</td>"

    state_host=`iptables -L FORWARD -n --line-numbers | grep "$host_ip " | grep "fw-drp-log"`
    state_est=`iptables -L FORWARD -n --line-numbers | grep "$host_ip " | grep "state RELATED,ESTABLISHED"`
    if [ "$state_host" = "" -a "$state_est" = "" ]
    then
      pic_src="../img/bgrot.gif"
      pic_title="Sperrt den Router fr "$host_name
      block_action="1"
      linktext="Sperren"
    else
      pic_src="../img/bggruen.gif"
      pic_title="Schaltet den Router fr "$host_name" frei"
      block_action="0"
      linktext="Freischalten"
    fi
    action="$myname?action=blockhost&amp;host=$host_ip&amp;goback=$go_back&amp;block=$block_action"
    echo "<td style=\"text-align: center;\"><a href=\"$action\">
          <img src=\"$pic_src\" border=\"0\" title=\"$pic_title\">&nbsp;$linktext</a></td>"
    echo "</tr>" 
    ;;
  esac
done
case $isanyhoston in
yes)
cat <<EOF
   </table>
  </td>
 </tr>
</table>
EOF
show_tab_footer
    ;;
  esac
}

#--------------------------------------------------
do_goback ()
{ # calls mainpage (allgroups or onegroup)

case $1 in
"0")
  action=""
  ;;
*)
  action="?action=onegroup&group=$1"
  ;;
esac
echo "Location: $myname$action"
echo
}

#--------------------------------------------------
# main
#
# Security
: ${FORM_action:="allgroups"}
case $FORM_action in
allgroups)
  sec_action="view"
  ;;
onegroup)
  sec_action="viewone"
  ;;
*)
  sec_action="set"
  ;;
esac
check_rights "blockgroups" "$sec_action"

refr=300
version=v1.1

case $FORM_action in
#--------------------------------------------------
allgroups)
# shows all groups
  show_html_header "OPT_BlockGroups $version" "refresh='$refr';url='$myname?action=$FORM_action'"
  group_id=1
  eval group_n='$BLOCKGROUPS_N'
  for group_id in `seq 1 $group_n`
  do
    show_one_group "$group_id"
    echo "<br><br>"
  done
  html="yes"
;;

#--------------------------------------------------
onegroup)
# shows only one group
cat <<EOF > /tmp/httpdmenu.$$
t - $_MT_admin
e $myname?action=$FORM_action&amp;group=$FORM_group Login
EOF
  eval group_name='$BLOCKGROUPS_'$FORM_group'_NAME'
  show_html_header "OPT_BlockGroups $version" "refresh='$refr';url='$myname?action=$FORM_action&amp;group=$FORM_group';menufile=/tmp/httpdmenu.$$"
  show_one_group "$FORM_group" "$FORM_group"
  echo "<br><br><h3>Wichtig !<br>Loggen Sie sich wieder aus, in dem Sie dieses Fenster schlieen.</h3>"
  rm /tmp/httpdmenu.$$
  html="yes"
;;

#--------------------------------------------------
blockgroup)
# blocks all hosts of one group
  do_blockgroup "$FORM_group" "$FORM_block"
;;

#--------------------------------------------------
blockhost)
# blocks one host
  do_blockhost "$FORM_host" "$FORM_block"
;;

#--------------------------------------------------
ping_all)
# pings all hosts of one group
  host=1
  eval host_n='$BLOCKGROUPS_'$FORM_group'_HOSTS_N'
  for host in `seq 1 $host_n`
  do
    eval ip='$BLOCKGROUPS_'$FORM_group'_HOST_'$host'_IP'
    ping -c 1 $ip > /dev/null 2>&1 & 
  done
  sleep 10
;;

#--------------------------------------------------
ping)
# pings one host
  ping -c 1 $FORM_host > /dev/null 2>&1
;;
esac

case $html in
yes)
  show_html_footer
  ;;
*)
  do_goback "$FORM_goback"
  ;;
esac
