#!/bin/sh
#------------------------------------------------------------------------------
# BLOCKGROUPS
# this script uses code-snips form opt_cgiconfig2, written by Benjamin Hering <bosborros@gmx.net>
#
# Last Update:  12.04.2006  Axel Beilhartz <abeilhartz@schul-office.de>
#------------------------------------------------------------------------------

# get main helper functions
. /srv/www/include/cgi-helper
. /var/run/blockgroups.conf

#--------------------------------------------------
do_blockgroup ()
{ # blocks or unblocks all hosts of one group

host=1
eval host_n='$BLOCKGROUPS_'$1'_HOSTS_N'
for host in `seq 1 $host_n`
do
  eval ip='$BLOCKGROUPS_'$1'_HOST_'$host'_IP'
  do_blockhost $ip $2
done
}

#--------------------------------------------------
do_blockhost ()
{ # blocks or unblocks the router for one host

state_host=`iptables -L FORWARD -n --line-numbers | grep "$1 " | grep "fw-drp-log"`
state_est=`iptables -L FORWARD -n --line-numbers | grep "$1 " | grep "state RELATED,ESTABLISHED"`
case $state_host$state_est in
"")
  case $2 in
  "1") # block
    iptables -I FORWARD 1 -p all -s $1 -m state --state ESTABLISHED,RELATED -j fw-drp-log
    iptables -I FORWARD 1 -p all -s $1 -j fw-drp-log
    ;;
  esac
  ;;
*)
  case $2 in
  "0") # unblock
    num_fw=`iptables -L FORWARD -n --line-numbers | grep "$1 " | grep -v "state RELATED,ESTABLISHED" | grep "fw-drp-log" | sed "s/[fw-].*//"`
    iptables -D FORWARD $num_fw

    num_est=`iptables -L FORWARD -n --line-numbers | grep "$1 " | grep "state RELATED,ESTABLISHED" | sed "s/[fw-].*//"`
    iptables -D FORWARD $num_est
    ;;
  esac
  ;;
esac
}

#--------------------------------------------------
show_one_group ()
{ # shows settings for one group

group_id=$1
case $2 in
"")
  go_back="0"
  ;;
*)
  go_back="$2"
  ;;
esac
eval group_name='$BLOCKGROUPS_'$group_id'_NAME'
show_tab_header "Gruppe: $group_name" no

action="$myname?action=blockgroup&amp;group=$group_id&amp;goback=$go_back"
cat <<EOF
<table border="0">
 <tr>
  <td style="text-align: center; vertical-align: top;">
   <table class="normtable">
    <tr>
     <th style="text-align: center;">&nbsp;Routerzugang fr die Gruppe&nbsp;</th>
    </tr>
    <tr>
     <td style="text-align: center;">
      <a href="$action&amp;block=1">Sperren&nbsp;<img src=../img/rotaus.gif border=0 title="Blockiert den Zugang zum Router fr alle Computer dieser Gruppe"></a>&nbsp;
      <a href="$action&amp;block=0"><img src=../img/gruenaus.gif border=0 title="Alle Computer dieser Gruppe haben Zugang zum Rounter">&nbsp;Freischalten</a>
     </td>
    </tr>
   </table>
  </td>
  <td>&nbsp;&nbsp;</td>
  <td style="text-align: center; vertical-align: top;">
   <table class="normtable">
    <tr>
     <th>&nbsp;IP&nbsp;</th>
     <th>&nbsp;Computer&nbsp; </th>
     <th style="text-align: center;">&nbsp;Eingeschaltet&nbsp;</th>
     <th style="text-align: center;">&nbsp;Routerzugang&nbsp;</th>
    </tr>
EOF

host_id=1
eval host_n='$BLOCKGROUPS_'$group_id'_HOSTS_N'
for host_id in `seq 1 $host_n`
do
  eval host_name='$BLOCKGROUPS_'$group_id'_HOST_'$host_id'_NAME'
  eval host_ip='$BLOCKGROUPS_'$group_id'_HOST_'$host_id'_IP'

  echo "<tr>"
  echo "<td>&nbsp;$host_ip &nbsp;</td>"
  echo "<td>&nbsp;$host_name &nbsp;</td>"

  set -f
  set -- `grep "$host_ip " /proc/net/arp`
  set +f
  adress="$1" ; hwtype="$2" ; hwadress="$4" ; flag="$3" ; iface="$6"
  # online state
  case $host_name in
  $HOSTNAME)
    echo "<td style=\"text-align: center;\"><img src=../img/gruenaus.gif border=0 title=\"Router\"></td>"
    ;;
  *)
    if [ "$hwadress" = "00:00:00:00:00:00" ] || [ "$hwadress" = "" ] || [ "$flag" != "0x2" ]
    then
      pic_src="../img/gelbaus.gif"
    else
      pic_src="../img/gruenaus.gif"
    fi
    action="$myname?action=ping&amp;host=$host_ip&amp;goback=$go_back"
    echo "<td style=\"text-align: center;\"><a href=\"$action\"><img src=\"$pic_src\" border=0 title=\"ping $host_ip\"></a></td>"
    ;;
  esac

  state_host=`iptables -L FORWARD -n --line-numbers | grep "$host_ip " | grep "fw-drp-log"`
  state_est=`iptables -L FORWARD -n --line-numbers | grep "$host_ip " | grep "state RELATED,ESTABLISHED"`
  if [ "$state_host" = "" -a "$state_est" = "" ]
  then
    pic_src="../img/rotaus.gif"
    pic title="Sperrt den Router fr diesen Computer"
    block_action="1"
    linktext="Sperren"
  else
    pic_src="../img/gruenaus.gif"
    pic title="Schaltet den Router fr diesen Computer frei"
    block_action="0"
    linktext="Freischalten"
  fi
  action="$myname?action=blockhost&amp;host=$host_ip&amp;goback=$go_back&amp;block=$block_action"
  echo "<td style=\"text-align: center;\"><a href=\"$action\">
        <img src=\"$pic_src\" border=\"0\" title=\"$pic_title\">&nbsp;$linktext</a></td>"
  echo "</tr>" 
done
cat <<EOF
    <tr>
     <td>&nbsp;</td>
     <td>&nbsp;</td>
     <td style="text-align: center;">
      <form name="ping" action="$myname" method="get">
      <input type="hidden" name="goback" value="$go_back">
      <input type="hidden" name="group" value="$group_id">
      <input type="hidden" name="action" value="ping_all">
      <input type="submit" value="alle anpingen">
      </form>
     </td>
     <td>&nbsp;</td>
    </tr>
   </table>
  </td>
 </tr>
</table>
EOF
show_tab_footer
}

#--------------------------------------------------
do_goback ()
{ # calls mainpage (allgroups or onegroup)

case $1 in
"0")
  action=""
  ;;
*)
  action="?action=onegroup&group=$1"
  ;;
esac
echo "Location: $myname$action"
echo
}

#--------------------------------------------------
# main
#
# Security
: ${FORM_action:="allgroups"}
case $FORM_action in
allgroups)
  sec_action="view"
  ;;
onegroup)
  sec_action="viewone"
  ;;
*)
  sec_action="set"
  ;;
esac
check_rights "blockgroups" "$sec_action"

refr=300
version=v1.0

case $FORM_action in
#--------------------------------------------------
allgroups)
# shows all groups
  show_html_header "OPT_BlockGroups $version" "refresh='$refr';url='$myname?action=$FORM_action'"
  group_id=1
  eval group_n='$BLOCKGROUPS_N'
  for group_id in `seq 1 $group_n`
  do
    show_one_group "$group_id"
    echo "<br><br>"
  done
  html="yes"
;;

#--------------------------------------------------
onegroup)
# shows only one group
cat <<EOF > /tmp/httpdmenu.$$
t - $_MT_admin
e $myname?action=$FORM_action&amp;group=$FORM_group Login
EOF
  eval group_name='$BLOCKGROUPS_'$FORM_group'_NAME'
  show_html_header "OPT_BlockGroups $version" "refresh='$refr';url='$myname?action=$FORM_action&amp;group=$FORM_group';menufile=/tmp/httpdmenu.$$"
  show_one_group "$FORM_group" "$FORM_group"
  echo "<br><br><h3>Wichtig !<br>Loggen Sie sich wieder aus, in dem Sie dieses Fenster schlieen.</h3>"
  rm /tmp/httpdmenu.$$
  html="yes"
;;

#--------------------------------------------------
blockgroup)
# blocks all hosts of one group
  do_blockgroup "$FORM_group" "$FORM_block"
;;

#--------------------------------------------------
blockhost)
# blocks one host
  do_blockhost "$FORM_host" "$FORM_block"
;;

#--------------------------------------------------
ping_all)
# pings all hosts of one group
  host=1
  eval host_n='$BLOCKGROUPS_'$FORM_group'_HOSTS_N'
  for host in `seq 1 $host_n`
  do
    eval ip='$BLOCKGROUPS_'$FORM_group'_HOST_'$host'_IP'
    ping -c 1 $ip > /dev/null 2>&1 & 
  done
  sleep 10
;;

#--------------------------------------------------
ping)
# pings one host
  ping -c 1 $FORM_host > /dev/null 2>&1
;;
esac

case $html in
yes)
  show_html_footer
  ;;
*)
  do_goback "$FORM_goback"
  ;;
esac
