#!/bin/sh
set_debug=no
. /srv/www/include/cgi-helper
. /var/run/infobox.conf

check_rights "infobox" "view"
show_html_header "Infobox"

cat <<-EOF
<style>
/* for MSIE only*/
* html, * html body {
    overflow:auto;
}
* html #header_container {
    padding-right: 0px;
}
* html #content {
    height: auto;
    width: auto;
}
</style>
<script type="text/javascript" src="infobox.js"></script>
EOF

echo '<table><tr><td>'


: ${FORM_main:=infobox}

case $FORM_main in
infobox)
: ${FORM_action:=fli4l}

if [ ! $FORM_action = "viewer" ] && [ ! $FORM_action = "shell" ]
then
	echo '<table class="tabmain"><tr>'
	echo "<th class=\"lbtab\"></th><th width=\"150\">Infobox</th><th class=\"rbtab\"></th>"
	echo "<th class=\"lgtab\"></th><th class=\"link\" width=\"150\"><a href=\"infobox.cgi?main=network\">Network</a></th><th class=\"rgtab\"></th>"
	echo "</tr></table>"
fi

Node_1="fli4l "
NodeTarget_1="infobox.cgi "
Node_2="Hardware "
NodeTarget_2="infobox.cgi?action=hardware "
if [ "$INFOBOX_PS" = "yes" ]
then
	Node_3="Processes "
	NodeTarget_3="infobox.cgi?action=prozesse "
fi
if [ "$INFOBOX_FILES" = "yes" ]
then
	Node_4="Files "
	NodeTarget_4="infobox.cgi?action=browser "
fi

		case $FORM_action in
		fli4l)
		show_tab_header $Node_1 no $Node_2$NodeTarget_2$Node_3$NodeTarget_3$Node_4$NodeTarget_4
		;;
		hardware)
		show_tab_header $Node_1$NodeTarget_1$Node_2 no $Node_3$NodeTarget_3$Node_4$NodeTarget_4
		;;
		prozesse)
		show_tab_header $Node_1$NodeTarget_1$Node_2$NodeTarget_2$Node_3 no $Node_4$NodeTarget_4
		;;
		browser)
		show_tab_header $Node_1$NodeTarget_1$Node_2$NodeTarget_2$Node_3$NodeTarget_3$Node_4 no
		;;
		esac
;;
network)
: ${FORM_action:=hosts}
if [ ! $FORM_action = "ping" ]
then
	echo '<table class="tabmain"><tr>'
	echo "<th class=\"lgtab\"></th><th class=\"link\" width=\"150\"><a href=\"infobox.cgi\">Infobox</a></th><th class=\"rgtab\"></th>"
	echo "<th class=\"lbtab\"></th><th width=\"150\">Network</th><th class=\"rbtab\"></th>"
	echo "</tr></table>"
fi

Node_1="Hosts"
NodeTarget_1="infobox_hosts.cgi"

		case $FORM_action in
		hosts)
		show_tab_header "$Node_1" no "$Node_2" "$NodeTarget_2" "$Node_3" "$NodeTarget_3" "$Node_4" "$NodeTarget_4"
		;;
		esac
;;
esac


echo '<div style="margin:5px;margin-bottom:8px; width:500px;">&#160;</div>'
if [ "$FORM_action" = "fli4l" ]
then
. infobox_fli4l.cgi
fi
if [ "$FORM_action" = "hardware" ]
then
. infobox_hw.cgi
fi
if [ "$FORM_action" = "prozesse" ]
then
. infobox_ps.cgi
fi
if [ "$FORM_action" = "browser" ]
then
. infobox_files.cgi
fi
if [ "$FORM_action" = "viewer" ]
then
. infobox_viewer.cgi
fi
if [ "$FORM_action" = "shell" ]
then
. infobox_shell.cgi
fi
if [ "$FORM_action" = "hosts" ] || [ "$FORM_action" = "block" ] || [ "$FORM_action" = "unblock" ] || [ "$FORM_action" = "ping" ]
then
. infobox_hosts.cgi
fi

show_tab_footer
cat <<-EOF


<form name="form_MouseXY">
<input type="hidden" name="MouseX" id="MouseX" size="5" value="300"><input type="hidden" name="MouseY" id="MouseY" size="5" value="200">
</form>


<script>
MouseInit();
document.onmousemove = MouseMove;
</script>



EOF
echo "<br><br><br><br><br><br>"
echo '</td></tr></table>'

show_html_footer