#!/bin/sh
##-----------------------------------------------------------------------------
## opt_wol                                                   fli4l-3.0.1 v1.6.3
##
## Creation:     12.10.2002  gk
## Last Update:  29.03.2006 m.p.
##
## Copyright (c) 2006 Matthias Pilz <fli4l.pilz@tiscali.de>
## original release (c) 2002-2004 Georg Kainzbauer <georgkainzbauer@gmx.net>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##-----------------------------------------------------------------------------

# get main helper functions
. /srv/www/include/cgi-helper

_rshort=5 # short reload (5)
_rurl=$myname # reload-url

# security
check_rights "status" "boot"

case x$QUERY_STRING in
x)
show_html_header "Wake On LAN"

cat <<EOF
<body bgcolor=ffffff link=0000a0 vlink=0000a0 alink=808080>
<style type="text/css"> <!--
a:hover { color: #ff0000}
//--></style>
EOF

show_tab_header "$_WOL_tab_header" "no"

cat <<EOF
<table border=1 cellpadding=3 cellspacing=0 bgcolor=f0f0f0 bordercolor=ffffff>
<tr bgcolor=000000>
<td align="center"><b><font color=ffffff>$_WOL_tab_host</font></b></td>
<td align="center"><b><font color=ffffff>$_WOL_tab_ip</font></b></td>
<td align="center"><b><font color=ffffff>$_WOL_tab_mac</font></b></td>
<td align="center"><b><font color=ffffff>$_WOL_tab_iface</font></b></td>
<td><b><font color=ffffff> </font></b></td>
</tr>
EOF

NUM_OF_HOSTS=`grep "NUM_OF_HOSTS" /var/run/wol.conf | cut -d" " -f2`
idx=1
while [ "$idx" -le "$NUM_OF_HOSTS" ]
do
	host=`grep "WOL_HOST_"$idx"_NUM" /var/run/wol.conf | cut -d" " -f5`
	ip=`grep "WOL_HOST_"$idx"_NUM" /var/run/wol.conf | cut -d" " -f4`
	if=`grep "WOL_HOST_"$idx"_NUM" /var/run/wol.conf | cut -d" " -f3`
	mac=`grep "WOL_HOST_"$idx"_NUM" /var/run/wol.conf | cut -d" " -f2`
	echo "<tr><td align=\"center\">$host</td><td><span style=\"font-family:'Courier New','Lucida Console'; text-align:left\">$ip</span></td><td><span style=\"font-family:'Courier New','Lucida Console'; text-align:left\">$mac</span></td><td align=\"center\">$if</td><td align=\"center\" bgcolor=\"#99CCFF\"><a href=\"main_WOL.cgi?$host\">WOL</a></td>"
	idx=`/usr/bin/expr $idx + 1`
done

echo "</table>"
show_tab_footer
;;

*)
show_html_header "Wake On LAN" "refresh=$_rshort;url=$_rurl"
/usr/local/bin/wol.sh $QUERY_STRING
show_info "$_WOL_done_info$QUERY_STRING" "$_WOL_done_message<a href=$_rurl>$_WOL_done_url</a>."
;;
esac
show_html_footer
