#!/bin/sh
##------------------------------------------------------------------------------
##                                                           fli4l-3.0.1 v0.1.1
## big_ben.sh
##
## Author:       Markus Strauss <sprevl6666@googlemail.com>
##
## Creation:     22.03.2005  SE6666
## Last Update:  22.03.2005  SE6666
##
##------------------------------------------------------------------------------


DATE=`date +%H:%M`
MINUTE=`echo $DATE | sed -e 's/.*://'`
HOUR=`echo $DATE | sed -e 's/:.*//'`

E=784
C=622
D=698
G=466
BELL=440

# http://en.wikipedia.org/wiki/Westminster_Quarters
bell1 () {
  beep  -f $E -l 400 -D 50
  beep  -f $D -l 400 -D 50
  beep  -f $C -l 400 -D 50
  beep  -f $G -l 500 -D 200
}

bell2 () {
  beep  -f $C -l 400 -D 50
  beep  -f $E -l 400 -D 50
  beep  -f $D -l 400 -D 50
  beep  -f $G -l 500 -D 200
}

# Variante 2b)
bell2b () {
  beep  -f $C -l 400 -D 50
  beep  -f $D -l 400 -D 50
  beep  -f $E -l 400 -D 50
  beep  -f $C -l 500 -D 200
}

bell3 () {
  beep  -f $E -l 400 -D 50
  beep  -f $C -l 400 -D 50
  beep  -f $D -l 400 -D 50
  beep  -f $G -l 500 -D 200
}

bell4 () {
  beep  -f $G -l 400 -D 50
  beep  -f $D -l 400 -D 50
  beep  -f $E -l 400 -D 50
  beep  -f $C -l 500 -D 200
}

bell () {
  beep  -f $BELL -l 400 -D 250
}

case $MINUTE in
  00)
    COUNT=`expr \( $HOUR % 12 + 11 \) % 12 + 1`

    bell1
    bell2
    bell3
    bell4
    while [ $COUNT != 0 ];
    do
      bell
      COUNT=`expr $COUNT - 1`
    done
  ;;
  15)
    bell1
  ;;
  30)
    bell1
    bell2
  ;;
  45)
    bell1
    bell2
    bell3
  ;;
esac