#!/bin/sh
set_debug=no

. /srv/www/include/cgi-helper
check_rights "infobox" "view"
show_html_header "Infobox"

cat <<-EOF
<style>
/* for MSIE only*/
* html, * html body {
    overflow:auto;
}
* html #header_container {
    padding-right: 0px;
}
* html #content {
    height: auto;
    width: auto;
}
</style>
EOF

echo '<script type="text/javascript" src="infobox.js"></script>'

Node_1="Infobox"
NodeTarget_1="infobox.cgi"
Node_2="Hardware"
NodeTarget_2="infobox.cgi?action=hardware"
Node_3="Processes"
NodeTarget_3="infobox.cgi?action=prozesse"
Node_4="Files"
NodeTarget_4="infobox.cgi?action=browser"

: ${FORM_action:=infobox}
case $FORM_action in
infobox)
	show_tab_header "$Node_1" no "$Node_2" "$NodeTarget_2" "$Node_3" "$NodeTarget_3" "$Node_4" "$NodeTarget_4"
;;
hardware)
	show_tab_header "$Node_1" "$NodeTarget_1" "$Node_2" no "$Node_3" "$NodeTarget_3" "$Node_4" "$NodeTarget_4"
;;
prozesse)
	show_tab_header "$Node_1" "$NodeTarget_1" "$Node_2" "$NodeTarget_2" "$Node_3" no "$Node_4" "$NodeTarget_4"
;;
browser)
	show_tab_header "$Node_1" "$NodeTarget_1" "$Node_2" "$NodeTarget_2" "$Node_3" "$NodeTarget_3" "$Node_4" no
;;
esac

echo '<div style="margin:5px;margin-bottom:8px; width:500px;">&#160;</div>'
#--------------------------------------------------------------------------------------------------------------------- Infobox
#-------------------------------------------------------------------------------------------------------------------------------
if [ "$FORM_action" = "infobox" ]
then

	echo '<center><div style="margin:5px;margin-bottom:8px; width:500px;">'

	echo '<table class="tabmain" border="0" cellpadding="4" cellspacing="0" width="450">'
	echo "<tr>"
	echo "    <th colspan="3">Fli4L Version</th>"
	echo "</tr>"
	echo "</table>"

	echo '<table class="normtable" border="1" cellpadding="4" cellspacing="0" width="450">'
	echo "<tr>"
	echo "    <td align=\"center\" colspan=\"3\">`cat /etc/version`</td>"
	echo "</tr>"
	ostype=`cat /proc/sys/kernel/ostype`
	osrelease=`cat /proc/sys/kernel/osrelease`
	version=`cat /proc/sys/kernel/version`
	echo "<tr>"
	echo "    <th style=\"text-align:center;\">OS</th>"
	echo "    <th style=\"text-align:center;\">Kernel</th>"
	echo "    <th style=\"text-align:center;\">Version</th>"
	echo "</tr>"
	echo "<tr>"
	echo "    <td align=\"center\">$ostype</td>"
	echo "    <td align=\"center\">$osrelease</td>"
	echo "    <td align=\"center\">$version</td>"
	echo "</tr>"
	echo "</table><br>"
	uptime=`cat /proc/uptime | cut -f1 -d"." `
	tage=`expr $uptime / 86400`
	stunden=`expr $uptime % 86400 / 3600 `
	minuten=`expr $uptime % 3600 / 60`
	sekunden=`expr $uptime % 60`
	echo '<table class="tabmain" border="0" cellpadding="4" cellspacing="0" width="450">'
	echo "<tr>"
	echo '    <th>Uptime</th>'
	echo "</tr>"
	echo "</table>"

	echo '<table class="normtable" border="1" cellpadding="4" cellspacing="0" width="450">'
	echo "<tr>"
	echo "    <th width=\"112\" style=\"text-align:center;\">Days</th>"
	echo "    <th width=\"112\" style=\"text-align:center;\">Hours</th>"
	echo "    <th width=\"112\" style=\"text-align:center;\">Minutes</th>"
	echo "    <th width=\"112\" style=\"text-align:center;\">Seconds</th>"
	echo "</tr>"
	echo "<tr>"
	echo "    <td align=\"center\">$tage</td>"
	echo "    <td align=\"center\">$stunden</td>"
	echo "    <td align=\"center\">$minuten</td>"
	echo "    <td align=\"center\">$sekunden</td>"
	echo "</tr>"
	echo "</table>"
	echo "<br>"

	echo '<table class="tabmain" border="0" cellpadding="4" cellspacing="0" width="450">'
	echo "<tr>"
	echo '    <th colspan="6" align="center">Mount-Infos</th>'
	echo '</tr>'
	echo "</table>"

	echo '<table class="normtable" border="1" cellpadding="4" cellspacing="0" width="450">'
	echo '<tr>'
	echo '   <th style="text-align:center;">Drive</th>'
	echo '   <th style="text-align:center;">Size</th>'
	echo '   <th style="text-align:center;">Used</th>'
	echo '   <th style="text-align:center;">Free</th>'
	echo '   <th style="text-align:center;">Used %</th>'
	echo '   <th style="text-align:center;">Path</th>'
	echo "</tr>"
	/bin/df -h | grep -v "Available" | while read Filesystem Size Used Available Use2 Mounted
	do
	echo "<tr>"
	echo "   <td align=\"left\">$Filesystem</td>"
	echo "   <td align=\"right\">$Size</td>"
	echo "   <td align=\"right\">$Used</td>"
	echo "   <td align=\"right\">$Available</td>"
	echo "   <td align=\"right\">$Use2</td>"
	echo "   <td align=\"left\">$Mounted</td>"
	echo "</tr>"
	done
	echo "</table>"

#----------
#----------

. /var/run/infobox.conf
if [ -f /tmp/logfiles.tmp ]
then

rm /tmp/logfiles.tmp

fi

	if [ ! "SYSLOGD" = "no" ]
	then
	while read a b
	do
		if [ -f "$b" ]
		then
			attrib=`ls -lh $b`
			echo "Syslog $b $attrib" >> /tmp/logfiles.tmp
		fi
	done < /etc/syslog.conf
	fi
	if [ ! "$IMOND" = "yes" ]
	then
		if [ -f $IMOND]
		then
			attrib=`ls -lh $IMOND`			
			echo "Imond $IMOND $attrib" >> /tmp/logfiles.tmp
		fi
	fi
	if [ ! "$BOOTLOG" = "no" ]
	then
		if [ -f $BOOTLOG]
		then
			attrib=`ls -lh $BOOTLOG`
			echo "Bootlog $BOOTLOG $attrib" >> /tmp/logfiles.tmp
		fi
	fi
	if [ -f /srv/www/admin/debug.log ]
	then
		attrib=`ls -lh /srv/www/admin/debug.log`
		echo "Httpd /srv/www/admin/debug.log $attrib" >> /tmp/logfiles.tmp
	fi
	if [ -f /bootmsg.txt ]
	then
		attrib=`ls -lh /bootmsg.txt`
		echo "Boot /bootmsg.txt $attrib" >> /tmp/logfiles.tmp
	fi
	
if [ -f /tmp/logfiles.tmp ]
then

	echo '<br><table class="tabmain" border="0" cellpadding="4" cellspacing="0" width="450">'
	echo '<tr><th>Logfiles</th></tr>'
	echo '</table>';

	echo '<table class="normtable" border="1" cellpadding="4" cellspacing="0" width="450">' 
	Out="<tr><th>Name</th><th>Path</th><th width=\"100\">Size</th><th>&#160;</th>"
		while read line
		do
		set -- $line
			file=`basename $2`
			path=`dirname $2`		
			Out="$Out<tr><td>$1</td><td>$2&#160;</td><td align=\"right\">$7&#160;</td><td align=\"center\"><a href=\"infobox.cgi?action=viewer&path=$path&file=$file&refer=infobox&command=down\">view</a></td></tr>"
		done < /tmp/logfiles.tmp
	echo "$Out"
	echo "</table>"
fi

echo '</div></center>'
fi
#--------------------------------------------------------------------------------------------------------------------  Hardware
#-------------------------------------------------------------------------------------------------------------------------------
if [ "$FORM_action" = "hardware" ]
then

	echo '<center><div style="margin:5px;margin-bottom:8px; width:500px;">'

	if [ -f /sbin/ifconfig ]
	then
		echo '<table class="tabmain" border="0" cellpadding="4" cellspacing="0" width="450">'
		echo '<tr><th>Network</th></tr>'
		echo '</table>';

		if [ ! -f /tmp/ifconfig.tmp ]
		then
			/sbin/ifconfig | grep "eth" |
			while read line
			do
				set -- $line
				echo "$1 $5" >> /tmp/ifconfig.tmp
			done
		fi
		if [  -f /tmp/ifconfig.tmp ]
		then
			echo '<table class="normtable" border="1" cellpadding="4" cellspacing="0" width="450">'
			echo '<tr><th>Device</th><th>MAC</th><th>IRQ</th><th>IO</th><th>IP</th></tr>'
			while read line
			do
				set -- $line
				echo "<tr>"
				echo "<td>$1</td><td>$2&#160;</td><td>"
				echo `ifconfig $1 | grep "Interrupt" | cut -d ":" -f 2 | cut -d " " -f 1`
				echo "&#160;</td><td>"
				echo `ifconfig $1 | grep "Interrupt" | cut -d ":" -f 3 | cut -d " " -f 1`
				echo "&#160;</td><td>"
				echo `ifconfig $1 | grep "inet" | cut -d ":" -f 2 | cut -d " " -f 1`
				echo "&#160;</td></tr>"
			done < /tmp/ifconfig.tmp
		echo "</table>"
		fi
	fi

	if [ -f /proc/meminfo ]
	then
		echo '<br><table class="tabmain" border="0" cellpadding="4" cellspacing="0" width="450">'
		echo '<tr><th>Memory</th></tr>'
		echo '</table>';
		echo '<table class="normtable" border="1" cellpadding="4" cellspacing="0" width="450">'
			while read line
			do
				set -- $line
				case $1 in
				"Mem:")
					echo "<tr><th>total</th><td align=\"right\">$2&#160;</td></tr>"
					echo "<tr><th>free</th><td align=\"right\">$4&#160;</td></tr>"
					echo "<tr><th>used</th><td align=\"right\">$3&#160;</td></tr>"
				;;
				esac
			done < /proc/meminfo
		echo "</table>"
	fi

	if [ -f /proc/cpuinfo ]
	then
		/bin/cat /proc/mounts >/etc/mtab
		/bin/mv /etc/mtab /etc/mtab.SAVE
		echo '<br><table class="tabmain" border="0" cellpadding="4" cellspacing="0" width="450">'
		echo '<tr><th>CPU</th></tr>'
		echo '</table>';
		echo '<table class="normtable" border="1" cellpadding="4" cellspacing="0" width="450">'
		cat /proc/cpuinfo | sed 's/^/\<tr\>\<th align=left class=head\>/;s/\:/\<\/th\>\<td\>/;s/$/\<\/td\>\<\/tr\>/;s/<tr><th align=left><\/td><\/tr>//'
		echo
		echo '</table>';

		/bin/mv /etc/mtab.SAVE /etc/mtab
	fi

	echo '</div></center>'
fi
#---------------------------------------------------------------------------------------------------------------------- Pozesse
#-------------------------------------------------------------------------------------------------------------------------------
if [ "$FORM_action" = "prozesse" ]
then
echo '<center><div style="margin:5px;margin-bottom:8px; width:500px;">'

ps > /tmp/ps.tmp

VAR_COUNTER="0";

echo "<table class=\"normtable\" border=\"1\" cellspacing=\"0\" cellpadding=\"4\">"
while read a
do
	set -- $a
	VAR_01=$1
	VAR_02=$2
	VAR_03=$3
	VAR_04=$4
	if [ ! "$5" = "N" ]
	then
		VAR_05="$5 $6 $7 $8 $9"
	else
		unset $VAR_04; VAR_04="$VAR_04$5"
		VAR_05="$6 $7 $8 $9"
	fi	
	
	if [ "$VAR_03" = "SW" ] || [ "$VAR_03" = "SWN" ]  || [ "$VAR_03" = "RWN" ]|| [ "$VAR_03" = "R" ]  || [ "$VAR_03" = "T" ] || [ "$VAR_03" = "Z" ]
	then
		unset $VAR_05; VAR_05="$VAR_04"
		unset $VAR_04; VAR_04="$VAR_03"
		unset $VAR_03; VAR_03="&#160;"
	fi
#---------------------------------------------------------------------------------------------- Output
	echo '<tr>'
	if [ $VAR_COUNTER = "0" ]
	then
		echo "<th>No.</th>"
		echo "<th>$VAR_01</th>"
		echo "<th>$VAR_02</th>"
		echo "<th>$VAR_03</th>"
		echo "<th>$VAR_04 *</th>"
		echo "<th>$VAR_05</th>"
		echo '<th style="text-align:center"><a href="infobox.cgi?action=prozesse" style="color:red;font-weight:normal;text-decoration:none;">refresh</a></th>'
	else
		echo "<th style=\"font-weight:normal;text-align:right;padding-right:5px;\">$VAR_COUNTER</th>"
		echo "<td align=\"right\">$VAR_01</td>"
		echo "<td align=\"left\">$VAR_02</td>"
		echo "<td align=\"right\">$VAR_03</td>"
		echo "<td align=\"left\">$VAR_04</td>"
		echo "<td align=\"left\" colspan=\"2\"><a href=\"javascript:show_KILL('$VAR_01')\">$VAR_05</a></td>"
	fi
	echo "</tr>"

VAR_TMP=`expr $VAR_COUNTER + 1`
unset $VAR_COUNTER; VAR_COUNTER="$VAR_TMP" 
done < /tmp/ps.tmp

echo "</table>"

echo '<br><small>* '
echo "Status: "
echo "R = Running,"
echo "S = Sleep,"
echo "T = Stopped,"
echo "W = Paging,"
echo "Z = Zombie"

echo "<br>Priority: "
echo "< = High,"
echo "N = Low,"
echo "L = Locked"
echo '</small>'


echo '</div></center>'


echo '<script language="JavaScript" type="text/javascript">'
echo 'function EXEC(command) {'
echo 'm = document.form_KILL;'
echo '    if (command == "stop") {'
echo "        location.href = \"infobox.cgi?action=shell&dir=/&refer=prozesse&command=kill&param=\"+ m.FileName.value;"
echo '    }'
echo '}'
echo '</script>'

cat <<-EOF

<div id="div_KILL" style="display:none;position:absolute;top:0px;left:0px;border:solid 1px blue;background-color:white;width:120px;height:80px;padding:0px;">
<div style="background-color:blue;width:100%;padding:0px;margin:0px;">
<div style="width:80%;text-align:left;padding:0px;margin:0px;color:white;float:left;">kill&#160;</div><div style="text-align:right;padding:0px;margin:0px;"><a href="javascript:HIDE('div_KILL')" style="color:white;">X</a></div>
</div>
<form name="form_KILL">
<table>
<tr><td>PID: <input type="text" size="10" name="FileName" style="border: none 0px white; background-color:white;" readonly></td></tr>
<tr><td align="center">
<table border="0" cellspacing="0" cellpadding="0">
<tr>
<td align="left"><input type="button" value="stop" onClick="EXEC('stop')" style="width:80px;"></td>
</tr>
</table></td><tr>
</table>
</form>
</div>


EOF

fi
#--------------------------------------------------------------------------------------------------------------------- Browser
#-------------------------------------------------------------------------------------------------------------------------------
if [ "$FORM_action" = "browser" ]
then




echo '<center><div style="margin:5px;margin-bottom:8px; width:500px;">'

if [ "$FORM_command" = "" ]
then
	VAR_LOGDIR=""
	SHOW_PATH="/"
fi

if [ "$FORM_command" != "" ]
then
	if [ "$FORM_command" = "/" ]
	then
		VAR_LOGDIR=""
		SHOW_PATH="/"
	else
		VAR_LOGDIR="$FORM_command"
		SHOW_PATH="$FORM_command"		
	fi
fi



echo '<script language="JavaScript" type="text/javascript">'
echo 'function EXEC_CHMOD() {'
echo 'm = document.form_CHMOD;'
echo 'Uvalue = 0;'
echo 'if (m.XU.checked == true) { Uvalue = Uvalue + parseInt(m.XU.value); }'
echo 'if (m.WU.checked == true) { Uvalue = Uvalue + parseInt(m.WU.value); }'
echo 'if (m.RU.checked == true) { Uvalue = Uvalue + parseInt(m.RU.value); }'
echo 'Gvalue = 0;'
echo 'if (m.XG.checked == true) { Gvalue = Gvalue + parseInt(m.XG.value); }'
echo 'if (m.WG.checked == true) { Gvalue = Gvalue + parseInt(m.WG.value); }'
echo 'if (m.RG.checked == true) { Gvalue = Gvalue + parseInt(m.RG.value); }'
echo 'Ovalue = 0;'
echo 'if (m.XO.checked == true) { Ovalue = Ovalue + parseInt(m.XO.value); }'
echo 'if (m.WO.checked == true) { Ovalue = Ovalue + parseInt(m.WO.value); }'
echo 'if (m.RO.checked == true) { Ovalue = Ovalue + parseInt(m.RO.value); }'
echo "location.href = \"infobox.cgi?action=shell&dir=$VAR_LOGDIR&command=chmod&param=0\"+ Uvalue + Gvalue + Ovalue +\" \"+ m.FileName.value+\"&refer=browser&file=\"+ m.FileName.value;"
echo '}'
echo '</script>'

echo '<script language="JavaScript" type="text/javascript">'
echo 'function EXEC_DEL() {'
echo 'm = document.form_DEL;'
echo "location.href = \"infobox.cgi?action=shell&dir=$VAR_LOGDIR&command=rm&param=\"+ m.FileName.value+\"&refer=browser&file=\"+ m.FileName.value;"
echo '}'
echo '</script>'

echo '<script language="JavaScript" type="text/javascript">'
echo 'function EXEC_COPY() {'
echo 'm = document.form_COPY;'
echo "location.href = \"infobox.cgi?action=shell&dir=$VAR_LOGDIR&command=cp&param=\"+ m.FileName.value+\" \"+ m.Destination.value +\"&refer=browser&file=\"+ m.FileName.value;"
echo '}'
echo '</script>'


#------------------------------------------------ Files
echo '<table class="tabmain" border="0" cellpadding="4" cellspacing="0" width="500">'
echo '<form action="javascript:Browse()"><tr>'
echo '    <th colspan="6" align="center">'
echo '         <table border="0" cellpadding="0" cellspacing="0"><tr>'
echo "         <td><input name=\"Target\" type=\"text\" size=\"50\" value=\"$SHOW_PATH\"></td>"
echo '         <td><input type="submit" value="browse" style=\"width:50px;\"></td>'
echo "         <td><input type=\"button\" value=\"<root>\" onClick=\"Browse_Target('/')\" style=\"width:50px;\"></td>"
echo "         <td><input type=\"button\" value=\"..\" onClick=\"Browse_Target('$FORM_command')\" style=\"width:50px;\"></td>"
echo '         </tr></table>'
echo '   </th>'
echo '</tr></form><tr>'
echo '</table>'
echo '<table class="normtable" border="1" cellpadding="4" cellspacing="0" width="500">'
echo '<tr>'
echo '    <th width="155">File</th><th width="75">Attrib</th><th width="70">Owner</th><th width="70">Group</th><th width="75">Size</th><th width="55">&#160;</th>'
echo "</tr>"

ls -lh $VAR_LOGDIR/ |
    while read a
      do
      set -- $a
      VAR_ATTRIB=$1
      VAR_OWNER=$3
      VAR_GROUP=$4
      VAR_FILE=$9
      VAR_SIZE=$5

	CHECK_D=`echo "$VAR_ATTRIB" | cut -f 1 -d 'd'`
	CHECK_DIR="$CHECK_D";

	if [ "$CHECK_DIR" = "" ]
	then
	      echo "<tr><td align=left>$VAR_FILE</td><td align=left>$VAR_ATTRIB</td><td align=center>$VAR_OWNER</td><td align=center>$VAR_GROUP</td><td align=right>&#160;</td><td align=center><a href=\"infobox.cgi?action=browser&command=$VAR_LOGDIR/$VAR_FILE\">browse</a></td></tr>"
	fi
	if [ "$CHECK_DIR" != "" ]
	then
		CHECK_L=`echo "$VAR_ATTRIB" | cut -f 1 -d 'l'`
		CHECK_LINK="$CHECK_L";
			if [ "$CHECK_LINK" = "" ]
			then
			      echo "<tr><td align=left>$VAR_FILE</td><td align=left>$VAR_ATTRIB</td><td align=center>$VAR_OWNER</td><td align=center>$VAR_GROUP</td><td align=right>&#160;</td><td align=center><a href=\"infobox.cgi?action=browser&command=$VAR_LOGDIR/$VAR_FILE\">browse</a></td></tr>"
			fi
			if [ "$CHECK_LINK" != "" ]
			then	
				if [ "$FORM_file" = "$VAR_FILE" ]
				then
					echo "<tr bgcolor=\"#FFFF80\">"
				else
					echo "<tr>"
				fi
				echo "<td align=left><a href=\"javascript:show_FIFUNCTIONS('$VAR_FILE','$VAR_ATTRIB')\">$VAR_FILE</a></td>"
				echo "<td align=\"left\"><a href=\"javascript:show_CHMOD('$VAR_FILE','$VAR_ATTRIB')\">$VAR_ATTRIB</a></td>"
				echo "<td align=center>$VAR_OWNER</td><td align=center>$VAR_GROUP</td>"
				echo "<td align=right>$VAR_SIZE</td>"
				echo "<td align=center><a href=\"infobox.cgi?action=viewer&path=$VAR_LOGDIR&file=$VAR_FILE&refer=browser&command=down\">view</a></td>"
				echo "</tr>"
			fi
	fi

    done 

echo '    <th>File</th><th>Attrib</th><th>Owner</th><th>Group</th><th>Size</th><th>&#160;</th>'
echo "</table><br>"

cat <<-EOF

<div id="div_CHMOD" style="display:none;position:absolute;top:0px;left:0px;border:solid 1px blue;background-color:white;width:140px;height:160px;padding:0px;">
<div style="background-color:blue;width:100%;padding:0px;margin:0px;">
<div style="width:90%;text-align:left;padding:0px;margin:0px;color:white;float:left;">chmod</div><div style="text-align:right;padding:0px;margin:0px;"><a href="javascript:HIDE('div_CHMOD')" style="color:white;">X</a></div>
</div>
<form name="form_CHMOD">
<table>
<tr><td><input type="text" name="FileName" style="border: none 0px white; background-color:white;" readonly></td></tr>
<tr><td align="center">
<table border="0" cellspacing="0" cellpadding="0" class="normtable">
<tr>
<td width="10">&#160;</td>
<td align="center">r</td>
<td align="center">w</td>
<td align="center">x</td>
</tr>
<tr>
<td>owner</td>
<td><input type="checkbox" name="RU" value="4" style="background-color:white;border:none 0px white;"></td>
<td><input type="checkbox" name="WU" value="2" style="background-color:white;border:none 0px white;"></td>
<td><input type="checkbox" name="XU" value="1" style="background-color:white;border:none 0px white;"></td>
</tr>
<tr>
<td>group</td>
<td><input type="checkbox" name="RG" value="4" style="background-color:white;border:none 0px white;"></td>
<td><input type="checkbox" name="WG" value="2" style="background-color:white;border:none 0px white;"></td>
<td><input type="checkbox" name="XG" value="1" style="background-color:white;border:none 0px white;"></td>
</tr>
<tr>
<td>others</td>
<td><input type="checkbox" name="RO" value="4" style="background-color:white;border:none 0px white;"></td>
<td><input type="checkbox" name="WO" value="2" style="background-color:white;border:none 0px white;"></td>
<td><input type="checkbox" name="XO" value="1" style="background-color:white;border:none 0px white;"></td>
</tr>
</table></td><tr>
<tr><td align="center"><input type="button" value="save" onClick="EXEC_CHMOD()" style="width:110px;"></td></tr>
</table>
</form>
</div>

<div id="div_FIFUNCTIONS" style="display:none;position:absolute;top:0px;left:0px;border:solid 1px blue;background-color:white;width:140px;height:100px;padding:0px;">
<div style="background-color:blue;width:100%;padding:0px;margin:0px;">
<div style="width:90%;text-align:left;padding:0px;margin:0px;color:white;float:left;">&#160;</div><div style="text-align:right;padding:0px;margin:0px;"><a href="javascript:HIDE('div_FIFUNCTIONS')" style="color:white;">X</a></div>
</div>
<form name="form_FIFUNCTIONS">
<table>
<tr><td><input type="text" name="FileName" style="border: none 0px white; background-color:white;" readonly></td></tr>
<tr><td align="center"><input type="button" value="copy" onClick="show_COPY()" style="width:110px;"></td></tr>
<tr><td align="center"><input type="button" value="delete" onClick="show_DEL()" style="width:110px;"></td></tr>
</table>
</form>
</div>

<div id="div_DEL" style="display:none;position:absolute;top:0px;left:0px;border:solid 1px blue;background-color:white;width:140px;height:80px;padding:0px;">
<div style="background-color:blue;width:100%;padding:0px;margin:0px;">
<div style="width:90%;text-align:left;padding:0px;margin:0px;color:white;float:left;">rm</div><div style="text-align:right;padding:0px;margin:0px;"><a href="javascript:HIDE('div_DEL')" style="color:white;">X</a></div>
</div>
<form name="form_DEL">
<table>
<tr><td colspan="2" align="left"><input type="text" name="FileName" style="border: none 0px white; background-color:white;" readonly></td></tr>
<tr><td align="center"><input type="button" value="delete" onClick="EXEC_DEL()" style="width:50px;"></td><td align="center"><input type="button" value="cancel" onClick="HIDE('div_DEL')" style="width:50px;"></td></tr>
</table>
</form>
</div>

<div id="div_COPY" style="display:none;position:absolute;top:0px;left:0px;border:solid 1px blue;background-color:white;width:140px;height:90px;padding:0px;">
<div style="background-color:blue;width:100%;padding:0px;margin:0px;">
<div style="width:90%;text-align:left;padding:0px;margin:0px;color:white;float:left;">cp</div><div style="text-align:right;padding:0px;margin:0px;"><a href="javascript:HIDE('div_COPY')" style="color:white;">X</a></div>
</div>
<form name="form_COPY">
<table>
<tr><td align="left"><input type="text" name="FileName" style="border: none 0px white; background-color:white;" readonly></td></tr>
<tr><td align="center"><input type="text" value="/" name="Destination"></td>
<tr><td align="center"><input type="button" value="copy" onClick="EXEC_COPY()" style="width:50px;"></td></tr>
</table>
</form>
</div>

EOF

echo '</div></center>'
fi
#-------------------------------------------------------------------------------------------------------------------- Viewer
#-------------------------------------------------------------------------------------------------------------------------------
if [ "$FORM_action" = "viewer" ]
then

  SourceFolder="$FORM_path"
  SourceFile="$FORM_file"
  PageBack="$FORM_refer"
  Function="$FORM_command"

Source="$SourceFolder/$SourceFile"

echo '<script language="JavaScript" type="text/javascript">'
echo "function Back() { location.href = \"infobox.cgi?action=$PageBack&command=$SourceFolder&file=$SourceFile\"; }"
echo '</script>'

show_tab_header "$Source" no

echo '<table border="0" width="500"><tr>'
#------------------------------------------------------------
if [ $Function = "up" ]
then
echo '<td width="60" align="left" valign="middle"><input type="button" value="back" onClick="Back()" style="width:50px;"></td>'
echo "<td><a href=\"infobox.cgi?action=viewer&path=$SourceFolder&file=$SourceFile&refer=$PageBack&command=down\">down</a></td>"
echo '</tr></table>'

echo '<hr noshade>'
echo '<table border="0" cellpadding="0" cellspacing="0"><tr><td nowrap><pre>'
sed '1!s/&/&amp;/g;s/</\&lt;/g;s/^//;s/$//;G;h;$!d' $Source
echo '</pre></td></tr></table>'
fi

#------------------------------------------------------------
if [ $Function = "down" ]
then
echo '<td width="60" align="left" valign="middle"><input type="button" value="back" onClick="Back()" style="width:50px;"></td>'
echo "<td><a href=\"infobox.cgi?action=viewer&path=$SourceFolder&file=$SourceFile&refer=$PageBack&command=up\">up</a></td>"
echo '</tr></table>'

echo '<hr noshade>'
echo '<table border="0" cellpadding="0" cellspacing="0"><tr><td nowrap><pre>'
sed 's/&/&amp;/g;s/</\&lt;/g;s/^//;s/$//' $Source
echo '</pre></td></tr></table>'
fi

#------------------------------------------------------------

fi
#-------------------------------------------------------------------------------------------------------------------- Shell
#-------------------------------------------------------------------------------------------------------------------------------

if [ "$FORM_action" = "shell" ]
then

	eval "`proccgi $*`"
	VAR_DIR="$FORM_dir"
	VAR_FUNCTION="$FORM_command $FORM_param"
	VAR_FILE="$FORM_file"
	VAR_REFER="$FORM_refer"


if [ "$VAR_FUNCTION" != "" ]
then
	cd $VAR_DIR/
	$VAR_FUNCTION 2> /tmp/infoshell.tmp

	Result=`cat </tmp/infoshell.tmp`
	rm /tmp/infoshell.tmp

	if [ "$Result" = "" ]
	then
		#echo 'gut'
		echo "<script>location.href = \"infobox.cgi?action=$VAR_REFER&command=$VAR_DIR&file=$VAR_FILE\";</script>"
	else
		echo '<table border="0" cellpadding="4" cellspacing="0" width="400">'
		echo '<tr><td nowrap><b>Error:</b></td></tr>'
		echo '<tr><td nowrap><pre>'
		echo "$Result"
		echo '</pre></td></tr>'
		echo "<tr><td><a href=\"infobox.cgi?action=$VAR_REFER&command=$VAR_DIR&file=$VAR_FILE\">Back</a></td></tr>"
		echo "</table>"
	fi

fi


fi


show_tab_footer

cat <<-EOF


<form name="form_MouseXY">
<input type="hidden" name="MouseX" id="MouseX" size="5" value="300"><input type="hidden" name="MouseY" id="MouseY" size="5" value="200">
</form>


<script>
MouseInit();
document.onmousemove = MouseMove;
</script>



EOF
echo "<br><br><br><br><br><br>"




show_html_footer