#!/bin/sh
# -----------------------------------------------------------------------------
# This file is part of opt_onco. For contact and licensing information, see
#   (fli4lroot)/config/onco.txt
# File version: $Id: onco_blockip.cgi 19 2006-01-04 00:44:54Z sirprize $
# -----------------------------------------------------------------------------
. /srv/www/include/cgi-helper

check_rights "onco" "change"

show_html_header "OnCo-Hostblock" "refresh=3;url=main_onco.cgi"

if [ "$FORM_action" = "" -o "$FORM_ip" = ""]
then
		show_error "No IP or no action given."
		show_html_footer
		exit
fi

if [ "$FORM_action" = "block" ]
then
	/usr/local/bin/onco_blockip.sh $FORM_ip
else
	if [ "$FORM_action" = "unblock" ]
	then
		/usr/local/bin/onco_unblockip.sh $FORM_ip
	else
		show_error "No valid action argument given."
		show_html_footer
		exit
	fi
fi

echo "Die IP $FORM_ip wurde "
if [ "$FORM_action" = "block" ]
then
	echo "gesperrt.<br />"
else
	echo "entsperrt.<br />"
fi
echo "Sie werden in K&uuml;rze weitergeleitet! Bitte warten!<br />"
echo "<font size=-1>Sollten Sie nicht innerhalb von 3 Sekunden weitergeleitet"
echo " werden, klicken Sie <a href=main_onco.cgi>hier</a>.</font>"

show_html_footer
