#!/bin/sh
# -----------------------------------------------------------------------------
# This file is part of opt_onco. For contact and licensing information, see
#   (fli4lroot)/config/onco.txt
# File version: $Id: main_onco.cgi 22 2006-03-12 18:45:59Z sirprize $
# -----------------------------------------------------------------------------
. /srv/www/include/cgi-helper

if [ "$FORM_all" = "unblock" ]
then
	check_rights "onco" "change"
	{
		while read ip host
		do
			/usr/local/bin/onco_unblockip.sh $ip
		done
	} < /tmp/onco/hosts
fi

if [ "$FORM_all" = "block" ]
then
	check_rights "onco" "change"
	{
		while read ip host
		do
			/usr/local/bin/onco_blockip.sh $ip
		done
	} < /tmp/onco/hosts
fi

check_rights "onco" "view"

show_html_header "OnCo-Hostliste" "refresh=120;url=main_onco.cgi"

echo "<p align='right'><font size='-1'>OnCo v3.0.1.1</font></p>"
echo "<p><br />"

if [ ! -f /tmp/onco/nofping ]
then
	echo "Rechnerstatus <a href='onco_updatehosts.cgi'>aktualisieren</a>.<br />"
fi

echo "<a href='main_onco.cgi?show=all'>Alle</a> Hosts anzeigen, unabh&auml;ngig vom Status.<br />"
echo "Alle Hosts <a href='main_onco.cgi?all=unblock'>freischalten</a>.<br />"
echo "Alle Hosts <a href='main_onco.cgi?all=block'>sperren</a>.<br /></p>"
echo "<p><br />Hostliste:</p>"

echo "<center><table>
<colgroup><col width=100><col width=100><col width=50><col width=100><col width=40><col width=40><col width=40><col width=40></colgroup>
<tr>
<th>IP:</th>
<th>Hostname:</th>
<th>Status:</th>
<th>Internet:</th>
<th>Zeit</th><th>Zeit</th><th>Zeit</th><th>Zeit</th><th>Zeit</th>
</tr>"

set `cat /tmp/onco/hosts`
ip_count=$#

count=1
while [ $count -le $ip_count ]
do
	help1="\$1"
	help2="\$2"
	ip=`eval "echo $help1"`
	hn=`eval "echo $help2"`
	if [ -f /tmp/onco/nofping ]
	then
		status="<font color=#2020aa>unbekannt</font>"
	else
		if [ ! -f /tmp/onco/$ip.online ]
		then
			status="<font color=#aa2020>aus</font>"
		else
			status="<font color=#20aa20>an</font>"
		fi
	fi
	if [ -f /tmp/onco/$ip.time ]
	then
		timeleft=`cat /tmp/onco/$ip.time`
		block="<a href=\"onco_blockip.cgi?ip=$ip&action=block\"><font color=#00bb00>$timeleft Min.</font></a>"
	elif [ -f /tmp/onco/$ip.blocked ]
	then
		block="<a href=\"onco_blockip.cgi?ip=$ip&action=unblock\"><font color=#bb0000>nein</font></a>"
	else
		block="<a href=\"onco_blockip.cgi?ip=$ip&action=block\"><font color=#00bb00>ja</font></a>"
	fi
	if [ "$FORM_show" = "all" -o -f /tmp/onco/nofping -o -f /tmp/onco/$ip.online -o ! -f /tmp/onco/$ip.blocked ]
	then
		echo "
		<tr>
		<td>$ip</td>
		<td>$hn</td>
		<td>$status</td>
		<td>$block</td>
		<td><a href=\"onco_begincount.cgi?time=15&ip=$ip\">+15m</a></td>
		<td><a href=\"onco_begincount.cgi?time=30&ip=$ip\">+30m</a></td>
		<td><a href=\"onco_begincount.cgi?time=60&ip=$ip\">+1h</a></td>
		<td><a href=\"onco_begincount.cgi?time=120&ip=$ip\">+2h</a></td>
		<td><a href=\"onco_begincount.cgi?time=240&ip=$ip\">+4h</a></td>
		</tr>"
	fi
	count=`/usr/bin/expr $count + 2`
	shift 2
done
echo "</table></center><br />Anzahl der registrierten Hosts: `/usr/bin/expr $ip_count / 2`"

show_html_footer
