#!/bin/sh
##----------------------------------------------------------------------------
## opt_digitemp                                            fli4l-3.0.0 v3.3.2b
##
## Creation:     03.03.2002 Johannes Hermen
##               08.08.2004 Gerd Walter
## Last Update:  04.03.2006 m.p.
##
## Copyright (c) 2006 Matthias Pilz <fli4l.pilz@tiscali.de>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##----------------------------------------------------------------------------

. /var/run/digitemp.conf

while [ true ]
do
	count=`grep "SENSORS" /var/run/digitemp.rc | cut -d" " -f2`
	idx=0
	while [ $idx -lt $count ]
	do
		running=1
		while [ $running -gt 0 ] # warten bis kein digitemp-prozess luft
		do
			running=`ps | grep -e "-c/var/run/digitemp.rc" | grep -v "grep" 2>/dev/null`
			case x$running in
			x)	running=0 ;;
			*)	running=1
				sleep 5
			;;
			esac
		done
		# Sensor[x] auslesen ( speichert jeweilige temp. in /var/run/sensor[x] )
		templine=`/usr/local/bin/digitemp -q -c/var/run/digitemp.rc -t$idx`
		check=`echo "$templine" |cut -d" " -f1`
		case $check in
			Sensor)	output=`echo "$templine" |cut -d" " -f4` ;;
			*)	output="U" ;; # Sensor liefert keinen Messwert
		esac
		idx=`expr $idx + 1`
		echo -n "$output" > /var/run/sensor$idx
	done
	sleep $Digitemp_Intervall
done
