#!/bin/sh
##----------------------------------------------------------------------------
## opt_digitemp                                            fli4l-3.0.0 v3.3.2b
##
## Creation:     03.03.2002 Johannes Hermen
##               08.08.2004 Gerd Walter
## Last Update:  04.03.2006 m.p.
##
## Copyright (c) 2006 Matthias Pilz <fli4l.pilz@tiscali.de>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##----------------------------------------------------------------------------

# get main helper functions
. /srv/www/include/cgi-helper

: ${FORM_action:=overview}

# Security
check_rights "logs" "$FORM_action"

_rshort=4 # short reload (5)
_rlong=60 # long reload (60)
_rurl=$myname # reload-url
_config="/var/run/digitemp.conf" # opt-config-file

#-----------------------------------------------------------------------------
# eigene Config Variablen auslesen
#-----------------------------------------------------------------------------
. $_config

#-----------------------------------------------------------------------------
# Variablen einlesen
#-----------------------------------------------------------------------------
idx=1
for var in `echo "$QUERY_STRING" | tr '&' ' '`
do
	eval 'var_'$idx'='`echo "$var" | cut -d"=" -f2 2>/dev/null`
	idx=`expr $idx + 1`
done

#-----------------------------------------------------------------------------
# Modifikationen ausfhren
#-----------------------------------------------------------------------------
donetext=""

case $FORM_action$var_3 in
	LOGdel) # Logfile lschen:
		eval 'file=$Digitemp_'$var_2'_Log_File'
		rm -f $file
		donetext="Logdatei gelscht"
		_rurl="$myname?action=LOG&sens=$var_2"
	;;
	SETdel) # Sensor lschen:  $_config ndern
		cat $_config | grep -v "Digitemp_Anz" | grep -v "Digitemp_$var_2" >>/tmp/digitemp.conf
		rm -f $_config
		mv /tmp/digitemp.conf $_config
		Digitemp_Anz=`expr $Digitemp_Anz - 1` # anzahl verringern
		echo "Digitemp_Anz=$Digitemp_Anz" >>$_config

		eval logging='$Digitemp_'$var_2'_Log'
		case $logging in	# war logging eingeschaltet?
		yes) # den cronjob entfernen
			killall cron
			sleep 1
			cat /var/spool/cron/crontabs/root | grep -v "templog.sh $var_2" >/tmp/crontab
			cat /tmp/crontab >/var/spool/cron/crontabs/root
			/usr/sbin/cron
			rm -f /tmp/crontab
			# das logfile entfernen
			eval oldfile='$Digitemp_'$var_2'_Log_File'
			if [ -f $oldfile ]
			then
				rm -f $oldfile
			fi
		;;
		esac
		. $_config
		donetext="Sensor gelscht"
		var_2=0
		_rurl="$myname?action=SET&sens=$var_2"
	;;
	SETadd) # Sensor hinzufgen:  $_config ndern
		cat $_config | grep -v "Digitemp_Anz" >>/tmp/digitemp.conf
		rm -f $_config
		mv /tmp/digitemp.conf  $_config
		
		Digitemp_Anz=`expr $Digitemp_Anz + 1`	# anzahl erhhen
		eval echo 'Digitemp_'$Digitemp_Anz'_Name='$var_4	>>$_config
		eval echo 'Digitemp_'$Digitemp_Anz'_Log=no'		>>$_config
		eval echo 'Digitemp_'$Digitemp_Anz'_Log_File='		>>$_config
		eval echo 'Digitemp_'$Digitemp_Anz'_Log_Time='		>>$_config
		echo "Digitemp_Anz=$Digitemp_Anz"			>>$_config
		. $_config
		donetext="Sensor hinzugefgt"
		var_2=$Digitemp_Anz
		_rurl="$myname?action=SET&sens=$var_2"
	;;
	SETmod) # Sensorkonfiguration ndern: $_config ndern
		# alte Sensordaten entfernen, neue Daten werden angefgt
		cat $_config | grep -v "Digitemp_$var_2" 	>>/tmp/digitemp.conf
		rm -f $_config
		mv /tmp/digitemp.conf $_config
		# %2F=/ %2A=*
		var_6=`echo "$var_6" | sed '$s/%2F/\//g' 2>/dev/null`
		var_7_now=`echo "$var_7" | sed '$s/+/ /g' 2>/dev/null| sed '$s/%2A/*/g' 2>/dev/null | sed '$s/%2F/\//g' 2>/dev/null`

		case x$var_5 in
		x)
			var_5="no" # definierten zustand herstellen
		;;
		esac
		case x$var_6 in
		x)
			var_5="no" # ohne logfile kein logging!
		;;
		esac
		case x$var_7_now in
		x)
			var_5="no" # ohne logtime kein logging!
		;;
		esac
		# neue Sensorkonfiguration schreiben
		eval echo 'Digitemp_'$var_2'_Name='$var_4	>>$_config
		eval echo 'Digitemp_'$var_2'_Log='$var_5	>>$_config
		eval echo 'Digitemp_'$var_2'_Log_File='$var_6	>>$_config
		eval echo -n 'Digitemp_'$var_2'_Log_Time='	>>$_config
		echo "'$var_7_now'" 				>>$_config
		# logfile umbenennen/transferieren
		eval oldfile='$Digitemp_'$var_2'_Log_File'
		case x$oldfile in
		x) ;;
		*)
			if [ -w $oldfile -a -n $var_6 ]
			then
				mv $oldfile $var_6
			fi
		;;
		esac
		# cronjob ndern/anlegen/lschen
		eval logging='$Digitemp_'$var_2'_Log'
		case $logging$var_5 in	# old-state / new-state
		nono*) ;;
		yesyes* | noyes* ) # cronjob ndern bzw. neu schreiben
			killall cron
			sleep 1
			cat /var/spool/cron/crontabs/root | grep -v "templog.sh $var_2" >/tmp/crontab
			cat /tmp/crontab >/var/spool/cron/crontabs/root
			echo "$var_7_now /usr/local/bin/templog.sh $var_2 $var_6" >>/var/spool/cron/crontabs/root
			/usr/sbin/cron
			rm -f /tmp/crontab
		;;
		yesno*) # logging ausschalten = cronjob lschen
			killall cron
			sleep 1
			cat /var/spool/cron/crontabs/root | grep -v "templog.sh $var_2" >/tmp/crontab
			cat /tmp/crontab >/var/spool/cron/crontabs/root
			/usr/sbin/cron
			rm -f /tmp/crontab
		;;
		esac
		. $_config
		donetext="Daten gendert"
		_rurl="$myname?action=SET&sens=$var_2"
	;;
esac

#-----------------------------------------------------------------------------
# Seitenaufbau mit Tabellenkopf
#-----------------------------------------------------------------------------

case x$donetext in
	x) show_html_header "DigiTemp" "refresh=$_rlong;url=$_rurl"
	;;
	*)
		show_html_header "DigiTemp" "refresh=$_rshort;url=$_rurl"
		show_info "" "$donetext"
	;;
esac

show_tab_header "$_overview" "$myname" \
		"$_LOG" "$myname?action=LOG&sens=0" \
		"$_SET" "$myname?action=SET&sens=0" \
		"$_INIT" "$myname?action=INIT"

case $FORM_action in
	LOG)
#-----------------------------------------------------------------------------
# Temperaturen logging auswerten
#-----------------------------------------------------------------------------
	echo "Sensor: "
	case $var_2 in
	0)
		echo "<b>?</b><br>"
		idx=1
		while [ "$idx" -le "$Digitemp_Anz" ]
		do
			eval name='$Digitemp_'$idx'_Name'
			echo "&nbsp<a href=$myname?action=LOG&sens=$idx>$name</a><br>"
 		   idx=`expr $idx + 1`
		done
		;;
	*)
		eval log='$Digitemp_'$var_2'_Log'
		eval name='$Digitemp_'$var_2'_Name'
		case $log in
		yes)
			echo "<b>$name</b><br>"
			eval file='$Digitemp_'$var_2'_Log_File'
			case x$file in
			x)
				echo "<br><b>Fehler:</b><br> Parameter \"Log File\" ist leer - Konfiguration berprfen!<br><br>"
				;;
			*)
				if [ -r $file ]
				then
					echo "<table>"
					echo "<tr><th>Datum</th><th>Zeit</th><th>&nbsp;&nbsp;Wert&nbsp;&nbsp;</th><th></th><th>Graph</th></tr>"
					tac  $file | while read templine;
					do
						time=`echo "$templine" |cut -f2 -d";" `
						date=`echo "$templine" |cut -f3 -d";" `
						temperatur=`echo "$templine" |cut -f1 -d";" `
						case x$temperatur in
							xU | x) temperatur=X ; tempgraph=0 ;;
							x-0.*) tempgraph="-1" ;;
							x0.*) tempgraph=1 ;;
							*) tempgraph=`echo "$temperatur" |cut -d"." -f1` ;;
						esac
						tempgraph=`expr $tempgraph \* 5 `
						echo "<tr>"
						echo "<td>$date</td><td>$time</td><td align=right>$temperatur $Digitemp_Unit</td>"
						if echo "$tempgraph" |grep "-" >/dev/null
						then
							tempgraph=`echo $tempgraph |cut -c 2-`
							echo "<td align=right><img src=../img/red.gif width=$tempgraph height=10></td><td></td>"
						else
							echo "<td></td><td align=left><img src=../img/green.gif width=$tempgraph height=10></td>"
						fi
						echo "</tr>"
					done
					echo "</table><br><a href=$myname?action=LOG&sens=$var_2>Reload Page</a>&nbsp&nbsp&nbsp<a href=$myname?action=LOG&sens=$var_2&do=del>Delete Logfile</a>"
				else
					echo "<br>Logfile existiert nicht<br><br>"
				fi
				;;
			esac
			;;
		*)
			echo "<b>$name</b><br><br>Logging ist ausgeschaltet.<br><br>"
			;;
		esac
		;;
	esac
	;;

	SET)
#-----------------------------------------------------------------------------
# Settings zeigen
#-----------------------------------------------------------------------------
	echo "Sensor: "
	case $var_2 in
	0) # wenn _kein_ Sensor gewhlt
		echo "<b>?</b><br>"
		idx=1
		while [ "$idx" -le "$Digitemp_Anz" ]
		do
			eval name='$Digitemp_'$idx'_Name'
			echo "&nbsp<a href=$myname?action=SET&sens=$idx>$name</a><br>"
 		   idx=`expr $idx + 1`
		done
		echo "<hr noshade><b>Sensor hinzufgen:</b><br>"
		echo "<form action=$myname enctype=\"text/plain\">"
		echo "<input type=hidden name=\"action\" value=\"SET\">"
		echo "<input type=hidden name=\"sens\" value=\"0\">"
		echo "<input type=hidden name=\"do\" value=\"add\">"
		echo "Name:"
		echo "<input type=text name=\"Name\" size=\"20\" maxlength=\"30\">"
		echo "<input type=submit value=\" Set \">"
		;;
	*) # wenn ein Sensor gewhlt
		# Werte aus conf lesen
		eval name='$Digitemp_'$var_2'_Name'
		eval log='$Digitemp_'$var_2'_Log'
		eval file='$Digitemp_'$var_2'_Log_File'
		eval time='$Digitemp_'$var_2'_Log_Time'

		echo "<b>$name</b><br>"
		echo "<table><form action=$myname enctype=\"text/plain\">"
		echo "<input type=hidden name=\"action\" value=\"SET\">"
		echo "<input type=hidden name=\"sens\" value=\"$var_2\">"
		echo "<input type=hidden name=\"do\" value=\"mod\">"
		echo "<tr><td align=right>Name: </td><td><input type=text name=\"Name\" size=\"30\" maxlength=\"30\" value=\"$name\"></td><td> </td></tr>"
		echo "<tr><td align=right>Log: </td><td><input type=text name=\"Log\" size=\"30\" maxlength=\"20\" value=\"$log\"><td> yes | no</td></tr>"
		echo "<tr><td align=right>Log File: </td><td><input type=text name=\"Log_File\" size=\"30\" maxlength=\"50\" value=\"$file\"></td><td> /var/log/sensor8.log</td></tr>"
		echo "<tr><td align=right>Log Time: </td><td><input type=text name=\"Log_Time\" size=\"30\" maxlength=\"40\" value=\"$time\"></td><td> */20 * * * *</td></tr>"
		echo "<tr><td><input type=submit value=\" Set \"></td><td><input type=\"reset\" value=\" Reset \"></td></tr></form></table>"

		case $var_2 in
		$Digitemp_Anz) # es ist der letzte Sensor
			# delete button zeigen
			echo "<form action=$myname enctype=\"text/plain\">"
			echo "<input type=hidden name=\"action\" value=\"SET\">"
			echo "<input type=hidden name=\"sens\" value=\"$var_2\">"
			echo "<input type=hidden name=\"do\" value=\"del\">"
			echo "<input type=submit value=\" Sensor lschen \">"
			echo "</form>"
			;;
		esac
		;;
	esac
	;;

	INIT)
#-----------------------------------------------------------------------------
# Initialisieren
#-----------------------------------------------------------------------------
	echo "<b>Initialisieren der Sensoren....</b><br>"
	found=0
	running=1
	while [ $running -gt 0 ] # warten bis kein digitemp-prozess luft
	do
		running=`ps | grep -e "-c/var/run/digitemp.rc" | grep -v "grep" 2>/dev/null`
		case x$running in
		x)	running=0 ;;
		*)	running=1
			sleep 5
		;;
		esac
	done
	/usr/local/bin/digitemp -q -i -c/var/run/digitemp.rc -s$Digitemp_Port -r1000 -o"Sensor %s $Digitemp_Unit: %.1$Digitemp_Unit" >/tmp/digitemp.init 2>/dev/null
	grep ROM /tmp/digitemp.init >/tmp/digitemp.id
	grep -v ROM /tmp/digitemp.init >/tmp/digitemp.type
	echo "<pre>"
	cat /tmp/digitemp.type
	echo "</pre>"
	echo "<table>"
	{
	idx=1
	while read templine
	do
		nametemp=`echo '$Digitemp_'$idx'_Name'`
		eval 'name=`echo '$nametemp'`'
		sensorid=`echo "$templine" |cut -d" " -f4`
		echo "<tr><td>Sensor: <b>\"$name\"</b></td>"
		echo "<td> --> ROM-ID=<font face=\"Courier New,Lucida Console\">$sensorid</font></td></tr>"
		found=`echo "$templine" |cut -d" " -f2 | cut -c2-`
		found=`expr $found + 1`
		idx=`expr $idx + 1`
	done
	} </tmp/digitemp.id
	rm -f /tmp/digitemp*
	echo "</table><br><b>$found Sensoren gefunden. - $Digitemp_Anz Sensoren erwartet.</b><br>"
	echo "<br><a href=$myname?action=INIT>Wiederholen</a>"
	;;

	*)
#-----------------------------------------------------------------------------
# Temperaturen lesen / bersicht
#-----------------------------------------------------------------------------
	idx=1
	echo "<table>"
	while [ "$idx" -le "$Digitemp_Anz" ]
	do
		temperatur=`cat /var/run/sensor$idx 2>/dev/null`
		nametemp=`echo '$Digitemp_'$idx'_Name'`
		eval 'name=`echo '$nametemp'`'
		case x$temperatur in
		xU | x) temperatur="n.i." ;;
		*) temperatur="$temperatur $Digitemp_Unit" ;;
		esac
		echo "<tr><td><b>$name</b></td><td>:</td><td align=right>$temperatur"
		echo "&nbsp;&nbsp;&nbsp;<a href=$myname?action=LOG&sens=$idx>Log</a>"
		echo "&nbsp;&nbsp;&nbsp;<a href=$myname?action=SET&sens=$idx>Set</a></td></tr>"
		idx=`expr $idx + 1`
	done
	echo "</table><br><a href=$myname>Reload Page</a>"
	;;
esac

show_tab_footer
show_html_footer
