package SetiWebAdmin;

import SetiHome.*;
import java.util.*;
import java.net.*;
import java.io.*;

/**
 * Copyright 1999,2000,2001 Stefan Hoffmann<br>
 *
 * This File is part of SetiProxy.<br>
 *
 *	SetiProxy is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.<br>
 *
 *	SetiProxy is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.<br>
 *
 *	You should have received a copy of the GNU General Public License
 *	along with SetiProxy; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
public class AdminServer implements Logger, Runnable {
	private MainController con;
	AdminListener listener;
	int port;
	boolean running;
	Thread thread;

	int logsvontag, logsvonmonat, logsvonjahr;
	int logsbistag, logsbismonat, logsbisjahr;
	int loglevel;

	Vector webUsers=new Vector();
	AdminUser defaultUser=new AdminUser("def", "", true);
/**
 * AdminServer constructor comment.
 */
public AdminServer(MainController con, int port) {
	super();
	this.con=con;
	this.port=port;
	init();
}
/**
 * Die Beschreibung der Methode hier eingeben.
 * Erstellungsdatum: (29.06.2001 21:49:56)
 * @return boolean
 * @param pUserid java.lang.String
 * @param pPassword java.lang.String
 * @param pAdministrator boolean
 */
private boolean addUser(String pUserid, String pPassword, boolean pAdministrator) {
	if (getUser(pUserid)!=null) {
		return false;
	}
	
	webUsers.add(new AdminUser(pUserid, pPassword, pAdministrator));
	save();
	return true;	
}
/**
 * This method was created in VisualAge.
 * @param sock java.net.Socket
 * @param data byte[]
 */
public void answer_html(AdminConnection cl, StringBuffer data) {

	char []send=new char[data.length()];
	data.getChars(0, data.length(), send, 0);

	try {
		OutputStream outp=cl.getSocket().getOutputStream();
		PrintWriter stream=new PrintWriter(new OutputStreamWriter(outp));

		stream.println("HTTP/1.0 200 OK");
		stream.println("Server: AdminServer SetiProxy by Stevie");
		stream.println("Content-Length: " + send.length);
		stream.println("Content-Type: text/html");
		stream.println("Connection: Keep-Alive");
		stream.println("Date: " + new Date());
		stream.println();
		stream.write(send);
		stream.close();
		cl.getSocket().close();
	} catch(Exception e) {
		try {
			cl.getSocket().close();
		} catch(Exception ee) {};
		log(LS.ls("asah1") + e, LOG_ERROR);
	}
}
/**
 * This method was created in VisualAge.
 * @param sock java.net.Socket
 * @param data byte[]
 */
public void answer_htmlerror(AdminConnection cl, int code, String line) {

	try {
		StringBuffer buf=new StringBuffer();
		buf.append("<html><h1>Error " + code + "</h1>");
		buf.append("<h2>" + line + "</h2>");
		buf.append("<br>SetiProxy-AdminServer by Stevie in 1999");
		buf.append("</html>");
		char zeichen[]=new char[buf.length()];
		buf.getChars(0, buf.length(), zeichen, 0);

		OutputStream outp=cl.getSocket().getOutputStream();
		BufferedWriter stream=new BufferedWriter(new OutputStreamWriter(outp));
		stream.write("HTTP/1.1 " + code + " Error");
		stream.newLine();
		stream.write("Server: AdminServer SetiProxy by Stevie");
		stream.newLine();
		stream.write("WWW-Authenticate: Basic realm=\"SetiProxy\"");
		stream.newLine();
		stream.write("Content-Length: " + zeichen.length);
		stream.newLine();
		stream.write("Content-Type: text/html");
		stream.newLine();
		stream.write("Connection: close");
		stream.newLine();
		stream.newLine();
		stream.write(zeichen);
		//stream.newLine();
		stream.close();
		cl.getSocket().close();
	} catch(Exception e) {
		try {
			cl.getSocket().close();
		} catch(Exception ee) {};
		log(LS.ls("asahe1") + e, LOG_ERROR);
	}
}
/**
 * This method was created in VisualAge.
 * @return java.lang.String
 * @param start int
 * @param ende int
 * @param value int
 */
public String build_client_select() {
	StringBuffer buf=new StringBuffer();
	buf.append("<select name=client size=10>");
	Enumeration enum=con.getClients(Client.ALLE);
	while (enum.hasMoreElements()) {
		Client clien=(Client)enum.nextElement();
		buf.append("<option value=\"" + clien.getClientName() + "\">"+clien.getClientName()+"</option>");
	}
	buf.append("</select>");
	return buf.toString();
}
/**
 * This method was created in VisualAge.
 * @return java.lang.String
 * @param start int
 * @param ende int
 * @param value int
 */
public String build_select(int start, int ende, int value, int step, String name) {
	StringBuffer buf=new StringBuffer();
	buf.append("<select name="+name + ">");
	for(int i=start;i<=ende;i+=step) {
		if (value==i) {
			buf.append("<option selected>"+new Integer(i).toString());
		}	else {
			buf.append("<option>"+new Integer(i).toString());
		}
	}
	buf.append("</select>");
	return buf.toString();
}
/**
 * This method was created in VisualAge.
 * @return java.lang.String
 * @param start int
 * @param ende int
 * @param value int
 */
public String build_select(int start, int ende, int value, String name) {
	return build_select(start, ende, value, 1, name);
}
/**
 * This method was created in VisualAge.
 * @return java.lang.String
 * @param start int
 * @param ende int
 * @param value int
 */
public String build_user_select(String user) {
	StringBuffer buf=new StringBuffer();
	buf.append("<select name=\"users\" size=5 width=\"100%\">");

	Enumeration enum=webUsers.elements();
	
	while (enum.hasMoreElements()) {
		AdminUser selUser=(AdminUser)enum.nextElement();
		buf.append("<option value=\"");
		buf.append(selUser.getUserId());
		buf.append("\"");
		if ((user!=null) && (selUser.getUserId().equals(user))) {
			buf.append(" selected>");
		} else {
			buf.append(">");
		}
		buf.append(selUser.getUserId());
		buf.append("</option>");
	}
	buf.append("</select>");
	return buf.toString();
}
/**
 * Die Beschreibung der Methode hier eingeben.
 * Erstellungsdatum: (29.06.2001 20:05:35)
 * @return SetiWebAdmin.AdminUser
 * @param con SetiWebAdmin.AdminConnection
 */
private AdminUser checkSecurity(AdminConnection connection) {
	if (con.getProperty("adminservicesecurity").equals("ja")) {
		AdminUser user;
		String authentication=connection.getProperties().getProperty("authorization");
		if (authentication==null) {
			answer_htmlerror(connection, 401, LS.ls("acsc1"));
			return null;
		}
		authentication=authentication.substring(6);

		Enumeration enum=webUsers.elements();
		while (enum.hasMoreElements()) {
			user=(AdminUser)enum.nextElement();
			if (user.checkSignature(authentication)) {
				return user;
			}
		}
		answer_htmlerror(connection, 401, LS.ls("acsc1"));
		return null;
	} else {
		return defaultUser;
	}
}
/**
 * Insert the method's description here.
 * Creation date: (27.09.2000 18:29:44)
 * @param hash java.lang.String
 */
private void deleteErg(String hash) {
	
	int inthash=0;
	try {
		inthash=Integer.parseInt(hash);
		// Ok, jetzt haben wir die Parameter, jetzt das entsprechende erg finden....
		Enumeration ergs=con.getWaitingUnits();
		ClientConnectionData ficonda=null;
		while ((ergs.hasMoreElements()) && (ficonda==null)) {
			ClientConnectionData conda=(ClientConnectionData)ergs.nextElement();
			if (conda.hashCode()==inthash) {
				// Gut, element gefunden.
				ficonda=conda;
			}
		}
		if (ficonda!=null) {
			if (!ficonda.getInwork()) {
				con.finishRequest(ficonda);
				con.add_workunit(-1);
			}
		}
	}	 catch(Exception e) {};
	
	
	
	
	
	
	
	
}
/**
 * Die Beschreibung der Methode hier eingeben.
 * Erstellungsdatum: (9.12.1999 10:48:52)
 * @return java.lang.String
 * @param value java.lang.String
 */
public String deleteSpace(String value) {
	StringBuffer str=new StringBuffer();
	for(int i=0;i<value.length();i++) {
		if (value.charAt(i)==' ') {
			str.append('+');
		} else {
			str.append(value.charAt(i));
		}
	}
	return str.toString();
}
/**
 * This method was created in VisualAge.
 */
public void gen_adm_clients(AdminConnection cl, String client, AdminUser user) {
	String txt;
	StringBuffer buf=new StringBuffer();
	buf.append("<TITLE>SetiProxy Admininterface - Client Details</TITLE>");
	buf.append("<html>");
	buf.append("<h2><center>SetiProxy Client Details</center></h2>");
	buf.append(lastline(user));

	// *********************************************************************************
	// Workunits anzeigen....
	Client cli=con.getClient(client);
	if (cli!=null) {
		buf.append("<hr>");
		buf.append("<h2>"+LS.ls("asac1")+" "+client +"</h2>");
		byte lookupanswer[]=cli.getLookupAnswer();
		if (lookupanswer!=null) {
			buf.append("<pre>"+new String(lookupanswer)+"</pre><p>");
		} else {
			buf.append("<h3>"+LS.ls("asac2")+"</h3><br>");
		}
		buf.append("<p>"+LS.ls("asac3")+"<p>");

		buf.append("<hr>");
		buf.append("<h2>"+LS.ls("asac4") + "</h2>");
		byte workunitloader[]=(byte[])cli.getLookupProperties().get("setiproxykey-get_work_unit");
		if (workunitloader!=null) {
			buf.append("<pre>"+new String(workunitloader)+"</pre><p>");
		} else {
			buf.append("<h3>"+LS.ls("asac16")+"</h3><br>");
		}
		buf.append("<p>"+LS.ls("asac5"));
		buf.append("<hr>");


		byte lastanswer[]=(byte[])cli.getLookupProperties().get("setiproxykey-send_result_get_user_stats");
		if (lastanswer==null) {
			lastanswer=(byte[])cli.getLookupProperties().get("setiproxykey-send_result");
		}
		buf.append("<h2>"+LS.ls("asac17") + "</h2>");
		if (lastanswer!=null) {
			buf.append("<pre>"+new String(lastanswer)+"</pre><p>");
		} else {
			buf.append("<h3>"+LS.ls("asac18")+"</h3>");
		}
			
		

		
		
		/*
		buf.append("<hr>");
		buf.append("<h3>"+LS.ls("asac6") + " " + client+"</h3>");
		buf.append("<form action=\"postadmin.html\" method=\"post\">");
		buf.append("<input type=hidden Name=\"sendclient\" value=\""+client+"\">");
		buf.append("<table border width=\"100%\" cols=2>");
		if (lookupanswer!=null) {
			buf.append("<tr>");
			buf.append("<td width=\"10%\"><input type=\"submit\" name=\"operation\" value=\""+LS.ls("asac7")+"\"></td>");
			buf.append("<td>"+LS.ls("asac8")+"</td>");
			buf.append("</tr>");
		}
		buf.append("<td><input type=\"submit\" name=\"operation\" value=\""+LS.ls("asac9")+"\"></td>");
		buf.append("<td>"+LS.ls("asac10a")+" "+build_client_select()+ LS.ls("asac10b")+"</td>");
		buf.append("</tr>");
		buf.append("</tr>");
		buf.append("<td><input type=\"submit\" name=\"operation\" value=\""+LS.ls("asac11")+"\"></td>");
		buf.append("<td>"+LS.ls("asac12a")+" ");
		buf.append("<input type=text size=20 maxlength=255 name=\"loadclientname\">");
		buf.append(LS.ls("asac12b")+"</td>");
		buf.append("</tr>");
		if (lookupanswer!=null) {
			buf.append("<tr>");
			buf.append("<td><input type=\"submit\" name=\"operation\" value=\""+LS.ls("asac13")+"\"></td>");
			buf.append("<td>"+LS.ls("asac14a")+" ");
			buf.append("<input type=text size=20 maxlength=255 name=\"saveclientname\">");
			buf.append(LS.ls("asac14b")+"</td>");
		buf.append("</tr>");
		}

		buf.append("</table>");
		buf.append("</form>");
		*/
	} else {
		buf.append("<h2>"+LS.ls("asac15a")+" " + client+LS.ls("asac15b")+"</h2>");
	}
	buf.append(lastline(user));
		
	buf.append("<br><br>SetiProxy-AdminServer by Stevie in 1999");
	buf.append("</html>");

	answer_html(cl, buf);

}
/**
 * This method was created in VisualAge.
 */
public void gen_adm_clients(AdminConnection cl, AdminUser user) {
	StringBuffer buf=new StringBuffer();
	buf.append("<TITLE>SetiProxy Admininterface - Clients</TITLE>");
	buf.append("<html>");
	buf.append("<h2><center>SetiProxy Client Administration</center></h2>");
	buf.append(lastline(user));
	buf.append("<hr>");
	buf.append("<h3>"+LS.ls("asadmcl1")+"</h3>");
	buf.append("<form action=\"postadmin.html\" method=\"post\">");
	buf.append(build_client_select());
	buf.append("<br>");
	buf.append("");
	buf.append("<input type=\"submit\" name=\"operation\" value=\""+LS.ls("asadmcl2")+"\"><br>");
	buf.append("</form>");
	buf.append("<br><hr><br>");
	buf.append("<h3>"+LS.ls("asadmcl3")+"</h3>");
	buf.append("<form action=\"postadmin.html\" method=\"post\">");
	buf.append("<input type=text size=20 maxlength=50 name=\"client\" value=\"\"><br>");
	buf.append("<input type=\"submit\" name=\"operation\" value=\""+LS.ls("asadmcl4")+"\"><br>");
	buf.append("</form>");

	buf.append(lastline(user));
		
	buf.append("<br><br>SetiProxy-AdminServer by Stevie in 1999");
	buf.append("</html>");

	answer_html(cl, buf);
}
/**
 * This method was created in VisualAge.
 */
public void gen_adm_erginfo(AdminConnection cl, String hash, AdminUser user) {
	String txt;
	StringBuffer buf=new StringBuffer();
	buf.append("<TITLE>SetiProxy Admininterface - Result</TITLE>");
	buf.append("<html>");
	buf.append("<h2><center>Ergebnis - Detailansicht</center></h2>");
	buf.append(lastline(user));
	int inthash=0;
	try {
		inthash=Integer.parseInt(hash);
		// Ok, jetzt haben wir die Parameter, jetzt das entsprechende erg finden....
		Enumeration ergs=con.getWaitingUnits();
		ClientConnectionData ficonda=null;
		while ((ergs.hasMoreElements()) && (ficonda==null)) {
			ClientConnectionData conda=(ClientConnectionData)ergs.nextElement();
			if (conda.hashCode()==inthash) {
				// Gut, element gefunden.
				ficonda=conda;
			}
		}
	
		if (ficonda!=null) {
		  	java.text.SimpleDateFormat datform=new java.text.SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
			String out=datform.format(ficonda.getDatum());
			
			buf.append("<h3>Ergebnis am " + out + " von Client " + ficonda.getClient().getClientName() + " abgegeben.</h3><p>");
			buf.append("<pre>");
			buf.append(new String(ficonda.getRohDaten()));
			buf.append("</pre>");
		} else {
			buf.append("Das Ergebnis konnte nicht mehr gefunden werden. Es wurde eventuell schon abgeschickt.");
		}

	} catch(Exception e) {
		buf.append("<h3>Fehler: Parameterbergabe falsch.</h3>");
		return;
	}
	
	buf.append(lastline(user));
	buf.append("<br><br>SetiProxy-AdminServer by Stevie in 1999");
	buf.append("</html>");

	answer_html(cl, buf);

}
/**
 * This method was created in VisualAge.
 */
public void gen_adm_ergs(AdminConnection cl, AdminUser user) {
	String txt;
	StringBuffer buf=new StringBuffer();
	buf.append("<TITLE>SetiProxy Admininterface - Results</TITLE>");
	buf.append("<html>");
	buf.append("<h2><center>"+LS.ls("asge1")+"</center></h2>");
	buf.append(lastline(user));

	// *********************************************************************************
	// Workunits anzeigen....
	buf.append("<hr><h3>"+LS.ls("asge2")+"</h3>");
	buf.append("<table border cols=3 width=\"500\">");
	buf.append("<td>"+LS.ls("asge3")+"</td>");
	buf.append("<td>"+LS.ls("asge4")+"</td>");
	buf.append("<td>"+LS.ls("asge5")+"</td><tr>");

  Enumeration enum=con.getWaitingUnits();
  int i=0;
  while (enum.hasMoreElements()) {
	  i++;
	  ClientConnectionData conda=(ClientConnectionData)enum.nextElement();
  	java.text.SimpleDateFormat datform=new java.text.SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
		String out=datform.format(conda.getDatum());
  	//String link="\"/erginfo.html?date="+conda.getDatum().getTime()+"&client="+conda.getClient().getClientName()+"\"";
  	String link="\"/erginfo.html?hash="+conda.hashCode()+"\"";
		buf.append("<tr><td><a href="+link+">"+out+"</a></td>");
		buf.append("<td><a href="+link+">"+conda.getClient().getClientName()+"</a></td>");
		buf.append("<td><a href="+"\"/deleteerg.html?hash="+conda.hashCode()+"\">"+LS.ls("asge6")+"</a></td></tr>");
  }
  buf.append("</table><p>");
	buf.append(lastline(user));
		
	buf.append("<br><br>SetiProxy-AdminServer by Stevie in 1999");
	buf.append("</html>");

	answer_html(cl, buf);

}
/**
 * This method was created in VisualAge.
 */
public void gen_adm_logs(AdminConnection cl, boolean show, AdminUser user) {
	StringBuffer buf=new StringBuffer();
	StringBuffer control=new StringBuffer();
	buf.append("<TITLE>SetiProxy Admininterface - Logs</TITLE>");
	buf.append("<html>");
	buf.append("<h2><center>"+LS.ls("asal1")+"</center></h2>");
	buf.append(lastline(user));
	buf.append("<hr>");
	buf.append("<h3>"+LS.ls("asal2")+"</h3>");
	
	control.append("<form action=\"postadmin.html\" method=\"post\">");
	control.append("<table border cols=3><tr><td><center>"+LS.ls("asal3a")+"</center></td><td><center>"+LS.ls("asal3b")+"</center></td><td><center>"+LS.ls("asal3c")+"</center></td><tr>");
	control.append("<tr><td><center>");
	control.append(build_select(1999, 2010, logsvonjahr, "vonjahr"));
	control.append(build_select(1, 12, logsvonmonat, "vonmonat"));
	control.append(build_select(1, 31, logsvontag, "vontag"));
	control.append("</center></td><td><center>");
	control.append(build_select(1999, 2010, logsbisjahr, "bisjahr"));
	control.append(build_select(1, 12, logsbismonat, "bismonat"));
	control.append(build_select(1, 31, logsbistag, "bistag"));
	control.append("</center></td><td><center><select name=\"loglevel\">");
	for(int i=0;i<con.logs.length;i++) {
		if (i==loglevel) {
			control.append("<option selected>"+con.logs[i]);
		} else {
			control.append("<option>"+con.logs[i]);
		}
	}
	control.append("</select></center></td></tr></table></center>");
	control.append("</select><br><center>");
	control.append("<input type=\"submit\" name=\"operation\" value=\""+LS.ls("asal4")+"\"><br>");
	control.append("</center></form>");

	buf.append(control);
	if (show) {
		buf.append("<hr><pre>");
		String wert=con.getlogentries(logsvontag, logsvonmonat, logsvonjahr,
																 logsbistag, logsbismonat, logsbisjahr, loglevel);
		buf.append(wert);
		buf.append("<hr></pre>");
		buf.append(control);
	}
	
	buf.append(lastline(user));
	buf.append("<br><br>SetiProxy-AdminServer by Stevie in 1999");
	buf.append("</html>");

	answer_html(cl, buf);
}
/**
 * This method was created in VisualAge.
 */
public void gen_adm_offline(AdminConnection cl, AdminUser user) {
	StringBuffer buf=new StringBuffer();
	buf.append("<TITLE>SetiProxy Admininterface - Offline-Dienste</TITLE>");
	buf.append("<html>");
	buf.append("<h2><center>SetiProxy Client Administration</center></h2>");
	buf.append(lastline(user));
	buf.append("<hr>");
  buf.append("<form action=\"postadmin.html\" method=\"post\">");
  // Exportieren....

  

  int i=0;
	Enumeration enum=con.enumWorkunits();
  while (enum.hasMoreElements()) {
	  i++;
	  Workunit wu=(Workunit)enum.nextElement();
  }
 
  buf.append("<hr><h3>Synchronisations-Datei auf der Online-Seite abgleichen</h3><p>");
  buf.append("<table cols=2 width=\"500\">");
  buf.append("<tr><td>Dateiname: </td>");
  buf.append("<td><input type=text size=50 maxlength=255 name=\"onlinefile\"></td></tr>");
  buf.append("</table>");
  buf.append("<br><b>1. Schritt: Results laden:</b><br>");
  buf.append("Diese Funktion dient dazu, die Ergebnisse vom Offline-Proxy(der ohne Internetzugang) zu laden.<br>");
  buf.append("<center><input type=\"submit\" name=\"operation\" value=\"Online-Datei lesen\"></center>");
  buf.append("<p><b>2. Schritt: Die Results versenden. Dies bitte wie gewohnt im Proxy anstossen.</b>");
  buf.append("<p><b>3. Schritt: Workunits exportieren sowie die Client profile bertragen:</b><br>");
  buf.append("Dieser Schritt schreibt Workunits sowie die sich inzwischen genderten Clientprofile in eine");
  buf.append(" Datei die dann spter vom Offline-Proxy eingelesen werden kann.<br>");
  buf.append("<table cols=2 width=\"500\">");
  buf.append("<tr><td>Anzahl zu exportierender WU's</td>");
  buf.append("<td>"+build_select(1, i, i, "anzexportwus")+"</td></tr>");
  buf.append("</table>");
  buf.append("<td><center><input type=\"submit\" name=\"operation\" value=\"Online-Datei erstellen\"></center></td></tr>");

  // Importieren...
  buf.append("<hr><h3>Synchronisations-Datei auf der Offline-Seite abgleichen</h3><p>");
  buf.append("<table cols=2 width=\"500\">");
  buf.append("<tr><td>Dateiname: </td>");
  buf.append("<td><input type=text size=50 maxlength=255 name=\"offlinefile\"></td></tr>");
  buf.append("</table>");
  buf.append("<br><b>1. Schritt: Workunits und Clientprofile laden:</b><br>");
  buf.append("Diese Funktion dient dazu, Workunits zu importieren sowie die Clientprofile zu updaten..<br>");
  buf.append("<center><input type=\"submit\" name=\"operation\" value=\"Offline-Datei lesen\"></center>");
  buf.append("<p><b>2. Schritt: Die Clients wie gewohnt die WU's ausrechnen lassen.</b>");
  buf.append("<p><b>3. Schritt: Errechneten Ergebnisse in eine Datei exportieren.</b><br>");
  buf.append("Dieser Schritt erzeugt die Datei mit Results, die vom Online-Proxy eingeladen wird.");
  buf.append("<td><center><input type=\"submit\" name=\"operation\" value=\"Offline-Datei erstellen\"></center></td></tr>");

  buf.append("</form><p>");

	buf.append(lastline(user));
		
	buf.append("<br><br>SetiProxy-AdminServer by Stevie in 1999");
	buf.append("</html>");

	answer_html(cl, buf);
}
/**
 * This method was created in VisualAge.
 */
public void gen_adm_paras(AdminConnection cl, AdminUser user) {
	String txt;
	StringBuffer buf = new StringBuffer();
	buf.append("<TITLE>SetiProxy Admininterface - Konfiguration</TITLE>");
	buf.append("<html>");
	buf.append("<h2><center>SetiProxy Configuration</center></h2>");
	buf.append(lastline(user));

	// *********************************************************************************
	// Allgemeines
	buf.append("<hr><h3>" + LS.ls("asap1") + "</h3>");
	buf.append("<form action=\"postadmin.html\" method=\"post\">");
	buf.append("<table cols=2 width=\"100%\">");

	String recon[] = 
		{
			LS.ls("guiac1"), 
			LS.ls("guiac2"), 
			LS.ls("guiac3"), 
			LS.ls("guiac4"), 
			LS.ls("guiac5"), 
			LS.ls("guiac6")}; 

	// Reconnect
	buf.append("<tr><td>" + LS.ls("asap2") + "</td>");
	txt = con.getProperty("reconnect");
	txt = (txt == null) ? ("-1") : txt;

	try {
		int wert = new Integer(txt).intValue();
		if (wert == -1) {
			txt = LS.ls("guia1");
		}
		if (wert == 6000) {
			txt = LS.ls("guia2");
		}
		if (wert == 18000) {
			txt = LS.ls("guia3");
		}
		if (wert == 36000) {
			txt = LS.ls("guia4");
		}
		if (wert == 216000) {
			txt = LS.ls("guia5");
		}
		if (wert == 864000) {
			txt = LS.ls("guia6");
		}
	} catch (Exception e) {
		txt = LS.ls("guia1");
	}

	buf.append("<td><select name=\"reconnect\">");
	for (int i = 0; i < recon.length; i++) {
		if (recon[i].equals(txt)) {
			buf.append("<option selected>" + recon[i]);
		} else {
			buf.append("<option>" + recon[i]);
		};
	}
	buf.append("</select></td>");
	// Workunits
	buf.append("</tr><tr><td>" + LS.ls("asap3") + "</td>");
	txt = con.getProperty("lagerunits");
	txt = (txt == null) ? ("0") : txt;
	buf.append(
		"<td><input type=text size=6 maxlength=6 name=\"lagerunits\" value=\""
			+ txt
			+ "\"></td>"); 
	// WorkLinear-Flag
	txt = con.getProperty("worklinear");
	if ((txt != null) && (txt.equals("ja"))) {
		txt = "CHECKED";
	} else {
		txt = "";
	}
	buf.append(
		"</tr><tr><td><input type=\"checkbox\" name=\"worklinear\" "
			+ txt
			+ "> "
			+ LS.ls("asap4")
			+ "</td><td></td>"); 
	/*
	// connectonlymanual-Flag
	txt=con.getProperty("connectonlymanual");
	if ((txt!=null) && (txt.equals("ja"))) {
	  txt="CHECKED";
	} else {
	  txt="";
	}
	buf.append("</tr><tr><td><input type=\"checkbox\" name=\"connectonlymanual\" "+txt+"> "+LS.ls("asap5")+"</td><td></td>");
	*/
	// autoclientinsert-Flag
	txt = con.getProperty("autoclientinsert");
	if ((txt != null) && (txt.equals("ja"))) {
		txt = "CHECKED";
	} else {
		txt = "";
	}
	buf.append(
		"</tr><tr><td><input type=\"checkbox\" name=\"autoclientinsert\" "
			+ txt
			+ "> "
			+ LS.ls("asap13")
			+ "</td><td></td>"); 
	// AdminService-Flag
	txt = con.getProperty("adminservice");
	if ((txt != null) && (txt.equals("ja"))) {
		txt = "CHECKED";
	} else {
		txt = "";
	}
	buf.append(
		"</tr><tr><td><input type=\"checkbox\" name=\"adminservice\" "
			+ txt
			+ "> "
			+ LS.ls("asap6")
			+ "</td><td></td>");
	// lokaler Port
	buf.append("<tr><td>Port fr Admin-Service</td>");
	txt = con.getProperty("adminport");
	txt = (txt == null) ? ("8083") : txt;
	buf.append(
		"<td><input type=text size=6 maxlength=6 name=\"adminport\" value=\""
			+ txt
			+ "\"></td>"); 
	// Remotezugriff auf Adminservice erlauben...
/*	txt = con.getProperty("adminserviceremoteaccess");
	if ((txt != null) && (txt.equals("ja"))) {
		txt = "CHECKED";
	} else {
		txt = "";
	}
	buf.append(
		"</tr><tr><td><input type=\"checkbox\" name=\"adminserviceremoteaccess\" "
			+ txt
			+ "> "
			+ LS.ls("asap24")
			+ "</td><td></td>"); 
*/
	buf.append("</tr></table><br>");
	buf.append(
		"<input type=\"submit\" name=\"operation\" value=\""
			+ LS.ls("asap7")
			+ "\"><br>"); 
	buf.append("</form>");



	// *********************************************************************************
	// Netzwerkkonfiguration
	buf.append("<hr><h3>" + LS.ls("asap8") + "</h3>");
	buf.append("<form action=\"postadmin.html\" method=\"post\">");
	buf.append("<table cols=2 width=\"100%\">");
	// lokaler Port
	buf.append("<tr><td>" + LS.ls("asap9") + "</td>");
	txt = con.getProperty("port");
	txt = (txt == null) ? ("8080") : txt;
	buf.append(
		"<td><input type=text size=6 maxlength=6 name=\"port\" value=\""
			+ txt
			+ "\"></td>"); 
	// Proxy-Flag
	txt = con.getProperty("proxy");
	if ((txt != null) && (txt.equals("ja"))) {
		txt = "CHECKED";
	} else {
		txt = "";
	}
	buf.append(
		"</tr><tr><td><input type=\"checkbox\" name=\"proxy\" "
			+ txt
			+ "> "
			+ LS.ls("asap10")
			+ "</td><td></td>"); 
	// Proxy-Adresse
	buf.append("</tr><tr><td>Proxy-Adresse</td>");
	txt = con.getProperty("proxyadresse");
	txt = (txt == null) ? ("") : txt;
	buf.append(
		"<td><input type=text size=30 maxlength=255 name=\"proxyadresse\" value=\""
			+ txt
			+ "\"></td>"); 
	// Proxy-Port
	buf.append("</tr><tr><td>Proxy-Port</td>");
	txt = con.getProperty("proxyport");
	txt = (txt == null) ? ("") : txt;
	buf.append(
		"<td><input type=text size=6 maxlength=6 name=\"proxyport\" value=\""
			+ txt
			+ "\"></td>"); 
	// Authentifizierung-Flag
	txt = con.getProperty("proxyauth");
	if ((txt != null) && (txt.equals("ja"))) {
		txt = "CHECKED";
	} else {
		txt = "";
	}
	buf.append(
		"</tr><tr><td><input type=\"checkbox\" name=\"proxyauth\" "
			+ txt
			+ "> "
			+ LS.ls("asap11")
			+ "</td><td></td>"); 
	// Proxy-User
	buf.append("</tr><tr><td>Proxy-User</td>");
	txt = con.getProperty("proxyuser");
	txt = (txt == null) ? ("") : txt;
	buf.append(
		"<td><input type=text size=30 maxlength=255 name=\"proxyuser\" value=\""
			+ txt
			+ "\"></td>"); 
	// Proxy-Passwort
	buf.append("</tr><tr><td>Proxy-Passwort</td>");
	buf.append(
		"<td><input type=password size=30 maxlength=255 name=\"proxypasswort\" value=\"\"></td>"); 

	buf.append("</tr></table><br>");
	buf.append(
		"<input type=\"submit\" name=\"operation\" value=\""
			+ LS.ls("asap12")
			+ "\"><br>"); 
	buf.append("</form>");

	// *********************************************************************************
	// Zeit-Konfiguration
	buf.append("<hr><h3>" + LS.ls("asap14") + "</h3>");
	buf.append("<form action=\"postadmin.html\" method=\"post\">");

	// Radiogruppe
	txt = con.getProperty("connectonlymanual");
	int pos = 0;
	if (txt == null) {
		txt = "nein";
	}
	if (txt.equals("ja")) {
		pos = 1;
	}
	if (txt.equals("time")) {
		pos = 2;
	}

	buf.append("<INPUT type=\"radio\" name=\"connectonlymanual\" value=\"con1\"");
	if (pos == 0) {
		buf.append(" checked");
	}
	buf.append(">" + LS.ls("asap15") + "<br>");
	buf.append("<INPUT type=\"radio\" name=\"connectonlymanual\" value=\"con2\"");
	if (pos == 1) {
		buf.append(" checked");
	}
	buf.append(">" + LS.ls("asap16") + "<br>");
	buf.append("<INPUT type=\"radio\" name=\"connectonlymanual\" value=\"con3\"");
	if (pos == 2) {
		buf.append(" checked");
	}
	buf.append(">" + LS.ls("asap17") + "<br>");

	// Jetzt die einzelnen Parameter einholen...
	Integer startst1 = null, startmi1 = null, stopst1 = null, stopmi1 = null;
	Integer startst2 = null, startmi2 = null, stopst2 = null, stopmi2 = null;
	txt = con.getProperty("connecttime1");
	if (txt != null) {
		startst1 = MainController.getTimeElement(txt, 0);
		startmi1 = MainController.getTimeElement(txt, 1);
		stopst1 = MainController.getTimeElement(txt, 2);
		stopmi1 = MainController.getTimeElement(txt, 3);
	}
	txt = con.getProperty("connecttime2");
	if (txt != null) {
		startst2 = MainController.getTimeElement(txt, 0);
		startmi2 = MainController.getTimeElement(txt, 1);
		stopst2 = MainController.getTimeElement(txt, 2);
		stopmi2 = MainController.getTimeElement(txt, 3);
	}

	buf.append("<blockquote><table border=\"1\"><tr><td>");

	buf.append("<INPUT type=\"checkbox\" name=\"connecttime1\"");
	if ((startst1 != null)
		&& (startmi1 != null)
		&& (stopst1 != null)
		&& (stopmi1 != null)) {
		buf.append(" checked");
	} else {
		startst1 = new Integer(0);
		startmi1 = new Integer(0);
		stopst1 = new Integer(0);
		stopmi1 = new Integer(0);
	}
	buf.append(">" + LS.ls("asap18") + "</td><td>");
	buf.append("<INPUT type=\"checkbox\" name=\"connecttime2\"");
	if ((startst2 != null)
		&& (startmi2 != null)
		&& (stopst2 != null)
		&& (stopmi2 != null)) {
		buf.append(" checked");
	} else {
		startst2 = new Integer(0);
		startmi2 = new Integer(0);
		stopst2 = new Integer(0);
		stopmi2 = new Integer(0);
	}
	buf.append(">" + LS.ls("asap19") + "</td></tr>");

	buf.append("<tr><td><table>");
	buf.append("<tr><td>" + LS.ls("asap20") + "</td>");
	buf.append(
		"<td>" + build_select(0, 23, startst1.intValue(), "zeit1startstunde") + "<td>"); 
	buf.append(
		"<td>"
			+ build_select(0, 59, startmi1.intValue(), 5, "zeit1startminute")
			+ "<td>"); 
	buf.append("<tr><td>" + LS.ls("asap21") + "</td>");
	buf.append(
		"<td>" + build_select(0, 23, stopst1.intValue(), "zeit1stopstunde") + "<td>"); 
	buf.append(
		"<td>"
			+ build_select(0, 59, stopmi1.intValue(), 5, "zeit1stopminute")
			+ "<td>"); 
	buf.append("</tr></table></td>");

	buf.append("<td><table>");
	buf.append("<tr><td>" + LS.ls("asap20") + "</td>");
	buf.append(
		"<td>" + build_select(0, 23, startst2.intValue(), "zeit2startstunde") + "<td>"); 
	buf.append(
		"<td>"
			+ build_select(0, 59, startmi2.intValue(), 5, "zeit2startminute")
			+ "<td>"); 
	buf.append("<tr><td>" + LS.ls("asap21") + "</td>");
	buf.append(
		"<td>" + build_select(0, 23, stopst2.intValue(), "zeit2stopstunde") + "<td>"); 
	buf.append(
		"<td>"
			+ build_select(0, 59, stopmi2.intValue(), 5, "zeit2stopminute")
			+ "<td>"); 
	buf.append("</tr></table></td></tr></table>");

	// autotimereconnect-Flag
	txt = con.getProperty("autotimereconnect");
	if ((txt != null) && (txt.equals("ja"))) {
		txt = "checked";
	} else {
		txt = "";
	}
	buf.append(
		"</tr><tr><td><input type=\"checkbox\" name=\"autotimereconnect\" "
			+ txt
			+ "> "
			+ LS.ls("asap22")
			+ "</td><td></td>"); 
	buf.append("</blockquote>");

	buf.append(
		"<input type=\"submit\" name=\"operation\" value=\""
			+ LS.ls("asap23")
			+ "\"><br>"); 
	buf.append("</form>");

	buf.append(lastline(user));

	buf.append("<br><br>SetiProxy-AdminServer by Stevie in 1999");
	buf.append("</html>");

	answer_html(cl, buf);
}
/**
 * This method was created in VisualAge.
 */
public void gen_adm_users(
	AdminConnection cl, 
	AdminUser user, 
	String pUser, 
	boolean pAdmin, 
	String message) 
{
		
	StringBuffer buf = new StringBuffer();
	buf.append("<TITLE>SetiProxy Admininterface - WebUsers</TITLE>");
	buf.append("<html>");
	buf.append("<h2><center>SetiProxy Websecurity Administration</center></h2>");
	buf.append(lastline(user));
	buf.append("<hr>");

	buf.append("<h3>");
	buf.append(LS.ls("acsc18"));
	buf.append("</h3>");
		
	buf.append("<form action=\"postwebuser.html\" method=\"post\">");
	buf.append("<table>");
	// Remotezugriff auf Adminservice erlauben...
	String txt = con.getProperty("adminserviceremoteaccess");
	if ((txt != null) && (txt.equals("ja"))) {
		txt = "CHECKED";
	} else {
		txt = "";
	}
	buf.append(
		"</tr><tr><td><input type=\"checkbox\" name=\"adminserviceremoteaccess\" "
			+ txt
			+ "> "
			+ LS.ls("asap24")
			+ "</td><td></td>"); 

	// Remotezugriff auf Adminservice erlauben...
	txt = con.getProperty("adminservicesecurity");
	if ((txt != null) && (txt.equals("ja"))) {
		txt = "CHECKED";
	} else {
		txt = "";
	}
	buf.append(
		"</tr><tr><td><input type=\"checkbox\" name=\"adminservicesecurity\" "
			+ txt
			+ "> "
			+ LS.ls("acsc19")
			+ "</td><td></td>"); 

	buf.append("</table>");
	
	buf.append("<input type=\"submit\" name=\"operation\" value=\"");
	buf.append(LS.ls("acsc20"));
	buf.append("\"></input><hr>");
	
	buf.append("<h3>");
	buf.append(LS.ls("acsc2"));
	buf.append("</h3>");
	buf.append("<table border=1 cols=3 width=\"500\">");

	buf.append("<tr><td colspan=2><center>");
	buf.append(build_user_select(pUser));

	buf.append("</center></td><td colspan=2>");

	buf.append("<table>");
	buf.append("<tr><td>");
	buf.append(LS.ls("acsc6"));
	buf.append("</td><td><input type=text size=30 maxlength=30 name=\"userid");
	if (pUser != null) {
		buf.append("\" value=\"");
		buf.append(pUser);
	}
	buf.append("\"></td></tr>");

	buf.append("<tr><td>");
	buf.append(LS.ls("acsc7"));
	buf.append(
		"</td><td><input type=password size=30 maxlength=30 name=\"password\"></td></tr>"); 

	buf.append("<tr><td>");
	buf.append(LS.ls("acsc8"));
	buf.append("</td><td><input type=checkbox name=\"administrator\"");
	if (pAdmin) {
		buf.append(" checked></input></td></tr>");
	} else {
		buf.append("></input></td></tr>");
	}
	buf.append("</table>");
	buf.append("</td></tr>");

	buf.append("<tr><td><center>");
	buf.append("<input type=\"submit\" name=\"operation\" value=\"");
	buf.append(LS.ls("acsc10"));
	buf.append("\"</input></center></td>");

	buf.append("<td><center>");
	buf.append("<input type=\"submit\" name=\"operation\" value=\"");
	buf.append(LS.ls("acsc4"));
	buf.append("\"></input></center></td><td><center>");
	buf.append("<input type=\"submit\" name=\"operation\" value=\"");
	buf.append(LS.ls("acsc3"));
	buf.append("\"></input></center></td><td><center>");
	buf.append("<input type=\"submit\" name=\"operation\" value=\"");
	buf.append(LS.ls("acsc5"));
	buf.append("\"></input></center></td></tr></table></form>");
	if (message != null) {
		buf.append("<font color=\"#FF0000\">");
		buf.append(message);
		buf.append("</font>");
	}

	buf.append(lastline(user));

	buf.append("<br><br>SetiProxy-AdminServer by Stevie in 1999");
	buf.append("</html>");

	answer_html(cl, buf);
}
/**
 * This method was created in VisualAge.
 */
public void gen_adm_wus(AdminConnection cl, AdminUser user) {
	String txt;
	StringBuffer buf=new StringBuffer();
	buf.append("<TITLE>SetiProxy Admininterface - Workunits</TITLE>");
	buf.append("<html>");
	buf.append("<h2><center>"+LS.ls("asaw1")+"</center></h2>");
	buf.append(lastline(user));

	// *********************************************************************************
	// Workunits anzeigen....
	buf.append("<hr><h3>"+LS.ls("asaw2")+"</h3>");
	buf.append("<table border cols=4 width=\"600\">");
	buf.append("<tr><td>"+LS.ls("asaw3")+"</td>");
	buf.append("<td>"+LS.ls("asaw4")+"</td>");
	buf.append("<td>"+LS.ls("asaw5")+"</td>");
	buf.append("<td>"+LS.ls("asaw6")+"</td></tr>");

  Enumeration enum=con.enumWorkunits();
  int i=0;
  while (enum.hasMoreElements()) {
	  i++;
	  Workunit wu=(Workunit)enum.nextElement();
  	java.text.SimpleDateFormat datform=new java.text.SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
		String out=datform.format(wu.getDatum());
		buf.append("<tr><td>"+wu.getFilename()+"</td>");
		buf.append("<td>"+out+"</td>");
		buf.append("<td>"+wu.getClient()+"</td>");
		buf.append("<td><a href=\"wuloeschen.html?fname="+wu.getFilename()+"\">"+LS.ls("asaw7")+"<a/></td>");
	
			
			
			
		buf.append("</tr>");
  }
  buf.append("</table><p>");
 
	buf.append(lastline(user));
		
	buf.append("<br><br>SetiProxy-AdminServer by Stevie in 1999");
	buf.append("</html>");

	answer_html(cl, buf);

}
/**
 * This method was created in VisualAge.
 */
public void gen_get_index(AdminConnection cl, AdminUser user) {
	StringBuffer buf=new StringBuffer();
	buf.append("<TITLE>SetiProxy Admininterface</TITLE>");
	buf.append("<html>");
	buf.append("<h2><center>SetiProxy</center></h2>");
	buf.append(lastline(user));
	buf.append("<hr>");
	if (user.isAdministrator()) {
		buf.append("<table cols=2 width=\"100%\">");
		buf.append("<tr><td>");
		buf.append("<center><a href=refresh.html>"+LS.ls("asgi1")+"</a></center>");
		buf.append("</td><td>");
		buf.append("<center><a href=stop.html>"+LS.ls("asgi2")+"</a></center>");
		buf.append("</td></tr></table><hr>");
	}
		
	buf.append("<h3>"+LS.ls("asgi3")+"</h3>");
	buf.append("<table border cols=2 width=\"100%\">");
	buf.append("<tr>");
	buf.append("<td><A href=\"wus.html\">"+LS.ls("asgi4")+"</A></td>");
	buf.append("<td>"+ con.getAdmininfo(con.ADMANZWORKUNITS) + "</td>");
	buf.append("</tr><tr>");
	buf.append("<td><A href=\"ergs.html\">"+LS.ls("asgi5")+"</A></td>");
	//buf.append("<td>Noch nicht gesendete Ergebnisse:</td>");
	buf.append("<td>"+ con.getAdmininfo(con.ADMANZREQUESTS) + "</td>");
	buf.append("</tr><tr>");
	buf.append("<td>"+LS.ls("asgi6")+"</td>");
	buf.append("<td>"+ con.getAdmininfo(con.ADMANZPROCESSES) + "</td>");
	buf.append("</tr><tr>");
	buf.append("<td>"+LS.ls("asgi7")+"</td>");
	buf.append("<td>"+ con.getAdmininfo(con.ADMSETICONNECTTRYDATE) + "</td>");
	buf.append("</tr><tr>");
	buf.append("<td>"+LS.ls("asgi8")+"</td>");
	buf.append("<td>"+ con.getAdmininfo(con.ADMSETICONNECTDATE) + "</td>");
	buf.append("</tr><tr>");
	buf.append("<td>"+LS.ls("asgi9")+"</td>");
	buf.append("<td>"+ con.getAdmininfo(con.ADMCLIENTCONNECT) + "</td>");
	buf.append("</tr><tr>");
	buf.append("<td>"+LS.ls("asgi10")+"</td>");
	buf.append("<td>"+ con.getAdmininfo(con.ADMCLIENTCONNECTDATE) + "</td>");
	buf.append("</tr>");
	buf.append("</table>");

	buf.append("<br><h3>Clients</h3>");

	buf.append("<table border cols=5 width=\"100%\" ><tr><td><b>"+LS.ls("asgi11")+"</b></td><td><b>"+LS.ls("asgi12")+"</b></td><td><b>"+LS.ls("asgi13")+"</b></td><td><b>"+LS.ls("asgi14")+"</b></td><td><b>"+LS.ls("asgi15")+"</b></td></tr>");

	Enumeration enum=con.getClients(Client.ALLE);
	while (enum.hasMoreElements()) {
		Client clien=(Client)enum.nextElement();
		buf.append("<tr>");
		buf.append("<td><A href=workclient.html?client="+clien.getClientName()+">"+clien.getClientName()+"</A></td>");
		String status=LS.ls("clstat2");
		if ((clien.getStatus()&Client.RECHNET)!=0) {
			status=LS.ls("clstat1");
		} else {
			if ((clien.getStatus()&Client.WARTET)!=0) {
				status=LS.ls("clstat2");
			} else {
				if ((clien.getStatus()&Client.NETZ)!=0) {
					status=LS.ls("clstat3");
				}
			}
		}

		buf.append("<td>"+status+"</td>");
		buf.append("<td>"+clien.getUnitsBisher()+"</td>");
		buf.append("<td>"+clien.getLastZugriff()+"</td>");
		buf.append("<td>"+((con.clientdata_complete(clien)!=null)?LS.ls("asgi16"):LS.ls("asgi17"))+"</td>");

		buf.append("</tr>");
	}
	buf.append("</table><br>");

	buf.append(lastline(user));
		
	buf.append("<br><br>SetiProxy-AdminServer by Stevie in 1999");
	buf.append("<br>" + MainController.version);
	buf.append("</html>");

	answer_html(cl, buf);
}
/**
 * Die Beschreibung der Methode hier eingeben.
 * Erstellungsdatum: (29.06.2001 21:49:56)
 * @return boolean
 * @param pUserid java.lang.String
 * @param pPassword java.lang.String
 * @param pAdministrator boolean
 */
private AdminUser getUser(String pUserid) {
	Enumeration enum=webUsers.elements();
	while (enum.hasMoreElements()) {
		AdminUser user=(AdminUser)enum.nextElement();
		if (user.getUserId().equals(pUserid)) {
			return user;
		}
	}
	return null;
}
/**
 * This method was created in VisualAge.
 * @return java.util.Properties
 * @param bytes char[]
 */
private boolean handle_profil(String func, Properties values) {
	/*
	try {
		Client orgcl=null;
		String orgclient=values.getProperty("sendclient");
		orgcl=con.getClient(orgclient);
		//*********************************************************************************
		// Verteilen....
		if (func.equals(deleteSpace(LS.ls("asac7")))) {
			byte clientprof[]=orgcl.getLookupAnswer();
			if (clientprof!=null) {
				Properties props=orgcl.getLookupProperties();
				Enumeration enum=con.getClients(Client.ALLE);
				while (enum.hasMoreElements()) {
					Client cl=(Client)enum.nextElement();
					if (cl.getClientName()!=orgcl.getClientName()) {
						cl.setLookupAnswer(clientprof);
						cl.setLookupProperties(props);
					}
				}
				// Dies dient nur der Speicherung... da der Client schon existiert, wird er
				// auch nicht neu eingefgt bzw. verndert.. tricky, eh ?!
				con.addClient(orgcl.getClientName());
			} else {
				con.log(LS.ls("ashp1a")+ " "+ orgclient + LS.ls("ashp1b"), con.LOG_ERROR);
			} 
		}
		//*********************************************************************************
		if (func.equals(deleteSpace(LS.ls("asac9")))) {
			Client zielcl=null;
			String zielclient=values.getProperty("client");
			zielcl=con.getClient(zielclient);
			byte []clientprof=zielcl.getLookupAnswer();
			if (clientprof!=null) {
				orgcl.setLookupAnswer(clientprof);
				orgcl.setLookupProperties(zielcl.getLookupProperties());
				con.addClient(orgclient);
			} else {
				con.log(LS.ls("ashp1a")+ " "+ orgclient + LS.ls("ashp1b"), con.LOG_ERROR);
			} 
		}
		//*********************************************************************************
		if (func.equals(deleteSpace(LS.ls("asac11")))) {
			String fname=values.getProperty("loadclientname");
			FileInputStream finp=new FileInputStream(fname);
			ObjectInputStream objin=new ObjectInputStream(finp);
			Vector data=(Vector)objin.readObject();
			Object obj1=data.elementAt(0);
			if (obj1.getClass().getName().equals("java.util.Properties")) {
				orgcl.setLookupProperties((Properties)obj1);
				Object obj2=data.elementAt(1);
				orgcl.setLookupAnswer((byte[])obj2);
			} else {
				orgcl.setLookupAnswer((byte[])obj1);
				Object obj2=data.elementAt(1);
				orgcl.setLookupProperties((Properties)obj2);
			}
			finp.close();
		}
		//*********************************************************************************
		if (func.equals(deleteSpace(LS.ls("asac13")))) {
			if (orgcl.getLookupAnswer()!=null) {
				String fname=values.getProperty("saveclientname");
			FileOutputStream fout=new FileOutputStream(fname);
			ObjectOutputStream objout=new ObjectOutputStream(fout);
			Vector data=new Vector(2);
			data.addElement(orgcl.getLookupProperties());
			data.addElement(orgcl.getLookupAnswer());
			objout.writeObject(data);
			objout.close();
			} else {
				con.log(LS.ls("ashp1a")+ " "+ orgclient + LS.ls("ashp1b"), con.LOG_ERROR);
			}
		}
	} catch(Exception e) {
		//con.log("Fehler handle_profil, Funktion: " + func + ", Properties: " + values + ": Exception: " + e, con.LOG_ERROR);
		con.log(LS.ls("ashp2a")+ " " + func + LS.ls("ashp2b") + " " + values + LS.ls("ashp2c")+ " " + e, con.LOG_ERROR);
		return false;
	}
	return true;
	*/
	return false;
}
/**
 * Die Beschreibung der Methode hier eingeben.
 * Erstellungsdatum: (29.06.2001 19:17:47)
 */
private void init() {
	// Hier initialisieren wir die User....
	try {
		ObjectInputStream inp=new ObjectInputStream(new FileInputStream("webusers.vector"));
		webUsers=(Vector)inp.readObject();
	} catch(Exception e) {
		log(LS.ls("asin2")+e, LOG_ERROR);
	}
	
	if ((con.getProperty("adminservicesecurity").equals("ja")) && (webUsers.size()==0)) {
		log(LS.ls("asin1"), LOG_ERROR);
		con.setProperty("adminservicesecurity", "nein");
	}
}
/**
 * This method was created in VisualAge.
 * @return java.lang.String
 */
public String lastline(AdminUser user) {
	StringBuffer line=new StringBuffer();
	if (user.isAdministrator()) {
		line.append("<hr><table cols=5 width=\"100%\"><tr><td><center><a href=\"index.html\">"+LS.ls("asll1")+"</a></center></td>");
		line.append("<td><center><a href=\"admclient.html\">"+LS.ls("asll2")+"</a></center></td>");
		line.append("<td><center><a href=\"admparams.html\">"+LS.ls("asll3")+"</a></center></td>");
		line.append("<td><center><a href=\"adminusers.html\">"+LS.ls("asll5")+"</a></center></td>");
		line.append("<td><center><a href=\"logs.html\">"+LS.ls("asll4")+"</a></center></td></tr></table>");
	} else {
		line.append("<hr><center><a href=\"index.html\">"+LS.ls("asll1")+"</a></center>");
	}		
	return line.toString();
}
/**
 * This method was created in VisualAge.
 * @param txt java.lang.String
 * @param level int
 */
public void log(String txt, int level) {
	if (con!=null) {
		con.log(txt, level);
	} else {
		System.out.println("Achtung: AdminServer ohne Maincontroller.");
		System.out.println(level + "/" + txt);
	}
}
/**
 * This method was created in VisualAge.
 */
public void run()  {
	Vector komm=new Vector();
	listener=new AdminListener(this, komm, port);

	running=true;
	while (running) {
		Object obj=null;
		try {
			obj=komm.firstElement();
		} catch(Exception e) {};
		if (obj!=null) {
			komm.removeElement(obj);
			String type=obj.getClass().getName();
			if (type.equals("SetiWebAdmin.AdminConnection")) {
				workConnection((SetiWebAdmin.AdminConnection)obj);
			} else {
				log(LS.ls("asrn1")+ obj.getClass().getName(), LOG_ERROR);
			}
		} else {
			try { Thread.sleep(100); } catch(Exception e) {};
		}
	}
}
/**
 * Die Beschreibung der Methode hier eingeben.
 * Erstellungsdatum: (29.06.2001 19:47:58)
 */
private void save() {
	try {
		ObjectOutputStream outp=new ObjectOutputStream(new FileOutputStream("webusers.vector"));
		outp.writeObject(webUsers)	;
		outp.close();
	} catch(Exception e)  {
		log(LS.ls("assv1")+e, con.LOG_ERROR);
	}
}
/**
 * This method was created in VisualAge.
 * @return java.util.Properties
 * @param bytes char[]
 */
public Properties scan_post(char [] data) {

	String line=new String(data);
	Properties props=new Properties();

	int p1=0, p2;
	do {
		String scan;
		p2=line.indexOf('&', p1+1);
		if (p2>0) {
			scan=line.substring(p1, p2);
			p1=p2+1;
		} else {
			scan=line.substring(p1);
		}

		int p3=scan.indexOf('=');
		props.put(scan.substring(0, p3), scan.substring(p3+1));
	} while (p2>0);

	return props;
}
/**
 * This method was created in VisualAge.
 */
public void start() throws java.lang.Exception {
	if (con==null) {
		log("Cannot start adminserver without maincontroller", 0);
		throw new Exception("Cannot start adminserver without maincontroller");
	}

	logsvontag=1;
	logsvonmonat=1;
	logsvonjahr=1999;
	Calendar cal=new GregorianCalendar();
	logsbistag=cal.get(cal.DAY_OF_MONTH);
	logsbismonat=cal.get(cal.MONTH)+1;
	logsbisjahr=cal.get(cal.YEAR);
	loglevel=con.LOG_WARNING;

	thread=new Thread(this, "AdminServer");
	thread.start();
	
}
/**
 * This method was created in VisualAge.
 */
public void stop() {

	if (listener!=null) {
		listener.stop();
	}
	
	running=false;
	if (thread!=null) {
		int timeout=500;
		while ((thread.isAlive()) && (timeout>0)) {
			running=false;
			try {	Thread.sleep(100);} catch(Exception e) {};
			timeout--;
		}
		if (timeout==0) {
			log(LS.ls("asst1"), LOG_ERROR);
			try {
				thread.destroy();
			} catch(Exception e) {};
		}
	}
		
}
/**
 * This method was created in VisualAge.
 * @param con SetiWebAdmin.AdminConnection
 */
public void work_post(AdminConnection cl, AdminUser user) {
	Properties post=scan_post(cl.getContent());
	
	String line=post.getProperty("operation");
	if (line!=null) {
		//********************************************************************************
		if (line.equals(deleteSpace(LS.ls("asadmcl2")))) {
			// HIer jetzt den Client lschen...
			String client=post.getProperty("client");
			if (client!=null) {
				con.deleteClient(client);
				gen_get_index(cl, user);
				return;
			}
		}
		//********************************************************************************
		if (line.equals(deleteSpace(LS.ls("asadmcl4")))) {
			// HIer jetzt den Client lschen...
			String client=post.getProperty("client");
			if (client!=null) {
				con.addClient(client);
				gen_get_index(cl, user);
				return;
			}
		}
		//********************************************************************************
		if (line.equals(deleteSpace(LS.ls("asap12")))) {
			if (post.getProperty("proxy")!=null) {
				con.setProperty("proxy", "ja");
			} else {
				con.setProperty("proxy", "nein");
			}
			
			con.setProperty("proxyadresse", post.getProperty("proxyadresse"));
			con.setProperty("proxyport", post.getProperty("proxyport"));

			if (post.getProperty("proxyauth")!=null) {
				con.setProperty("proxyauth", "ja");
			} else {
				con.setProperty("proxyauth", "nein");
			}
	
			con.setProperty("proxyuser", post.getProperty("proxyuser"));
			String pass=post.getProperty("proxypasswort");
			if (pass.length()>0) {
				con.setProxyPassword(pass);
			}

			int oldport=con.getLocalPort();	
			con.setProperty("port", post.getProperty("port"));
			if (con.getLocalPort()==0) {
				con.setProperty("port", new Integer(oldport).toString());
			}
			/*
			if (oldport!=con.getLocalPort()) {
				con.stop();
				con.init();
			}*/
			gen_get_index(cl, user);
			return;
		}
		//********************************************************************************
		if (line.equals(deleteSpace(LS.ls("asap7")))) {
			String recon[]={LS.ls("guiac1"), LS.ls("guiac2"), LS.ls("guiac3"), LS.ls("guiac4"), LS.ls("guiac5"), LS.ls("guiac6")};
			String recon2[]=new String[recon.length];
			for(int i=0;i<recon.length;i++) {
				recon2[i]=deleteSpace(recon[i]);
			}

			String txt=post.getProperty("reconnect");
			con.setProperty("reconnect", "-1");
			if (txt.equals(recon2[0])) {
				con.setProperty("reconnect", "-1");
			} 
			if (txt.equals(recon2[1])) {
				con.setProperty("reconnect", "6000");
			} 
			if (txt.equals(recon2[2])) {
				con.setProperty("reconnect", "18000");
			} 
			if (txt.equals(recon2[3])) {
				con.setProperty("reconnect", "36000");
			} 
			if (txt.equals(recon2[4])) {
				con.setProperty("reconnect", "216000");
			} 
			if (txt.equals(recon2[5])) {
				con.setProperty("reconnect", "864000");
			} 

			txt=post.getProperty("lagerunits");
	    int anz=0;
	    try {
		    anz=new Integer(txt).intValue();
		    if (anz<0) {
			    anz=0;
		    }
		    if (anz>con.MAX_WORKUNITS) {
			    anz=con.MAX_WORKUNITS;
		    }
	    } catch(Exception e) { }

			if (post.getProperty("worklinear")!=null) {
				con.setProperty("worklinear", "ja");
			} else {
				con.setProperty("worklinear", "nein");
			}
			if (post.getProperty("autoclientinsert")!=null) {
				con.setProperty("autoclientinsert", "ja");
			} else {
				con.setProperty("autoclientinsert", "nein");
			}

			
			if (post.getProperty("adminservice")!=null) {
				con.setProperty("adminservice", "ja");
			} else {
				con.setProperty("adminservice", "nein");
			}
			
			try {
				con.setProperty("adminport", ""+ new Integer(post.getProperty("adminport")).intValue());
			} catch(Exception e) {};


	    con.setProperty("lagerunits", new Integer(anz).toString());
	    gen_get_index(cl, user);
	    return;
		}


		//********************************************************************************
		// Zeitkonfiguration
		if (line.equals(deleteSpace(LS.ls("asap23")))) {
			String txt=post.getProperty("connectonlymanual");
			if (txt==null) {
				txt="con1";
			}
			if (txt.equals("con3")) {
				con.setProperty("connectonlymanual", "time");
			} else {
				if (txt.equals("con2")) {
					con.setProperty("connectonlymanual", "ja");
				} else {
					con.setProperty("connectonlymanual", "nein");
				}
			}
			if (post.getProperty("connecttime1")!=null) {
				try {
					con.setProperty("connecttime1", 
													Integer.parseInt(post.getProperty("zeit1startstunde"))+":"+
													Integer.parseInt(post.getProperty("zeit1startminute"))+":"+
													Integer.parseInt(post.getProperty("zeit1stopstunde"))+":"+
													Integer.parseInt(post.getProperty("zeit1stopminute")));
				} catch(Exception e) {
					con.setProperty("connecttime1", "");
				}
			} else {
				con.setProperty("connecttime1", "");
			}
			if (post.getProperty("connecttime2")!=null) {
				try {
					con.setProperty("connecttime2", 
													Integer.parseInt(post.getProperty("zeit2startstunde"))+":"+
													Integer.parseInt(post.getProperty("zeit2startminute"))+":"+
													Integer.parseInt(post.getProperty("zeit2stopstunde"))+":"+
													Integer.parseInt(post.getProperty("zeit2stopminute")));
				} catch(Exception e) {
					con.setProperty("connecttime2", "");
				}
			} else {
				con.setProperty("connecttime2", "");
			}
			if (post.getProperty("autotimereconnect")!=null) {
				con.setProperty("autotimereconnect", "ja");
			} else {
				con.setProperty("autotimereconnect", "nein");
			}
	    gen_get_index(cl, user);
	    return;
		}

		
		//********************************************************************************
		if (line.equals(deleteSpace(LS.ls("asal4")))) {
			// Variablen setzen...
			logsvontag=new Integer(post.getProperty("vontag")).intValue();
			logsvonmonat=new Integer(post.getProperty("vonmonat")).intValue();
			logsvonjahr=new Integer(post.getProperty("vonjahr")).intValue();
			logsbistag=new Integer(post.getProperty("bistag")).intValue();
			logsbismonat=new Integer(post.getProperty("bismonat")).intValue();
			logsbisjahr=new Integer(post.getProperty("bisjahr")).intValue();
			String txt=post.getProperty("loglevel");
			for(int i=0;i<con.logs.length;i++) {
				if (txt.equals(con.logs[i])) {
					loglevel=i;
				}
			}
			gen_adm_logs(cl, true, user);
			return;
		}
		//********************************************************************************
		if (line.equals(deleteSpace("Online-Datei+lesen"))) {
			String fname=post.getProperty("onlinefile");
			con.abgleich_online_read(fname);
	    gen_get_index(cl, user);
			return;
		}
		//********************************************************************************
		if (line.equals(deleteSpace("Online-Datei+erstellen"))) {
			int anz=new Integer(post.getProperty("anzexportwus")).intValue();
			String fname=post.getProperty("onlinefile");
			con.abgleich_online_write(anz, fname);
	    gen_get_index(cl, user);
			return;
		}
		//********************************************************************************
		if (line.equals("Offline-Datei+lesen")) {
			String fname=post.getProperty("offlinefile");
			con.abgleich_offline_read(fname);
	    gen_get_index(cl, user);
			return;
		}
		//********************************************************************************
		if (line.equals("Offline-Datei+erstellen")) {
			String fname=post.getProperty("offlinefile");
			con.abgleich_offline_write(fname);
	    gen_get_index(cl, user);
			return;
		}
	}
	
	answer_htmlerror(cl, 500, LS.ls("aswp1"))	;
}
/**
 * This method was created in VisualAge.
 * @param con SetiWebAdmin.AdminConnection
 */
public void work_post_useradmin(AdminConnection cl, AdminUser user) {
	Properties post=scan_post(cl.getContent());
	
	String line=post.getProperty("operation");
	if (line!=null) {

		
		//********************************************************************************
		if (line.equals(LS.ls("acsc20"))) {
			if (post.getProperty("adminserviceremoteaccess")!=null) {
				con.setProperty("adminserviceremoteaccess", "ja");
			} else {
				con.setProperty("adminserviceremoteaccess", "nein");
			}
			if (post.getProperty("adminservicesecurity")!=null) {
				con.setProperty("adminservicesecurity", "ja");
			} else {
				con.setProperty("adminservicesecurity", "nein");
			}
			gen_adm_users(cl, user, null, false, null);
			return;
		}


		//********************************************************************************
		if (line.equals(LS.ls("acsc3"))) {
			// Anlegen...
			String userid=post.getProperty("userid").trim();
			String password=post.getProperty("password").trim();
			boolean administrator=(post.getProperty("administrator")!=null)?true:false;
			if (addUser(userid, password, administrator)) {
				gen_adm_users(cl, user, "", false, LS.ls("acsc15"));
			} else {
				gen_adm_users(cl, user, userid, administrator, LS.ls("acsc11"));
			}
			return;
		}
			
		//********************************************************************************
		if (line.equals(LS.ls("acsc10"))) {
			String auswahl=post.getProperty("users");
			if (auswahl==null) {
				gen_adm_users(cl, user, "", false, LS.ls("acsc16"));
			} else {
				AdminUser choosenUser=getUser(auswahl);
				if (choosenUser==null) {
					gen_adm_users(cl, user, null, false, LS.ls("acsc16"));
				} else {
					gen_adm_users(cl, user, choosenUser.getUserId(), choosenUser.isAdministrator(), null);
				}					
			}
			return;
		}

		//********************************************************************************
		if (line.equals(LS.ls("acsc4"))) {
			String auswahl=post.getProperty("users");
			if (auswahl==null) {
				gen_adm_users(cl, user, "", false, LS.ls("acsc16"));
			} else {
				AdminUser choosenUser=getUser(auswahl);
				if (choosenUser==null) {
					gen_adm_users(cl, user, null, false, LS.ls("acsc12"));
				} else {
					webUsers.remove(choosenUser)					;
					gen_adm_users(cl, user, null, false, LS.ls("acsc13"));
				}					
			}
			return;
		}

		//********************************************************************************
		if (line.equals(LS.ls("acsc5"))) {
			String userid=post.getProperty("userid").trim();
			String password=post.getProperty("password").trim();
			boolean administrator=(post.getProperty("administrator")!=null)?true:false;
			AdminUser updateUser=getUser(userid);
			if (updateUser==null) {
				gen_adm_users(cl, user, userid, administrator, LS.ls("acsc7"));
			} else {
				if (password.length()>0) {
					updateUser.setPassword(password);
				}
				updateUser.setAdministrator(administrator);
				gen_adm_users(cl, user, userid, administrator, LS.ls("acsc14"));
			}
			return;
		}

	}
	answer_htmlerror(cl, 500, LS.ls("aswp1"))	;

}
/**
 * This method was created in VisualAge.
 * @param con SetiWebAdmin.AdminConnection
 */
public void workConnection(AdminConnection cl) {
	Properties paras=new Properties();
	AdminUser user;
	
	// Erstmal prfen, ob wir es berhaupt erlauben, das Leute von draussen reinkommen...
	String adminclient;
	String localclient;
	try {
		adminclient=cl.getSocket().getInetAddress().getHostName().toLowerCase();
		localclient=InetAddress.getLocalHost().getHostName().toLowerCase();
	} catch(Exception e) {
		return;
	}
	if ((con.getProperty("adminserviceremoteaccess") == null) ||
		( ! ( con.getProperty("adminserviceremoteaccess").equals("ja")) )) {
		if ( ! ((adminclient.equals("127.0.0.1") || (adminclient.equals("localhost")) || (localclient.equals(adminclient))))) {
			answer_htmlerror(cl, HttpURLConnection.HTTP_FORBIDDEN, LS.ls("aswc8"));
			return;				
		}
	}
	
	if (cl.parseData()) {
		Properties props=cl.getProperties();

		user=checkSecurity(cl);
		if (user==null) {
			return;
		}
		
		String request=(String)props.get("scanfirstline");
		if (request==null) {
			log(LS.ls("aswc1"), LOG_ERROR);
			try { cl.getSocket().close(); } catch(Exception e) {};
			return;
		}
	
		int p1=request.indexOf(' ');
		String method=request.substring(0, p1);
		int p2=request.indexOf(' ', p1+1);
		String file=request.substring(p1+1, p2);
		int p3=file.indexOf('?');
		if (p3>0) {
			String parastr=file.substring(p3+1);
			char parachar[]=new char[parastr.length()];
			parastr.getChars(0, parastr.length(), parachar, 0);
			paras=scan_post(parachar);
			file=file.substring(0, p3);
		}

		// ********************************************************************************
		if (method.equals("GET")) {
			if ((file.equals("/")) || (file.equals("/index.html"))) {
				gen_get_index(cl, user);
				return;
			}
			if (file.equals("/admclient.html")) {
				if (user.isAdministrator()) {
					gen_adm_clients(cl, user);
				} else {
					answer_htmlerror(cl, HttpURLConnection.HTTP_FORBIDDEN, LS.ls("aswc9"));
				}
					
				return;
			}
			if (file.equals("/wus.html")) {
				gen_adm_wus(cl, user);
				return;
			}
			if (file.equals("/ergs.html")) {
				gen_adm_ergs(cl, user);
				return;
			}
			if (file.equals("/admparams.html")) {
				if (user.isAdministrator()) {
					gen_adm_paras(cl, user);
				} else {
					answer_htmlerror(cl, HttpURLConnection.HTTP_FORBIDDEN, LS.ls("aswc9"));
				}
				return;
			}
			if (file.equals("/refresh.html")) {
				if (user.isAdministrator()) {
					con.start_connect();
					gen_get_index(cl, user);
				} else {
					answer_htmlerror(cl, HttpURLConnection.HTTP_FORBIDDEN, LS.ls("aswc9"));
				}
				return;
			}
			if (file.equals("/stop.html")) {
				if (user.isAdministrator()) {
					con.log(LS.ls("aswc2")+" " + cl.getSocket().getInetAddress(), LOG_INFO);
					SetiStop stop=new SetiStop(con);
					answer_html(cl, new StringBuffer(LS.ls("aswc3")));
				} else {
					answer_htmlerror(cl, HttpURLConnection.HTTP_FORBIDDEN, LS.ls("aswc9"));
				}
				return;
			}
			if (file.equals("/logs.html")) {
				if (user.isAdministrator()) {
					gen_adm_logs(cl, false, user);
				} else {
					answer_htmlerror(cl, HttpURLConnection.HTTP_FORBIDDEN, LS.ls("aswc9"));
				}
				return;
			}
			if (file.equals("/workclient.html")) {
				if (user.isAdministrator()) {
					String client=paras.getProperty("client");
					if (client!=null) {
						gen_adm_clients(cl, client, user);
					}
				} else {
					answer_htmlerror(cl, HttpURLConnection.HTTP_FORBIDDEN, LS.ls("aswc9"));
				}

				return;
			}

			if (file.equals("/abgleich.html")) {
				if (user.isAdministrator()) {
					gen_adm_offline(cl, user);
				} else {
					answer_htmlerror(cl, HttpURLConnection.HTTP_FORBIDDEN, LS.ls("aswc9"));
				}
				return;
			}

			if (file.equals("/erginfo.html")) {
				gen_adm_erginfo(cl, paras.getProperty("hash"), user);
				return;
			}

			if (file.equals("/wuloeschen.html")) {
				if (user.isAdministrator()) {
					String datei=paras.getProperty("fname");
					if (datei!=null) {
						con.deleteWorkunit(datei);
					}
					gen_adm_wus(cl, user);
				} else {
					answer_htmlerror(cl, HttpURLConnection.HTTP_FORBIDDEN, LS.ls("aswc9"));
				}
				return;
			}

			if (file.equals("/deleteerg.html")) {
				if (user.isAdministrator()) {
					String hash=paras.getProperty("hash");
					deleteErg(hash);
					gen_adm_ergs(cl, user);
				} else {
					answer_htmlerror(cl, HttpURLConnection.HTTP_FORBIDDEN, LS.ls("aswc9"));
				}
				return;
			}

			if (file.equals("/adminusers.html")) {
				if (user.isAdministrator()) {
					gen_adm_users(cl, user, "", false, null);
				} else {
					answer_htmlerror(cl, HttpURLConnection.HTTP_FORBIDDEN, LS.ls("aswc9"));
				}
				return;
			}


			answer_htmlerror(cl, HttpURLConnection.HTTP_NOT_FOUND, LS.ls("aswc4"));
		} else {

		// ********************************************************************************
			if (method.equals("POST")) {
				if (!user.isAdministrator()) {
					answer_htmlerror(cl, HttpURLConnection.HTTP_FORBIDDEN, LS.ls("aswc9"));
					return;
				}
				// Working Post...
				if (file.equals("/postadmin.html")) {
					work_post(cl, user);
					return;
				}
				if (file.equals("/postwebuser.html")) {
					work_post_useradmin(cl, user);
					return;
				}
			answer_htmlerror(cl, HttpURLConnection.HTTP_NOT_FOUND, LS.ls("aswc4"));
			} else {
				answer_htmlerror(cl, HttpURLConnection.HTTP_BAD_METHOD, LS.ls("aswc5")+ " [" + method + "]");
			}
		}
	} else {
		log(LS.ls("aswc6"), LOG_ERROR);
		answer_htmlerror(cl, HttpURLConnection.HTTP_INTERNAL_ERROR, LS.ls("aswc7"));
		try { cl.getSocket().close(); } catch(Exception e) {};
	}
	
}
}
