package SetiWebAdmin;

import java.net.*;
import java.io.*;
import java.util.*;
/**
 * Copyright 1999,2000,2001 Stefan Hoffmann<br>
 *
 * This File is part of SetiProxy.<br>
 *
 *	SetiProxy is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.<br>
 *
 *	SetiProxy is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.<br>
 *
 *	You should have received a copy of the GNU General Public License
 *	along with SetiProxy; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
public class AdminConnection {
	Socket socket;
	Properties values;
	char [] content;
/**
 * AdminConnection constructor comment.
 */
public AdminConnection(Socket socket) {
	super();
	this.socket=socket;
}
/**
 * This method was created in VisualAge.
 * @return char[]
 */
public char [] getContent() {
	return content;
}
/**
 * AdminConnection constructor comment.
 */
public Properties getProperties() {
	return values;
}
/**
 * This method was created in VisualAge.
 * @return java.net.Socket
 */
public Socket getSocket() {
	return socket;
}
/**
 * This method was created in VisualAge.
 */
public boolean parseData() {
	byte puffer[]=new byte[9000];
	ByteArrayOutputStream stream=new ByteArrayOutputStream();
	values=new Properties();

	try {
		InputStream inp=socket.getInputStream();
		BufferedReader reader=new BufferedReader(new InputStreamReader(inp));
		// auf jeden Fall haben wir jetzt einen Zeilenleser ;-)))
		
		boolean scan=true;
		boolean firstline=true;
		while (scan) {
			String line=reader.readLine();
			if (line!=null) {
				if (line.length()==0) {
					scan=false;
				}
				int pos=line.indexOf(':');
				if (pos>0) {
					String l1=line.substring(0, pos).toLowerCase();
					String l2;
					if (!l1.equals("authorization")) {
						l2=line.substring(pos+1).toLowerCase().trim();
					} else {
						l2=line.substring(pos+1).trim();
					}
					values.put(l1, l2);
				} else {
					if (scan) {
						if (firstline) {
							values.put("scanfirstline", line);
						} else {
							values.put(line, "");
						}
					}
				}
			} else {
				scan=false;
			}
			firstline=false;
		}

		Object objtype=values.getProperty("content-type");
		if (objtype!=null) {
			String type=objtype.toString();
			Object objlength=values.getProperty("content-length");
			if (objlength!=null) {
				int len=new Integer(objlength.toString()).intValue();
				content=new char[len];
				reader.read(content, 0, len);
			}
		}
		
	} catch(Exception e) {
		try {
		  socket.close();
		} catch(Exception ee) {};
		return false;
	}
	
	return true;
}
}
