package SetiHome;

import java.io.*;
import java.net.*;
import java.util.*;
/**
 * Copyright 1999,2000,2001 Stefan Hoffmann<br>
 *
 * This File is part of SetiProxy.<br>
 *
 *	SetiProxy is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.<br>
 *
 *	SetiProxy is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.<br>
 *
 *	You should have received a copy of the GNU General Public License
 *	along with SetiProxy; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
public class WorkunitController implements Runnable  {
	protected MainController con;
	protected Vector units;

	protected String user;
	Thread thread;
/**
 * WorkunitController constructor comment.
 */
public WorkunitController(MainController con) {
	super();
	this.con=con;
	loadWorkunits();
}
/**
 * This method was created in VisualAge.
 */
public void addWorkunit(Workunit unit) {
	units.addElement(unit);
	con.add_saveworkunit(1);
	saveWorkunits();
}
/**
 * This method was created in VisualAge.
 */
public static Workunit baueWorkunit(String client, byte [] data) {
	try {
		Workunit work=new Workunit();
		work.setClient(client);
		work.setDaten(data);
		return work;
	} catch(Exception e) {
		return null;
	}
}
/**
 * Insert the method's description here.
 * Creation date: (16.09.2000 06:27:14)
 * @return boolean
 * @param filename java.lang.String
 */
public boolean deleteWorkunit(String filename) {
	// Hier geht es darum, eine Workunit rauszuwerfen....
	Enumeration enum = units.elements();
	boolean found=false;
	while (enum.hasMoreElements()) {
		Workunit unit=(Workunit)enum.nextElement();
		if (unit.getFilename().equals(filename)) {
			// Gut, wir haben unsere Workunit gefunden und lschen diese...
			try {
				unit.delete_unit();
			} catch(java.io.IOException exc) {
				con.log(LS.ls("wcgw1") + exc, con.LOG_ERROR);
			}
			units.remove(unit);
			con.add_saveworkunit(-1);
			return true;
		}
	}
	return false;
}
/**
 * This method was created in VisualAge.
 */
public Enumeration enumWorkunits() {
	// Natrlich geben wir hier nicht die Original-Units aus der Hand...
	// Und den Datenbereich behalten wir auch...
	
	Vector vector=new Vector();
	Enumeration orig=units.elements();
	while(orig.hasMoreElements()) {
		Workunit unit=(Workunit)orig.nextElement();
		Workunit wu=new Workunit();
		wu.setDatum(unit.getDatum());
		wu.setClient(unit.getClient());
		wu.setFilename(unit.getFilename());
		vector.addElement(wu);
	}

	return vector.elements();
}
	
/**
 * This method was created in VisualAge.
 * @return int
 */
public int getAnzWorkunits() {
	return units.size();
}
/**
 * This method was created in VisualAge.
 */
public Workunit getWorkunit(boolean complete) {
	if (units.size() > 0) {
		// Die Unit mit dem ltesten Datum finden...
		Enumeration enum = units.elements();
		Date olddate=null;
		Workunit unit=null;
		while (enum.hasMoreElements()) {
			Workunit test = (Workunit) enum.nextElement();
			if (unit==null) {
				unit=test;
				olddate=unit.getDatum();
			}
			if (test.getDatum().before(olddate)) {
				unit = test;
				olddate = unit.getDatum();
			}
		}
		if (complete) {
			unit.load();
			try {
				unit.delete_unit();
			} catch(java.io.IOException exc) {
				con.log(LS.ls("wcgw1") + exc, con.LOG_ERROR);
			}
		}
		units.removeElement(unit);
		con.add_saveworkunit(-1);
		saveWorkunits();
		return unit;
	} else {
		return null;
	}
}
	
/**
 * This method was created in VisualAge.
 */
private Workunit loadWorkunit(String user) {
	// So, eine fette, monolithische Routine..... ;-)))
	try {
		// ************************************************************************************
		// Hier bauen wir jetzt den Request auf eine Workunit zusammen..
		ByteArrayOutputStream data=new ByteArrayOutputStream();
		// so, wir nehmen ab jetzt nur noch den Server aus den preferenzen..
		String setiserver=con.getProperty("setiserver").trim();
		data.write(new String("POST http://"+setiserver+"/ HTTP/1.0\r\n").getBytes());
		
		// Authentifizierung und Proxy einstellen...
		int proxyport=con.getProxyport();
		if (proxyport>0) {
			data.write(("Host: " + setiserver+ "\r\n").getBytes());
			String auth=con.getProxyAuthent();
			if (auth!=null) {
				sun.misc.BASE64Encoder dec = new sun.misc.BASE64Encoder();
				auth=new String(dec.encode(auth.toString().getBytes()));
				data.write(("Proxy-authorization: Basic "+auth+"\r\n").getBytes());
			}
		}

		// Jetzt den Request zusammenstellen...
		ByteArrayOutputStream content=new ByteArrayOutputStream();
		content.write(("").getBytes());

		// SO, DAS SOLLTE ES AUCH SCHON SEIN !!
		content.write((byte[])con.getClient(user).getLookupProperties().get("setiproxykey-get_work_unit"));

		data.write(("Content-Type: text/plain\r\n").getBytes());
		data.write(("Content-Length: "+content.size()).getBytes());
		data.write(("\r\n\r\n").getBytes());
		data.write(content.toByteArray());

		// ************************************************************************************
		// Und jetzt schicken wir den Request einfach los....
		con.open_connection();
		Socket inetsock=null;
		InetAddress adr=null;
		if (proxyport!=0) {
			adr=InetAddress.getByName((con.getProxyAdress()));
			if (adr==null) {
				throw new Exception(LS.ls("scsr2"));
			}
		} else {
			proxyport=80;
			adr = InetAddress.getByName(setiserver);
			if (adr == null) {
				throw new Exception(LS.ls("scsr3"));
			}
		}
		inetsock=new Socket(adr, proxyport);
		OutputStream out=inetsock.getOutputStream();
		out.write(data.toByteArray());
		ClientConnection antw=new ClientConnection(inetsock, con.getClient(user), con, false);
		ClientConnectionData antwdata=antw.getData();
		inetsock.close();

		// Und jetzt das Ergebnis berprfen....
		con.close_connection();
		if ((antwdata!=null) && ((antwdata.getHttpCode()==0) || (antwdata.getHttpCode()==200))) {
			con.setzeLastZugriff(con.SETISUCCESS, null);
			// Alles klar, wir haben jetzt eine Workunit !!!
			Workunit work=baueWorkunit(user, antwdata.getRohDaten());
			return work;
		} else {
			// Ok, verbindungsfehler... also mit null weg, damit nicht weitergelesen wird..
			return null;
		}
	} catch(Exception e) {
		con.log(LS.ls("wclw1") + e, con.LOG_WARNING);
		con.close_connection();
	}
	return null;
	
}
/**
 * This method was created in VisualAge.
 */
public void loadWorkunits() {
	try {
		FileInputStream fin=new FileInputStream("workunits.vector");
		ObjectInputStream data=new ObjectInputStream(fin);
		units=(java.util.Vector)data.readObject();
		data.close();
		fin.close();
		con.add_saveworkunit(units.size());
	} catch(Exception e) {
		con.log(LS.ls("wclfw1") + e, con.LOG_ERROR);
		units=new Vector();
		saveWorkunits();
	}

}
/**
 * This method was created in VisualAge.
 */
public void refreshWorkunits(String user) {

  if ((thread!=null) && (thread.isAlive())) {
		//con.log("Workunitloader ist noch aktiv. Prozess nicht neu gestartet.", con.LOG_WARNING);
  } else {
		this.user=user;
		thread=new Thread(this, "WorkUnitLoader");
		thread.start();
	}
}
/**
 * This method was created in VisualAge.
 */
public void run() {
	boolean error=false;
	int anz=0;
	try {
		anz=new Integer(con.getProperty("lagerunits")).intValue();
	} catch(Exception e) {
		return;
	}
	
	if (units.size()<anz)	{
		con.log(LS.ls("wcrn1"), con.LOG_DEBUG);
	}

	while ((units.size()<anz) && (!error)) {
		Workunit unit=loadWorkunit(user);
		if (unit==null) {
			error=true;
			con.log(LS.ls("wcrn2"), con.LOG_WARNING);
		} else {
			addWorkunit(unit);
		}
		try {
			anz=new Integer(con.getProperty("lagerunits")).intValue();
		} catch(Exception e) {
			return;
		}
	}
}
/**
 * This method was created in VisualAge.
 */
public void saveWorkunits() {
	try {
		FileOutputStream fout=new FileOutputStream("workunits.vector");
		ObjectOutputStream data=new ObjectOutputStream(fout);
		data.writeObject(units);
		data.close();
		fout.close();
	} catch(Exception e) {
		con.log(LS.ls("wcsw1") + e, con.LOG_ERROR);
	}

	
	
}
}
