package SetiHome;

import java.util.*;
import java.io.*;
/**
 * Copyright 1999,2000,2001 Stefan Hoffmann<br>
 *
 * This File is part of SetiProxy.<br>
 *
 *	SetiProxy is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.<br>
 *
 *	SetiProxy is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.<br>
 *
 *	You should have received a copy of the GNU General Public License
 *	along with SetiProxy; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
public class Workunit implements java.io.Serializable {
	public String client;
	protected byte[] daten;
	protected java.util.Date datum;
	private String fname;
	byte localdata[];
	Properties props;
/**
 * Workunit constructor comment.
 */
public Workunit() {
	super();
	datum=new Date();
	props=new Properties();
	localdata=null;
}
/**
 * This method was created in VisualAge.
 * @return byte[]
 */
public void delete_unit() throws java.io.IOException {
	load();
	File f = new File(fname);
	f.delete();
}
/**
 * This method was created in VisualAge.
 * @return SetiHome.Client
 */
public String getClient() {
	return client;
}
/**
 * This method was created in VisualAge.
 * @return byte[]
 */
public byte[] getDaten() {
	byte daten[]=null;

	try {
		File f=new File(fname);
		int size=(int)f.length();

		daten=new byte[size];
		
		FileInputStream finp=new FileInputStream(fname);
		finp.read(daten);
		finp.close();
		
	} catch(Exception e) {
		if (localdata!=null) {
			return localdata;
		}
	}

	return daten;
}
/**
 */
public Date getDatum() {
	return datum;
}
/**
 */
public String getFilename() {
	return fname;
}
/**
 * This method was created in VisualAge.
 * @return java.util.Properties
 */
public Properties getProps() {
	return props;
}
/**
 * This method was created in VisualAge.
 * @return byte[]
 */
public void load() {
	if (localdata==null) {
		localdata=getDaten();
	}
}
/**
 * This method was created in VisualAge.
 * @param newValue SetiHome.Client
 */
public void setClient(String newValue) {
	this.client = newValue;
}
/**
 * This method was created in VisualAge.
 * @param newValue byte[]
 */
public void setDaten(byte[] newValue) {
	Random rand=new Random(new Date().getTime());

	boolean found=true;
	while (found) {
	  found=false;
	  fname="s";
	  for(int i=0;i<7;i++) {
	    fname=""+fname+Math.abs((rand.nextInt()%10));
		}
	  fname=fname+".wu";
	  try {
		  File f=new File(fname);
		  if (f.exists()) {
			  found=true;
		  }
	  } catch(Exception e) {
	  }
	}

	try {
		FileOutputStream fout=new FileOutputStream(fname);
		fout.write(newValue);
		fout.close();
	} catch(Exception e) {};
}
/**
 */
public void setDatum(Date value) {
	datum=value;
}
/**
 */
public void setFilename(String value) {
	this.fname=value;
}
/**
 * This method was created in VisualAge.
 * @param newValue java.util.Properties
 */
public void setProps(Properties newValue) {
	this.props = newValue;
}
}
