package SetiHome;

import java.util.*;
import java.io.*;
import java.net.*;
/**
 * Copyright 1999,2000,2001 Stefan Hoffmann<br>
 *
 * This File is part of SetiProxy.<br>
 *
 *	SetiProxy is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.<br>
 *
 *	SetiProxy is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.<br>
 *
 *	You should have received a copy of the GNU General Public License
 *	along with SetiProxy; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
public class DataHandler {
	Properties props;
	Vector clients;
	Vector workUnits;
	Logger log;

  Vector waiting;

  boolean sort;
/**
 * DataHandler constructor comment.
 */
public DataHandler(Logger log) {
	super();
	this.log=log;
	initialize();
}
/**
 * This method was created in VisualAge.
 */
public synchronized void addClient(Client clien) {
	clients.addElement(clien);
	sortClients();
}
/**
 * This method was created in VisualAge.
 */
public synchronized void addWaitingRequest(ClientConnectionData waitcon) {
	waiting.addElement(waitcon);
	saveRequests();
}
/**
 * This method was created in VisualAge.
 */
public synchronized int anzWaitingRequests() {
	return waiting.size();
}
/**
 * This method was created in VisualAge.
 */
public synchronized boolean deleteClient(String ip) {
	Enumeration enum=clients.elements();
	while (enum.hasMoreElements()) {
		Object obj=enum.nextElement();
		if (obj!=null) {
			if (((Client)obj).getClientName().equals(ip)) {
				return clients.removeElement(obj);
			}
		}
	}
	return false;

}
/**
 * This method was created in VisualAge.
 */
public synchronized boolean deleteClient(Client cl) {
	return clients.removeElement(cl);
}
/**
 * This method was created in VisualAge.
 */
public synchronized void deleteWaitingRequest(ClientConnectionData waitcon) {
	waiting.removeElement(waitcon);
	saveRequests();
}
/**
 * This method was created in VisualAge.
 */
public synchronized Client getClient(String ip) {
	Enumeration enum=clients.elements();
	while (enum.hasMoreElements()) {
		Object obj=enum.nextElement();
		if (obj!=null) {
			if (((Client)obj).getClientName().equals(ip)) {
				return (Client)obj;
			}
		}
	}
	return null;

}
/**
 * This method was created in VisualAge.
 */
public synchronized Enumeration getClients(int status) {
	Vector vec=new Vector();
	Enumeration enum=clients.elements();
	while (enum.hasMoreElements()) {
		Object obj=enum.nextElement();
		if (obj!=null) {
			if ((((Client)obj).getStatus()&status) != 0) {
				vec.addElement(obj);
			}
		}
	}
	return vec.elements();
}
/**
 * This method was created in VisualAge.
 * @param str java.lang.String
 */
public synchronized String getProperty(String prop) {
	return (String)props.getProperty(prop);
}
/**
 * This method was created in VisualAge.
 * @param str java.lang.String
 */
public synchronized String getProxyPasswort() {
	sun.misc.BASE64Decoder dec = new sun.misc.BASE64Decoder();
	String txt=props.getProperty("proxypasswort");
	if (txt!=null) {
		try {
			return new String(dec.decodeBuffer((txt)));
		} catch(Exception e) {
			return "";
		}
	} else {
		return "";
	}
}
/**
 * This method was created in VisualAge.
 */
public synchronized Enumeration getWaitingRequests() {
	return waiting.elements();
}
/**
 */
public synchronized void initialize() {
	sort=false;
	props=new Properties();
	clients=new Vector();
	waiting=new Vector();
	loadProperties();
	
	loadRequests();
	
}
/**
 */
private synchronized void loadProperties() {
	try {
		FileInputStream fprops=new FileInputStream("setiproxy.properties");
		props.load(fprops);
	} catch(Exception e) {
		//log.log("Ladefehler properties: " + e, log.LOG_ERROR);
		log.log(LS.ls("dhlp1") + e, log.LOG_ERROR);
		props.put("proxy", "nein");
		props.put("proxyadresse", "");
		props.put("proxyport", "");
		props.put("proxyauth", "nein");
		props.put("proxyuser", "");
		setProxyPasswort("");

		props.put("reconnect", "-1");
		props.put("lagerunits", "0");
		props.put("loglevel", "2");

	  props.put("port", "8081");

	  props.put("adminservice", "ja");
	  props.put("adminport", "8083");
	  props.put("worklinear", "ja");
	  props.put("connectonlymanual", "nein");
	  props.put("autoclientinsert", "nein");
	  props.put("language", "deutsch.lng");
	  props.put("setiserver", "shserver2.ssl.berkeley.edu");

		saveProperties();
	}
	// Hier prfen wir, ob bestimmte Properties auch wirklich vorhanden sind..
	if (props.get("setiserver")==null) {
		// Hier ist auch gleich der neue Server drin, nmlich der, welcher
		// ab den 3.03 Clients zu verfgung steht.
		props.put("setiserver", "shserver2.ssl.berkeley.edu");
	} else {
		if (props.get("setiserver").equals("")) {
			props.put("setiserver", "shserver2.ssl.berkeley.edu");
		}
	}

	try {
		FileInputStream fcl=new FileInputStream("seticlients.vector");
		ObjectInputStream ocl=new ObjectInputStream(fcl);
		clients=(Vector)ocl.readObject();
		ocl.close();
		fcl.close();
		String check=getProperty("startupcheckclients");
		if ((check!=null) && (check.equalsIgnoreCase("ja"))) {
			Enumeration cls=clients.elements();
			//log.log("Pruefe Clients.....", log.LOG_INFO);
			log.log(LS.ls("dhlp2"), log.LOG_INFO);
			while (cls.hasMoreElements()) {
				Client cl=null;
				try {
					cl=null;
					cl=(Client)cls.nextElement();
					if (getProperty("nonameresolution")==null) {
						cl.setClientName(InetAddress.getByName(cl.getClientName()).getHostName().toLowerCase());
					} else {
						cl.setClientName(InetAddress.getByName(cl.getClientName()).getHostAddress());
					}
				} catch(Exception e) {
					if (cl!=null) {
						//log.log("ClientLoader: Client " + cl.getClientName() + " konnte nicht aufgelst werden: "+e, log.LOG_ERROR);
						log.log(LS.ls("dhlp3a") + cl.getClientName() + " " + LS.ls("dhlp3b") + e, log.LOG_ERROR);
					} else {
						//log.log("ClientLoader: allgemeiner Fehler Namenskonvertierung: " + e, log.LOG_ERROR);
						log.log(LS.ls("dhlp4") + e, log.LOG_ERROR);
					}
				}
			}
			//log.log("Pruefe Clients..... beendet.", log.LOG_INFO);
			log.log(LS.ls("dhlp5"), log.LOG_INFO);
		}
		sortClients();
		saveClients();
	} catch(Exception e) {
		//log.log("Fehler load Clients: " + e, log.LOG_ERROR);
		log.log(LS.ls("dhlp6") + e, log.LOG_ERROR);
	}
}
/**
 */
private synchronized void loadRequests() {
	try {
		FileInputStream fin=new FileInputStream("requests.data");
		ObjectInputStream data=new ObjectInputStream(fin);
		waiting=(java.util.Vector)data.readObject();
		data.close();
		fin.close();
	} catch(Exception e) {
		//log.log("Fehler beim Laden der Requests: " + e, log.LOG_ERROR);
		log.log(LS.ls("dhlr1") + e, log.LOG_ERROR);
		saveRequests();
	}

	Enumeration enum=waiting.elements();
	while(enum.hasMoreElements()) {
		ClientConnectionData data=(ClientConnectionData)enum.nextElement();
		String ops=data.getFelder().getProperty("setiproxykey-operation");
		boolean opsok=false;
		if ((ops!=null) && ((ops.equals("send_result")) || (ops.equals("send_result_get_user_stats")))) {
			String reqcl=data.getClient().getClientName();
			Enumeration cls=clients.elements();
			boolean found=false;
			while (cls.hasMoreElements()) {
				Client cl=(Client)cls.nextElement();
				if (reqcl.equals(cl.getClientName())) {
					data.setClient(cl);
					found=true;
					break;
				}
			}
			if (!found) {
				//log.log("Der Client "+reqcl+" ist unbekannt. Die Statistik knnte Fehler aufweisen.", log.LOG_WARNING);
				log.log(LS.ls("dhlr2a") + " " + reqcl + " " + LS.ls("dhlr2b"), log.LOG_WARNING);
			}
		} else {
			waiting.removeElement(data);
			log.log(LS.ls("dhlr3"), log.LOG_ERROR);
		}
	}
}
/**
 */
public synchronized void saveClients() {
	try {
		FileOutputStream fcl=new FileOutputStream("seticlients.vector");
		ObjectOutputStream ocl=new ObjectOutputStream(fcl);
		ocl.writeObject(clients);
		ocl.close();
		fcl.close();
	} catch(Exception e) {
		//log.log("Clients-Save-Fehler: " + e, log.LOG_ERROR);
		log.log(LS.ls("dhsc1") + e, log.LOG_ERROR);
	}

}
/**
 */
public synchronized void saveProperties() {
	try {
		FileOutputStream fprops=new FileOutputStream("setiproxy.properties");
		props.store(fprops, MainController.version + " - allgemeine Konfigurationsdatei");
		fprops.close();
	} catch(Exception e) {
		//log.log("Properties-Save-Fehler: " + e, log.LOG_ERROR);
		log.log(LS.ls("dhsp1") + e, log.LOG_ERROR);
	}
}
/**
 */
private synchronized void saveRequests() {
	Vector savedata=new Vector();
	Enumeration enum=waiting.elements();
	while (enum.hasMoreElements()) {
		ClientConnectionData con=(ClientConnectionData)enum.nextElement();
		ClientConnectionData newcon=new ClientConnectionData();
		newcon.setAktiv(false);
		newcon.setSocket(null);
		newcon.setInwork(false);
		newcon.setClient(con.getClient());
		newcon.setFelder(con.getFelder());
		newcon.setRohDaten(con.getRohDaten());
		newcon.setDatum(con.getDatum());
		savedata.addElement(newcon);
	}
		
	try {
		FileOutputStream fout=new FileOutputStream("requests.data");
		ObjectOutputStream data=new ObjectOutputStream(fout);
		data.writeObject(savedata);
		data.close();
		fout.close();
	} catch(Exception e) {
		//log.log("Fehler beim Speichern der Requests: " + e, log.LOG_ERROR);
		log.log(LS.ls("dhsr1") + e, log.LOG_ERROR);
	}
}
/**
 * This method was created in VisualAge.
 * @param str java.lang.String
 */
public synchronized void setProperty(String prop, String wert) {
	props.put(prop, wert);
}
/**
 * This method was created in VisualAge.
 * @param str java.lang.String
 */
public synchronized void setProxyPasswort(String str) {
	sun.misc.BASE64Encoder dec = new sun.misc.BASE64Encoder();
	String idbase64 = new String(dec.encode(str.getBytes()));
	props.put("proxypasswort", idbase64);
}
/**
 * This method was created in VisualAge.
 */
private synchronized void sortClients() {
	try {
		boolean fertig=false;
		Vector ziel=new Vector();
	
		// So viele werden es wohl nicht werden... Also, den simpelsten den wir haben...
		// Ich hab jetzt wirklich keinen Bock hier einen QuickSort hinzulegen....
		// Wie nennt der sich noch ? egal....
		Client kleinster;
		while (!fertig) {
			Enumeration enum=clients.elements();
			if (enum.hasMoreElements()) {
				kleinster=(Client)enum.nextElement();
				while (enum.hasMoreElements()) {
					Client tausch=(Client)enum.nextElement();
					if (tausch.getClientName().compareTo(kleinster.getClientName())<0) {
						kleinster=tausch;
					}
				}
				ziel.addElement(kleinster);
				clients.removeElement(kleinster);
			} else {
				fertig=true;
			}
		}
		clients=ziel;
	} catch(Exception e) {
		//log.log("Fehler sortClients: " + e, log.LOG_ERROR);
		log.log(LS.ls("dhsrtc1") + e, log.LOG_ERROR);
	}
}
/**
 * Die Beschreibung der Methode hier eingeben.
 * Erstellungsdatum: (25.11.99 09:58:28)
 */
public synchronized void stop() {
	saveClients();
	saveProperties();
	saveRequests();
}
}
