package SetiHome;

import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.util.*;
/**
 * Copyright 1999,2000,2001 Stefan Hoffmann<br>
 *
 * This File is part of SetiProxy.<br>
 *
 *	SetiProxy is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.<br>
 *
 *	SetiProxy is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.<br>
 *
 *	You should have received a copy of the GNU General Public License
 *	along with SetiProxy; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
public class ClientTreeHandler implements TreeSelectionListener {
		// Das eigentliche Tree-Objekt
	JTree tree;

	// Das Speichermodell, welches die Daten des Baumes hlt..
	DefaultTreeModel treedata;

	// Das Root-Objekt, welches die erste Verzweigung darstellt...
	DefaultMutableTreeNode rootnode;

	MainController data;

	Object elem="";

/**
 * ClientTreeHandler constructor comment.
 */
public ClientTreeHandler(MainController handler, JTree tree) {
	super();

	this.data=handler;
	this.tree=tree;

  tree.addTreeSelectionListener(this);

	initClientlist();
}
/**
 * This method was created in VisualAge.
 */
public void addClient(Client clien) {

  DefaultMutableTreeNode nodeclient=new DefaultMutableTreeNode(clien);
  nodeclient.add(new DefaultMutableTreeNode());
  nodeclient.add(new DefaultMutableTreeNode());
  nodeclient.add(new DefaultMutableTreeNode());
  ClientTreeClient mynodeobj=new ClientTreeClient(clien);
  nodeclient.setUserObject(mynodeobj);
  setClientData(nodeclient, mynodeobj);

  rootnode.add(nodeclient);
  int pos[]=new int[1];
  pos[0]=rootnode.getChildCount()-1;
  treedata.nodesWereInserted(rootnode, pos);
	
}
/**
 * This method was created in VisualAge.
 */
public Client getSelected() {
	if (elem.getClass().getName().equals("SetiHome.ClientTreeClient")) {
		return ((ClientTreeClient)elem).getClient();
	} else {
		return null;
	}
}
/**
 * This method was created in VisualAge.
 */
public void initClientlist() {

	DefaultMutableTreeNode node1, node2;
	
  // Das erste Objekt.... die Wurzel des Baumes
  rootnode=new DefaultMutableTreeNode("Seti-Clients");

  // Jetzt das Allgemeine Datenmodell welches die Daten hlt..
  treedata=new DefaultTreeModel(rootnode);

  Enumeration enum=data.getClients(Client.ALLE);

  int i=0;
  
  while (enum.hasMoreElements()) {
	  Client cl=(Client)enum.nextElement();
	  if (cl!=null) {
		  cl.resetDraw();
		  addClient(cl);
		  /*
		  ClientTreeClient cltree=new ClientTreeClient(cl);
		  node1=new DefaultMutableTreeNode();
		  node2=new DefaultMutableTreeNode();
		  //node2.setUserObject("Lookupdaten vollstndig: Nein");
		  //node2.setUserObject(LS.ls("cthilist1") + (cl.getLookupKomplett()?LS.ls("cthscd1"):LS.ls("cthscd2")));
		  treedata.insertNodeInto(node2, node1, 0);
		  node2=new DefaultMutableTreeNode();
		  //node2.setUserObject("Abgearbeitet Units: xxxxx   ");
		  //node2.setUserObject(LS.ls("cthilist2") + cl.getUnitsBisher());
		  treedata.insertNodeInto(node2, node1, 1);
		  node2=new DefaultMutableTreeNode();
  		//node2.setUserObject("Letzter Zugriff: 8888.88.88 88:88:88  ");
  		//node2.setUserObject(LS.ls("cthilist3") + cl.getLastZugriff());
		  treedata.insertNodeInto(node2, node1, 2);
		  treedata.insertNodeInto(node1, rootnode, i);
		  setClientData(node1, cltree);
		  node1.setUserObject(cltree);
		  i++;*/
	  }
  }

  tree.setModel(treedata);
	
}
/**
 * This method was created in VisualAge.
 */
public void refreshTree() {

	Enumeration enum=data.getClients(Client.DRAW);
	while(enum.hasMoreElements()) {
		Client client=(Client)enum.nextElement();
		updateClient(client);
		client.resetDraw();
	}
}
/**
 * This method was created in VisualAge.
 */
public void setClientData(DefaultMutableTreeNode node, ClientTreeClient clien) {
  ((DefaultMutableTreeNode)node.getChildAt(0)).setUserObject(LS.ls("cthilist1") + ((MainController.clientdata_complete(clien.getClient())!=null)?LS.ls("cthscd1"):LS.ls("cthscd2")));
  ((DefaultMutableTreeNode)node.getChildAt(1)).setUserObject(LS.ls("cthilist2") + clien.getClient().getUnitsBisher());
  ((DefaultMutableTreeNode)node.getChildAt(2)).setUserObject(LS.ls("cthilist3") + clien.getClient().getLastZugriff());
  treedata.nodeChanged(node);
}
/**
 * This method was created in VisualAge.
 */
public void updateClient(Client clien) {
  int i;
  for(i=0;i<rootnode.getChildCount();i++) {
	  DefaultMutableTreeNode nodeclient=(DefaultMutableTreeNode)rootnode.getChildAt(i);
	  ClientTreeClient cltree;
	  if ((cltree=(ClientTreeClient)(nodeclient.getUserObject())).getClient()==clien) {
		  setClientData(nodeclient, cltree);
		  break;
	  }
  }
}
public void valueChanged(TreeSelectionEvent e) 
{
	elem=((DefaultMutableTreeNode)e.getPath().getLastPathComponent()).getUserObject();
}
}
