package SetiHome;

import java.io.*;
import java.net.*;
import java.util.*;
/**
 * Copyright 1999,2000,2001 Stefan Hoffmann<br>
 *
 * This File is part of SetiProxy.<br>
 *
 *	SetiProxy is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.<br>
 *
 *	SetiProxy is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.<br>
 *
 *	You should have received a copy of the GNU General Public License
 *	along with SetiProxy; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
public class ClientConnectionData implements Serializable {
	protected Socket socket;
	protected Properties felder;
	protected boolean aktiv;
	protected Client client;
	protected byte[] rohDaten;
	protected boolean inwork;
	protected Date datum;
/**
 * ClientConnectionData constructor comment.
 */
public ClientConnectionData() {
	super();
	aktiv=true;
	inwork=false;
	datum=new Date();
}
/**
 * This method was created in VisualAge.
 * @return boolean
 */
public boolean getAktiv() {
	return aktiv;
}
/**
 * This method was created in VisualAge.
 * @return SetiHome.Client
 */
public Client getClient() {
	return client;
}
/**
 * This method was created in VisualAge.
 * @return java.util.Date
 */
public Date getDatum() {
	return datum;
}
/**
 * This method was created in VisualAge.
 * @return java.util.Properties
 */
public Properties getFelder() {
	return felder;
}
/**
 */
public int getHttpCode() {
	Object line=null;
	if ((felder!=null) && ((line=felder.get("setiproxykey-firstline"))!=null)) {
		String fl=line.toString();
		if (fl.substring(0,4).equals("HTTP")) {
			int p1=fl.indexOf(' ');
			if (p1>=0) {
				int p2=fl.indexOf(' ', p1+1);
				if (p2>=0) {
					String code=fl.substring(p1+1, p2);
					try {
						int c=new Integer(code).intValue();
						return c;
					} catch(Exception e) {
					}
				}
			}
		}
	} else {
		return 8;
	}

	return 0;
	
}
/**
 * This method was created in VisualAge.
 * @return boolean
 */
public boolean getInwork() {
	return inwork;
}
/**
 * This method was created in VisualAge.
 * @return byte[]
 */
public byte[] getRohDaten() {
	return rohDaten;
}
/**
 * This method was created in VisualAge.
 * @return java.net.Socket
 */
public Socket getSocket() {
	return socket;
}
/**
 * This method was created in VisualAge.
 * @param newValue boolean
 */
public void setAktiv(boolean newValue) {
	this.aktiv = newValue;
}
/**
 * This method was created in VisualAge.
 * @param newValue SetiHome.Client
 */
public void setClient(Client newValue) {
	this.client = newValue;
}
/**
 * This method was created in VisualAge.
 * @param newValue java.util.Date
 */
public void setDatum(Date newValue) {
	this.datum = newValue;
}
/**
 * This method was created in VisualAge.
 * @param newValue java.util.Properties
 */
public void setFelder(Properties newValue) {
	this.felder = newValue;
}
/**
 * This method was created in VisualAge.
 * @param newValue boolean
 */
public void setInwork(boolean newValue) {
	this.inwork = newValue;
}
/**
 * This method was created in VisualAge.
 * @param newValue byte[]
 */
public void setRohDaten(byte[] newValue) {
	this.rohDaten = newValue;
}
/**
 * This method was created in VisualAge.
 * @param newValue java.net.Socket
 */
public void setSocket(Socket newValue) {
	this.socket = newValue;
}
}
