package SetiHome;

import java.util.*;
import java.net.*;
import java.io.*;
/**
 * Copyright 1999,2000,2001 Stefan Hoffmann<br>
 *
 * This File is part of SetiProxy.<br>
 *
 *	SetiProxy is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.<br>
 *
 *	SetiProxy is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.<br>
 *
 *	You should have received a copy of the GNU General Public License
 *	along with SetiProxy; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
public class ClientConnection implements Runnable {
	Socket sock;
	Client client;
	MainController con;
	Thread thread;

	Properties infos;

	boolean add_contents;
	int contents_length;
	int contents_start;
/**
 * ClientConnection constructor comment.
 */
public ClientConnection(Socket sock, Client client, MainController con, boolean run) {
	super();
	this.sock=sock;
	this.con=con;
	this.client=client;

	if (run) {
		client.setLastZugriff();
	}
	con.treeUpdate();

	add_contents=false;

	if (run) {
		thread=new Thread(this, "ClientTCPIP");
		thread.start();
	}
	
}
/**
 */
public boolean get_line(byte bb[], int pos, int pos2, Properties data) {
	String key="";
	String line="";

	// Erste Zeile, ist normalerweise kein Variablenpaar...
	if (pos==0) {
		key="setiproxykey-firstline";
		line=new String(bb, 0, pos2);
	} else {
		key=new String(bb, 0, pos2);
		for(int i=pos;i<pos2;i++) {
			// Trennungszeichen...
			if (bb[i]==':') {
				key=new String(bb, pos, i-pos);
				line=new String(bb, i+2, pos2-i-2);
				break;
			}
		}
	}

	data.put(key, line);
	
	return false;
}
	
/**
 */
public ClientConnectionData getData() {
	byte puffer[]=new byte[8192];
	boolean eof=false;

	ByteArrayOutputStream data;
	data=new ByteArrayOutputStream();
	infos=new Properties();

	// So, hier kommt jetzt ein Request vom Seti-Client. Auswerten und dann mal sehen...
	try {
		InputStream inp=sock.getInputStream();

		int len=inp.read(puffer);
		if (len>0) {
			data.write(puffer, 0, len);
		}
		if (len==-1) {
			eof=true;
		}

		boolean fertig=parse_stream(data, false);
		while ((!fertig) && (!eof)) {
			len=inp.read(puffer);
			if (len>0) {
				data.write(puffer, 0, len);
				fertig=parse_stream(data, false);
			} else {
				if (len==-1) {
					eof=true;
				}
				Thread.sleep(10);
			}
		}
		if ((eof) && (!fertig)) {
			parse_stream(data, true);
		}

		data.close();
		ClientConnectionData condata=new ClientConnectionData();
		
		condata.setSocket(sock);
		condata.setFelder(infos);
		condata.setClient(client);
		condata.setRohDaten(data.toByteArray());
		return condata;
	} catch(Exception e) {
		//con.log("Fehler ClientConnection: " + e, con.LOG_ERROR);
		con.log(LS.ls("ccgd1"), con.LOG_ERROR);
		return null;
	}

}
/**
 */
public boolean parse_stream(ByteArrayOutputStream data, boolean eof) {

	// Ok, der erste Block so lange, bis 2x 0d0a.... also zwei Enter...
	int i=0;
	int pos=0;
	int lastpos;
	try {

		if (!add_contents) {
			byte bb[]=data.toByteArray();
			boolean found=false;
			while ((i<bb.length-4) && (!found)) {
				if ((bb[i]==0xd) && (bb[i+1]==0xa) && (bb[i+2]==0xd) && (bb[i+3]==0xa)) {
					found=true;
					pos=i;
				}
				i++;
			}

			
			if (found) {
				String key;
				String line;
				infos=new Properties();
				
				lastpos=0;
				// So, ende gefunden... Jetzt machen wir ein Properties-Feld daraus...
				for(i=0;i<pos;i++) {
					if ((bb[i]==0xd) && (bb[i+1]==0xa)) {
						get_line(bb, lastpos, i, infos);
						lastpos=i+2;
					}
				}
				get_line(bb, lastpos, pos, infos);
				
				String contents=infos.getProperty("Content-type");
				if (contents==null) {
					contents=infos.getProperty("Content-Type");
				};
				if (contents==null) {
					contents=infos.getProperty("content-type");
				}
				if (contents!=null) {
					contents_start=pos+4;
					String obj=infos.getProperty("Content-length");
					if (obj==null) {
						obj=infos.getProperty("Content-Length");
					}
					if (obj==null) {
						obj=infos.getProperty("content-length");
					}
					if (obj!=null) {
						contents_length=new Integer(obj).intValue();
					} else {
						contents_length=1000000;
					}
					add_contents=true;
				} else {
					return true;
				}
			}
		}
		if (add_contents) {
			if ((data.size()-contents_start>=contents_length) || (eof)) {
				if (eof) {
					contents_length=data.size()-contents_start;
				}
				byte bb[]=data.toByteArray();
				byte newdata[]=new byte[contents_length];
				for(i=0;i<contents_length;i++) {
					newdata[i]=bb[i+contents_start];
				}

				String ops=new String(newdata, 0, 10);
				if (ops.equalsIgnoreCase("operation=")) {
					int p1;
					for(p1=10;(p1<newdata.length) && (newdata[p1]!=0xa);p1++) {
						// wohl nix drin
					};
					if (newdata[p1]==0xa) {
						String wert=new String(newdata, 10, p1-10);
						infos.put("setiproxykey-operation", wert);
					}
				}

				infos.put("setiproxykey-contentsdata", newdata);
				return true;
			}
		}

	} catch(Exception e) {
		//con.log("Fehler Parse-stream: " + e, con.LOG_ERROR);
		con.log(LS.ls("ccps1") + e, con.LOG_ERROR);
	}
	return false;
}
	
/**
 */
public void run() {

	ClientConnectionData data=getData();

	con.addRequest(data);

}
}
