package TProxy;

import java.net.*;
import java.io.*;
import java.util.*;
/**
 * Copyright 1999,2000,2001 Stefan Hoffmann<br>
 *
 * This File is part of SetiProxy.<br>
 *
 *	SetiProxy is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.<br>
 *
 *	SetiProxy is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.<br>
 *
 *	You should have received a copy of the GNU General Public License
 *	along with SetiProxy; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
public class Verbindung implements Runnable {
	String proxy;
	int proxyport;
	int flags;
	Socket socket;
	Socket servsock;
	Controller controller;
	Thread thread;
	boolean onread;
	int id;
	String authstring;
/**
 * Verbindunng constructor comment.
 */
public Verbindung() {
	super();
}
/**
 * Verbindunng constructor comment.
 */
public Verbindung(Controller con, java.net.Socket sock, String proxy, int proxyport, int flags, int id, String authstring) {
	super();
	servsock=null;
	this.proxy=proxy;
	this.proxyport=proxyport;
	this.flags=flags;
	this.socket=sock;
	this.controller=con;
	this.authstring=authstring;
	this.id=id;
	thread=new Thread(this);
	thread.start();
}
/**
 * This method was created in VisualAge.
 */
public void run() {
	int readb, writeb;
	readb=0;
	writeb=0;
	long wait;
	String con=socket.getInetAddress().toString();
	ByteArrayOutputStream readout=null, writeout=null;
	controller.add_con(this);

	try {
		servsock=new Socket(InetAddress.getByName(proxy), proxyport);
		InputStream servein=servsock.getInputStream();
		OutputStream servout=servsock.getOutputStream();

		// Fr jeden Request die InputStreams neu aufbauen....			
		readout=new ByteArrayOutputStream();
		writeout=new ByteArrayOutputStream();
		InputStream clientein=socket.getInputStream();
		OutputStream clientout=socket.getOutputStream();

		// Erstmal den Request lesen....

		byte data[]=new byte[8192];
		int anz=clientein.read(data);
		StringBuffer txt=new StringBuffer(new String(data, 0, anz));
		int pos1=0;
		int scanpos=anz;
		
		while ((pos1=txt.toString().indexOf(10))<=0) {
			anz=clientein.read(data);
			if (anz>0) {
				txt.append(new String(data, 0, anz));
			}
		}
			

		if (authstring!=null) {
			pos1++;
			StringBuffer txt1=new StringBuffer();
			txt1.append(txt.toString().substring(0, pos1));
			txt1.append("Proxy-authorization: Basic "+authstring+"\r\n");
			txt1.append(txt.toString().substring(pos1));
			data=txt1.toString().getBytes();
			anz=data.length;
		} else {
			data=txt.toString().getBytes();
			anz=data.length;
		}
		
		readout.write(data, 0, anz);
		servout.write(data, 0, anz);
		controller.add_bytes(controller.BYTES_WRITE, anz);
		
		int counter=100;
		
		onread=true;
		boolean work;
		while (onread) {
			work=false;
			anz=clientein.available();
			if (anz>0) {
				anz=clientein.read(data);
				controller.add_bytes(controller.BYTES_WRITE, anz);
				readout.write(data, 0, anz);
				servout.write(data, 0, anz);
				work=true;
			}


			anz=servein.available();
			if (anz==0) {
				counter--;
			}
			if (((anz>0) && (counter>0)) || ((anz>=0) && (counter<0))) {
				anz=servein.read(data);
				if (anz==-1) {
					onread=false;
				} else {
					counter=100;
					controller.add_bytes(controller.BYTES_READ, anz);
					writeout.write(data, 0, anz);
					clientout.write(data, 0, anz);
					work=true;
				}
			}

			if (!work) {
				Thread.sleep(10);
			}
		}
		
		servsock.close();
		socket.close();
	} catch(Exception e) {
		controller.log("Fehler Verbindung run: " + e);
		try {
			socket.close();
			servsock.close();
		} catch(Exception ee) {};
	}
	controller.del_con(this);


	try {
		readout.close();
		writeout.close();
	
		String fname1="log"+id+"r.txt";
		String fname2="log"+id+"w.txt";
		FileOutputStream fout=new FileOutputStream(fname1);
		fout.write(readout.toByteArray());
		fout.close();
		fout=new FileOutputStream(fname2);
		fout.write(writeout.toByteArray());
		fout.close();
	} catch(Exception e) {
		controller.log("Fehler speichern: " + e);
	}
}
/**
 * This method was created in VisualAge.
 */
public void stopit() {
	onread=false;
	int timer=100;
	while ((timer>0) && (thread.isAlive())) {
		timer--;
		try { Thread.sleep(100); } catch(Exception e) {};
	}

	if (thread.isAlive()) {
		try {
			socket.close();
		} catch(Exception e) {};

		try {
			if (servsock!=null) {
				servsock.close();
			}
		} catch(Exception e) {};
	}
}
}
