package TProxy;

import java.io.*;
import java.util.*;
import java.net.*;
/**
 * Copyright 1999,2000,2001 Stefan Hoffmann<br>
 *
 * This File is part of SetiProxy.<br>
 *
 *	SetiProxy is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.<br>
 *
 *	SetiProxy is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.<br>
 *
 *	You should have received a copy of the GNU General Public License
 *	along with SetiProxy; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
public class Controller {
	int proxyport;
	int localport;
	String proxy;
	GUI gui;
	public static final int BYTES_WRITE=1;
	public static final int BYTES_READ=2;

	String authstring;

	int read, write, con;

	Vector sockets;
	
	
/**
 * Controller constructor comment.
 */
public Controller() {
	super();
}
/**
 */
public void add_bytes(int type, int len) {
	if (type==BYTES_READ) {
		read+=len;
	} else {
		write+=len;
	}
	gui.getLBLBytes().setText(""+read+" / "+write);
}
/**
 */
public void add_con(Verbindung verb) {
	con++;
	gui.getLBLConns().setText(""+con);
	sockets.addElement(verb);
}
/**
 */
public void close_all() {
	Enumeration enum=sockets.elements();
	while (enum.hasMoreElements()) {
		Verbindung verb=(Verbindung)enum.nextElement();
		verb.stopit();
	}
	sockets.removeAllElements();
}
/**
 */
public void del_con(Verbindung verb) {
	con--;
	gui.getLBLConns().setText(""+con);
	sockets.removeElement(verb);
}
/**
 * This method was created in VisualAge.
 */
public void init() {

	read=0;
	write=0;
	con=0;
	sockets=new Vector(10);
	gui=new GUI("TestProxy", this);
	gui.show();
	
	try {
		FileInputStream fein=new FileInputStream("tproxy.properties");
		if (fein==null) {
			return;
		}

	
		Properties props=new Properties();
		props.load(fein);
		fein.close();

		Object obuser=props.getProperty("user");
		Object obpass=props.getProperty("password");
		if ((obuser==null) || (obpass==null)) {
			log("User/Password-Properties nicht gefunden. Frage ber Dialog...");
		}
		else
		{
			setAuth(obuser.toString(), obpass.toString());
		}


		Object tmpproxy=props.getProperty("proxy");
		Object tmpproxyport=props.getProperty("proxyport");
		
		if ((tmpproxy==null) || (tmpproxyport==null)) {
			log("Proxy/Proxyport Properties fehlen !");
			proxy="127.0.0.1";
			proxyport=80;
		} else {
			proxy=tmpproxy.toString();
			proxyport=new Integer(tmpproxyport.toString()).intValue();
			log("Verwende Proxy " + proxy + " auf Port " + proxyport);
		}
		Object tmplocalp=props.getProperty("localport");
		if (tmplocalp==null) {
			log("localport Propertie nicht gefunden. verwende 2299");
			localport=2299;
		} else {
			localport=new Integer(tmplocalp.toString()).intValue();
			log("PreProxy luft auf lokalem Port " + localport);
		}

		
	} catch (Exception e) {
		System.out.println("Fehler init: " + e);
	}
}
/**
 */
public void log(String txt) {
	if (gui!=null) {
		gui.log(txt);
	}
}
/**
 * This method was created in VisualAge.
 * @param args java.lang.String[]
 */
public static void main(String args[]) {
	Controller con=new Controller();
	con.run();
}
/**
 */
public void run() {
	int id=0;
	init();
	boolean working=true;
	try {
		ServerSocket sock=new ServerSocket(localport);

		while (working)
		{
			Socket getsock=sock.accept();
			Verbindung tun=new Verbindung(this, getsock, proxy, proxyport, 0, id, authstring);
			id++;
		}
	
	} catch(Exception e) {
		log("FEHLER: Neue Verbindung: Exception: " + e);
	}
}
/**
 * This method was created in VisualAge.
 * @param id java.lang.String
 * @param pass java.lang.String
 */
public void setAuth(String id, String pass) {
	StringBuffer auth=new StringBuffer();
	auth.append(id);
	auth.append(":");
	auth.append(pass);

	sun.misc.BASE64Encoder dec = new sun.misc.BASE64Encoder();
	this.authstring = new String(dec.encode(auth.toString().getBytes()));
	log("Proxy-Authorisierung mit User-id " + id + ".");
}
}
