package SetiWebAdmin;

import SetiHome.*;
import java.io.*;
import java.net.*;
import java.util.*;
/**
 * Copyright 1999,2000,2001 Stefan Hoffmann<br>
 *
 * This File is part of SetiProxy.<br>
 *
 *	SetiProxy is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.<br>
 *
 *	SetiProxy is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.<br>
 *
 *	You should have received a copy of the GNU General Public License
 *	along with SetiProxy; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
public class SetiStop implements Runnable {
	MainController con;
	Thread thread;
/**
 * SetiStop constructor comment.
 */
public SetiStop(MainController con) {
	super();
	this.con=con;
	thread=new Thread(this);
	thread.start();
	
}
/**
 * This method was created in VisualAge.
 * @param args java.lang.String[]
 */
public static void main(String args[]) {
	int port=8083;
	
	try {
		Properties props=new Properties();
		FileInputStream inp=new FileInputStream("setiproxy.properties");
		props.load(inp);
		inp.close();
		port=new Integer(props.getProperty("adminport")).intValue();
	} catch(Exception e) {
		System.out.println("Kann Properties nicht laden: " + e);
	}

	byte puffer[]=new byte[8192];
	try {
		Socket sock=new Socket(InetAddress.getByName("127.0.0.1"), 8083);
		OutputStream outp=sock.getOutputStream();
		PrintWriter prn=new PrintWriter(new OutputStreamWriter(outp));

		prn.println("GET /stop.html HTTP/1.0");
		prn.println("");
		prn.flush();

		InputStream stream=sock.getInputStream();
		ByteArrayOutputStream out=new ByteArrayOutputStream();
		int len=stream.read(puffer);
		while (len>=0) {
			if (len>0) {
				out.write(puffer, 0, len);
			} else {
				Thread.sleep(100);
			}
			len=stream.read(puffer);
		}
		sock.close();
		
	} catch(Exception e) {
		System.out.println("Fehler. " + e);
	}
}
/**
 * run method comment.
 */
public void run() {
	con.stop();
}
}
