package SetiWebAdmin;

import SetiHome.*;
import java.util.*;
import java.net.*;
/**
 * Copyright 1999,2000,2001 Stefan Hoffmann<br>
 *
 * This File is part of SetiProxy.<br>
 *
 *	SetiProxy is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.<br>
 *
 *	SetiProxy is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.<br>
 *
 *	You should have received a copy of the GNU General Public License
 *	along with SetiProxy; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
public class AdminListener implements Runnable {
	Vector comm;
	Logger log;
	Thread thread;
	int port;
	boolean run;
	ServerSocket sock;
	
/**
 * AdminListener constructor comment.
 */
public AdminListener(Logger log, Vector comm, int port) {
	super();
	this.log=log;
	this.comm=comm;
	this.port=port;
	thread=new Thread(this, "AdminListener");
	thread.start();
}
/**
 * AdminListener constructor comment.
 */
public void run() {
	log.log(LS.ls("alrn1") + " " +port, AdminServer.LOG_DEBUG);
	try {
		sock=new ServerSocket(port);

		run=true;
		while (run) {
			Socket getsock=sock.accept();
			String horst=getsock.getInetAddress().getHostName();
			// log.log("AdminListener: Verbindung von " + horst, AdminServer.LOG_DEBUG);
			AdminConnection con=new AdminConnection(getsock);
			comm.addElement(con);
		}
	} catch(Exception e) {
		if ((!e.getMessage().equals("socket was closed")) &&
		   (!e.getMessage().equals("Interrupts system call"))) {
			log.log(LS.ls("alrn2") + e, AdminServer.LOG_ERROR);
		}
	}
	log.log(LS.ls("alrn3"), AdminServer.LOG_DEBUG);
}
/**
 * This method was created in VisualAge.
 */
public void start() throws java.lang.Exception {
}
/**
 * This method was created in VisualAge.
 */
public void stop() {
	run=false;
	if (sock!=null) {
		try {
			sock.close();
		} catch(Exception e) {}
	}

	int timeout=500;
	if (thread!=null) {
		while ((thread.isAlive()) && (timeout>0)) {
			timeout--;
			try { Thread.sleep(100); } catch(Exception e) {};
		}
	}
	
	if (timeout==0) {
		log.log(LS.ls("alst1"), AdminServer.LOG_ERROR);
		try {
			thread.destroy();
		} catch(Exception e) {};
	}
}
}
