package SetiTestServer;

import java.net.*;
import java.io.*;
import java.awt.event.*;
import java.awt.*;
/**
 * Copyright 1999,2000,2001 Stefan Hoffmann<br>
 *
 * This File is part of SetiProxy.<br>
 *
 *	SetiProxy is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.<br>
 *
 *	SetiProxy is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.<br>
 *
 *	You should have received a copy of the GNU General Public License
 *	along with SetiProxy; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
public class SetiServer extends java.awt.Frame implements Runnable, ActionListener {
	Thread thread;
	ServerSocket socket;
	Button ende;
	Button kaputt;
/**
 * SetiServer constructor comment.
 */
public SetiServer() {
	super();


	thread=new Thread(this, "SetiServer");
	thread.start();

	setLayout(new GridLayout(2, 1));
	ende=new Button("Ende");
	kaputt=new Button("Tut");
	ende.addActionListener(this);
	kaputt.addActionListener(this);
	add(ende);
	add(kaputt);

	show();
	setSize(100, 100);
	
	
}
/**
 * SetiServer constructor comment.
 */
public SetiServer(String headline) {
	super(headline);
	init();
}
/**
 * SetiServer constructor comment.
 */
public void actionPerformed(ActionEvent evt) {
	String texte[]={"Tut","Schrott","Null"};
	if (evt.getSource()==ende) {
		if (socket!=null) {
			try {
				socket.close();
			} catch(Exception e) {};
		}
	}
	if (evt.getSource()==kaputt) {
		int i=0;
		for(i=0;i<texte.length;i++) {
			if (kaputt.getLabel().equals(texte[i])) {
				break;
			}
		}
		i++;
		if (i==texte.length) {
			i=0;
		}
		kaputt.setLabel(texte[i]);
	}

}
/**
 * SetiServer constructor comment.
 */
public void init() {
	thread=new Thread(this, "SetiServer");
	thread.start();
	setSize(200, 100);

	setLayout(new GridLayout(2, 1));
	ende=new Button("Ende");
	kaputt=new Button("Tut");
	ende.addActionListener(this);
	kaputt.addActionListener(this);
	add(ende);
	add(kaputt);

	show();
	
	
}
/**
 * This method was created in VisualAge.
 * @param args java.lang.String[]
 */
public static void main(String args[]) {
	SetiServer server=new SetiServer("SetiSimServer");
	
}
/**
 * SetiServer constructor comment.
 */
public void run() {
	int verb=0;
	System.out.println("gestartet auf Port 8079.");

	try {
		
		socket=new ServerSocket(8079);
		while (true) {
			Socket connection=socket.accept();
			RequestHandler req=new RequestHandler(connection, kaputt);
				
			
			
		}
	} catch(Exception e) {
		System.out.println("Fehler SetiServer: Socket: " + e);
	}
	System.exit(0);
	
}
}
