package SetiHome;

import javax.swing.*;
import javax.swing.tree.*;
import javax.swing.event.*;
import java.util.*;
/**
 * Copyright 1999,2000,2001 Stefan Hoffmann<br>
 *
 * This File is part of SetiProxy.<br>
 *
 *	SetiProxy is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.<br>
 *
 *	SetiProxy is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.<br>
 *
 *	You should have received a copy of the GNU General Public License
 *	along with SetiProxy; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
public class WUTreeHandler implements TreeSelectionListener {
		// Das eigentliche Tree-Objekt
	JTree tree;

	// Das Speichermodell, welches die Daten des Baumes hlt..
	DefaultTreeModel treedata;

	// Das Root-Objekt, welches die erste Verzweigung darstellt...
	DefaultMutableTreeNode rootnode;

	MainController data;

	GUITreeNode node;
/**
 * ClientTreeHandler constructor comment.
 */
public WUTreeHandler(MainController handler, JTree tree) {
	super();

	this.data=handler;
	this.tree=tree;

  tree.addTreeSelectionListener(this);

	initWorkunitList();
}
/**
 * Insert the method's description here.
 * Creation date: (24.09.2000 16:43:03)
 */
public void deleteRequest() {
	if (node!=null) {
		if (node.isWorkunit()) {
			this.data.deleteWorkunit(((GUIWorkunitTreeNode)node).getFilename());
			initWorkunitList();
		} else {
			if (node.isResult()) {
				ClientConnectionData conda=((GUIResultTreeNode)node).getConnectionData();
				if (!conda.getInwork()) {
					data.finishRequest(conda);
					data.add_workunit(-1);
					initWorkunitList();
				}
			}
		}
	}
}
/**
 * This method was created in VisualAge.
 */
public GUITreeNode getSelected() {
	return node;
}
/**
 * This method was created in VisualAge.
 */
public void initWorkunitList() {

	// Hier zeigen wir jetzt die Unit-Infos...

	GUITreeNode node1, node2, rootnode;
	
  // Das erste Objekt.... die Wurzel des Baumes
  //rootnode=new DefaultMutableTreeNode("Units");
  rootnode=new GUITreeNode(LS.ls("guiui1"));

  // Jetzt das Allgemeine Datenmodell welches die Daten hlt..
  treedata=new DefaultTreeModel(rootnode);

  //node1=new DefaultMutableTreeNode("Vorrtige Units");
  node1=new GUITreeNode(LS.ls("guiui2"));
  treedata.insertNodeInto(node1, rootnode, 0);

  Enumeration enum=data.enumWorkunits();

  int i=0;

  while (enum.hasMoreElements()) {
	  Workunit wu=(Workunit)enum.nextElement();
	  node2=new GUIWorkunitTreeNode(wu);
	  treedata.insertNodeInto(node2, node1, i);
	  i++;
  }

  //node1=new DefaultMutableTreeNode("Noch zu sendende Ergebnisse");
  node1=new GUITreeNode(LS.ls("guiui3"));
  treedata.insertNodeInto(node1, rootnode, 1);

  enum=data.getWaitingUnits();
  i=0;

  while (enum.hasMoreElements()) {
	  ClientConnectionData conda=(ClientConnectionData)enum.nextElement();
	  node2=new GUIResultTreeNode(conda);
	  treedata.insertNodeInto(node2, node1, i);
	  i++;
  }

  tree.setModel(treedata);
}
public void valueChanged(TreeSelectionEvent e) 
{
	node=(GUITreeNode)e.getPath().getLastPathComponent();
}
}
