package SetiHome;

import java.io.*;
import java.net.*;
import java.util.*;
/**
 * Copyright 1999,2000,2001 Stefan Hoffmann<br>
 *
 * This File is part of SetiProxy.<br>
 *
 *	SetiProxy is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.<br>
 *
 *	SetiProxy is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.<br>
 *
 *	You should have received a copy of the GNU General Public License
 *	along with SetiProxy; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
public class SetiConnection implements Runnable {
	ClientConnectionData condata;
	MainController con;

	Thread thread;
/**
 * SetiConnection constructor comment.
 */
public SetiConnection(ClientConnectionData condat, MainController mcon, boolean run) {
	this.condata=condat;
	this.con=mcon;

	if (run) {
		thread=new Thread(this, "SetiCon");
		thread.start();
	}
	
	
}
/**
 * SetiConnection constructor comment.
 */
public void run() {
	runit();
}
/**
 * 
 */
public boolean runit() {
	boolean ok = true;
	boolean unknown = true;
	if (condata.getInwork()) {
		return false;
	}
	condata.setInwork(true);
	// Prinzipiell verbinden wir uns ja jetzt mit einem Client....
	// vorausgesetzt, die Verbindung ist aktiv !!
	if (condata.getAktiv()) {
		con.setzeLastZugriff(con.CLIENTCONNECT, condata.getClient().getClientName());
	}

	// Aber wir verbinden uns in der derzeitigen Version auf jeden Fall mit dem Seti-Server
	con.setzeLastZugriff(con.SETICONNECT, null);
	con.treeUpdate();
	try {
		Properties props = condata.getFelder();
		if (props == null) {
			con.log(LS.ls("scrn1"), con.LOG_ERROR);
			con.finishRequest(condata);
			ok = true;
			if (condata.getAktiv()) {
				condata.getSocket().close();
			}
			return true;
		}
		String ops = props.getProperty("setiproxykey-operation");
		if (ops == null) {
			con.log(LS.ls("scrn2") + condata.getFelder().toString(), con.LOG_ERROR);
			con.finishRequest(condata);
			ok = true;
			if (condata.getAktiv()) {
				condata.getSocket().close();
			}
			return true;
		}
		/*************************************************************************************/
		/* lookup_user_name */
		if (ops.equals("lookup_user_name")) {
			unknown = false;
			con.log(LS.ls("scrn3a") + " " + condata.getClient().getClientName() + " " + LS.ls("scrn3b"), con.LOG_DEBUG);
			// bei lookup wartet der Client natrlich immer...
			// Die eingehenden Daten speichern fr den nchsten Automatisierten Zugriff...
			condata.getClient().setLastZugriff();
			condata.getClient().setStatus(Client.WARTET);
			con.finishRequest(condata);
			ClientConnectionData antw = sendRequest();
			if ((antw == null) || ((antw.getHttpCode() != 0) && (antw.getHttpCode() != 200))) {
				ok = false;
				String wert;
				if ((antw != null) && ((wert = antw.getFelder().getProperty("setiproxykey-firstline")) != null)) {
					con.log(LS.ls("scrn4") + wert, con.LOG_WARNING);
					if (con.getProperty("debug") != null) {
						con.log(new String(antw.getRohDaten()), con.LOG_DEBUG);
					}
				}
				// Fehlerfall, also mit mogelpackung antworten...
				byte[] fakemes = condata.getClient().getLookupAnswer();
				// Wenn der Client noch nie die Message erhalten hat, dann haben wir pech...
				if (fakemes != null) {
					Socket antwsock = condata.getSocket();
					OutputStream outp = antwsock.getOutputStream();
					outp.write(fakemes);
					antwsock.close();
				} else {
					// Das ist natrlich ziemlich dumm....
					sendAbbruch(condata.getSocket());
					con.log(LS.ls("scrn5a") + condata.getClient().getClientName() + " " + LS.ls("scrn5b"), con.LOG_WARNING);
				}
			} else {
				con.setzeLastZugriff(con.SETISUCCESS, null);
				// Sowie fr die gefakte Antwort nur die rohen lookup-daten
				antw.getClient().setLookupAnswer(antw.getRohDaten());
				Socket antwsock = condata.getSocket();
				OutputStream outp = antwsock.getOutputStream();
				outp.write(antw.getRohDaten());
				antwsock.close();
			}
		}

		/*************************************************************************************/
		/* send_result */
		if (ops.equals("send_result")) {
			unknown = false;
			con.log(LS.ls("scrn6a") + " " + condata.getClient().getClientName() + " " + LS.ls("scrn6b"), con.LOG_DEBUG);
			if (condata.getAktiv()) {
				con.add_workunit(1);
				// Der Status ist jetzt warten.. da der Client ja keine neue WU hat...
				// Natrlich nur, wenn der Client auch aktiv ist...
				condata.getClient().setStatus(Client.WARTET);
			}
			ClientConnectionData antw = sendRequest();
			if ((antw != null) && ((antw.getHttpCode() == 0) || (antw.getHttpCode() == 200))) {
				// Jetzt, da die Workunit abgesetzt worden ist, bekommt der Client sie auch gutgeschrieben...
				//condata.getClient().setUnitsBisher(new Integer(condata.getClient().getUnitsBisher()).intValue() + 1);
				con.setzeLastZugriff(con.SETISUCCESS, null);
				condata.getClient().setUnitsBisher(condata.getClient().getUnitsBisher()+1);
				con.finishRequest(condata);
				con.add_workunit(-1);
				// Check, ob der Status ok ist... bei 66 nicht speichern...
				String test66=new String(antw.getRohDaten());
				if (test66.indexOf("status=-66")==-1) {
					// Ausserdem speichern wir das, damit wir es beim nchsten request einsetzen knnen....
					antw.getClient().getLookupProperties().put("setiproxykey-send_result", antw.getRohDaten());
				}
				
				// Hier ist eine standard-Antwort, die sofort gespeichert wird !!
				if (con.getProperty("alwayssimsendresultanswer") == null) {
					FileOutputStream fout = new FileOutputStream("sendresult.data");
					fout.write(antw.getRohDaten());
					fout.close();
				}
			} else {
				ok = false;
				String wert;
				if ((antw != null) && ((wert = antw.getFelder().getProperty("setiproxykey-firstline")) != null)) {
					con.log(LS.ls("scrn4") + wert, con.LOG_WARNING);
					if (con.getProperty("debug") != null) {
						con.log(new String(antw.getRohDaten()), con.LOG_DEBUG);
					}
				}
			}
			// ist das denn schon ein versptetes senden oder wartet der Client noch ??
			if (condata.getAktiv()) {
				// Wenn der Request noch aktiv ist, dann mssen wir auch antworten...
				condata.getClient().setLastZugriff();
				if ((antw == null) || ((antw.getHttpCode() != 0) && (antw.getHttpCode() != 200))) {
					// Hier ist der Fehlerfall, also antworten wir mit unserem Gefakten...
					try {
						byte[] puffer=(byte[])condata.getClient().getLookupProperties().get("setproxy-send_result");
						int len;

						// Wenn das Feld noch nicht gefllt worden ist, eben nicht...
						// Dann nehmen wir die alten Daten....
						if (puffer==null) {
							puffer = new byte[5000];
							FileInputStream fin = new FileInputStream("sendresult.data");
							len = fin.read(puffer);
							fin.close();
						} else {
							len=puffer.length;
						}

						Socket antwsock = condata.getSocket();
						OutputStream outp = antwsock.getOutputStream();
						outp.write(puffer, 0, len);
						antwsock.close();
					} catch (Exception e) {
						// Und hier hatten wir wohl probleme... also, was solls, man
						// kann nicht alles abfangen...
						con.log(LS.ls("scrn7") + e, con.LOG_ERROR);
						con.finishRequest(condata);
						sendAbbruch(condata.socket);
						con.add_workunit(-1);
					}
				} else {
					// Hier ist alles ok, wir schleifen die Antwort vom Server einfach durch..
					if (con.getProperty("alwayssimsendresultanswer") != null) {
						//************ WORKAROUND FR ULLI
						//die Antwort vom Server wird nicht durchgeschliffen...
						FileInputStream fin = new FileInputStream("sendresult.data");
						Socket antwsock = condata.getSocket();
						OutputStream outp = antwsock.getOutputStream();
						byte[] puffer = new byte[4000];
						int len = 0;
						while (len != -1) {
							len = fin.read(puffer);
							if (len > 0) {
								outp.write(puffer, 0, len);
							}
						}
						fin.close();
						antwsock.close();
					} else {
						Socket antwsock = condata.getSocket();
						OutputStream outp = antwsock.getOutputStream();
						outp.write(antw.getRohDaten());
						antwsock.close();
					}
				}
			}
		}

		/* Untersttzung fr die neuen 2.0 Clients */
		/*************************************************************************************/
		/* send_result_get_user_stats */
		if (ops.equals("send_result_get_user_stats")) {
			unknown = false;
			con.log(LS.ls("scrn12a") + " " + condata.getClient().getClientName() + " " + LS.ls("scrn12b"), con.LOG_DEBUG);
			if (condata.getAktiv()) {
				con.add_workunit(1);
				// Der Status ist jetzt warten.. da der Client ja keine neue WU hat...
				// Natrlich nur, wenn der client auch aktiv ist....
				condata.getClient().setStatus(Client.WARTET);
			}
			ClientConnectionData antw = sendRequest();
			if ((antw != null) && ((antw.getHttpCode() == 0) || (antw.getHttpCode() == 200))) {
				// Jetzt, da die Workunit abgesetzt worden ist, bekommt der Client sie auch gutgeschrieben...

				con.setzeLastZugriff(con.SETISUCCESS, null);
				String test66=new String(antw.getRohDaten());
				if (test66.indexOf("status=-66")==-1) {
					// Ausserdem speichern wir das, damit wir es beim nchsten request einsetzen knnen....
					antw.getClient().getLookupProperties().put("setiproxykey-send_result_get_user_stats", antw.getRohDaten());
				}

				condata.getClient().setUnitsBisher(condata.getClient().getUnitsBisher()+1);
				con.finishRequest(condata);
				con.add_workunit(-1);
				// Hier ist eine standard-Antwort, die sofort gespeichert wird !!
				if (con.getProperty("alwayssimsendresultanswer") == null) {
					FileOutputStream fout = new FileOutputStream("sendresult2.data");
					fout.write(antw.getRohDaten());
					fout.close();
				}
			} else {
				ok = false;
				String wert;
				if ((antw != null) && ((wert = antw.getFelder().getProperty("setiproxykey-firstline")) != null)) {
					con.log(LS.ls("scrn4") + wert, con.LOG_WARNING);
					if (con.getProperty("debug") != null) {
						con.log(new String(antw.getRohDaten()), con.LOG_DEBUG);
					}
				}
			}
			// ist das denn schon ein versptetes senden oder wartet der Client noch ??
			if (condata.getAktiv()) {
				// Wenn der Request noch aktiv ist, dann mssen wir auch antworten...
				condata.getClient().setLastZugriff();
				if ((antw == null) || ((antw.getHttpCode() != 0) && (antw.getHttpCode() != 200))) {
					// Hier ist der Fehlerfall, also antworten wir mit unserem Gefakten...
					try {
						byte[] puffer=(byte[])condata.getClient().getLookupProperties().get("setiproxykey-send_result_get_user_stats");
						int len;

						// Wenn das Feld noch nicht gefllt worden ist, eben nicht...
						// Dann nehmen wir die alten Daten....
						if (puffer==null) {
							puffer = new byte[5000];
							FileInputStream fin = new FileInputStream("sendresult2.data");
							len = fin.read(puffer);
							fin.close();
						} else {
							len=puffer.length;
						}
						Socket antwsock = condata.getSocket();
						OutputStream outp = antwsock.getOutputStream();
						outp.write(puffer, 0, len);
						antwsock.close();
					} catch (Exception e) {
						// Und hier hatten wir wohl probleme... also, was solls, man
						// kann nicht alles abfangen...
						con.log(LS.ls("scrn13") + e, con.LOG_ERROR);
						con.finishRequest(condata);
						sendAbbruch(condata.socket);
						con.add_workunit(-1);
					}
				} else {
					// Hier ist alles ok, wir schleifen die Antwort vom Server einfach durch..
					if (con.getProperty("alwayssimsendresultanswer") != null) {
						//************ WORKAROUND FR ULLI
						FileInputStream fin = new FileInputStream("sendresult2.data");
						Socket antwsock = condata.getSocket();
						OutputStream outp = antwsock.getOutputStream();
						byte[] puffer = new byte[4000];
						int len = 0;
						while (len != -1) {
							len = fin.read(puffer);
							if (len > 0) {
								outp.write(puffer, 0, len);
							}
						}
						fin.close();
						antwsock.close();
					} else {
						Socket antwsock = condata.getSocket();
						OutputStream outp = antwsock.getOutputStream();
						outp.write(antw.getRohDaten());
						antwsock.close();
					}
				}
			}
		}



		/*************************************************************************************/
		/* get_work_unit */
		if (ops.equals("get_work_unit")) {
			unknown = false;
			con.log(LS.ls("scrn8a") + " " + condata.getClient().getClientName() + " " + LS.ls("scrn8b"), con.LOG_DEBUG);
			boolean lade_workunit = false;

			con.finishRequest(condata);
			ClientConnectionData antw = null;

			// Neues Verfahren zum Laden der Workunits.... wir speichern einfach mal die
			// Anfrage vom Client damit wir sie beim nchsten mal verwenden knnen. Das mit den
			// getLoopupProperties geht mir ein bisschen auf den Sack....
			condata.getClient().getLookupProperties().put("setiproxykey-get_work_unit", (byte[])condata.getFelder().get("setiproxykey-contentsdata"));
			condata.getClient().getLookupProperties().put("setiproxykey-get_work_unit_date", new Date());
			
			// Bestens... jetzt mal sehen, ob wir noch Workunits vorrtig haben...
			Workunit unit=con.getWorkUnit();

			if (unit!=null) {
				// Ok, wir haben noch was auf lager... damit antworten wir mal !!
				condata.getClient().setStatus(Client.RECHNET);
				condata.getClient().setLastZugriff();
				Socket antwsock = condata.getSocket();
				OutputStream outp = antwsock.getOutputStream();
				outp.write(unit.getDaten());
				antwsock.close();

				// Schn, der Client ist versorgt... dann mal schauen ob wir noch welche
				// laden mssen...
				if (con.loadNewUnit()) {
					// Ja, der Vorrat muss aufgefllt werden.
					antw=sendRequest();
					if (antw!=null) {
						if ((antw.getHttpCode() == 0) || (antw.getHttpCode() == 200)) {
							// Schn, eine Workunit ist geladen worden.. 
							con.setzeLastZugriff(con.SETISUCCESS, null);
							// Diese in den Controller stecken
							con.addWorkUnit(WorkunitController.baueWorkunit(condata.getClient().getClientName(), antw.getRohDaten()));
						} else {
							// Logischer Fehler lesen workunit, Fehlerbehandlung...
							ok = false;
							String wert;
							if ((wert = antw.getFelder().getProperty("setiproxykey-firstline")) != null) {
								con.log(LS.ls("scrn4") + wert, con.LOG_WARNING);
							}
							if (con.getProperty("debug") != null) {
								con.log(new String(antw.getRohDaten()), con.LOG_DEBUG);
							}
						}
					} else {
						// Harter Fehler lesen Workunit
						ok=false;
					}
				} 
			} else {
				// So, wir haben also keine Workunit mehr auf lager.. Dann man direkt durchjagen..
				antw=sendRequest();
				if (antw!=null) {
					// So, wir haben also eine Antwort vom Server bekommen... die mal prfen
					if ((antw.getHttpCode() == 0) || (antw.getHttpCode() == 200)) {
						// Eine gltige Workunit, die an den Client weiterreichen...
						con.setzeLastZugriff(con.SETISUCCESS, null);
						condata.getClient().setStatus(Client.RECHNET);
						condata.getClient().setLastZugriff();
						Socket antwsock = condata.getSocket();
						OutputStream outp = antwsock.getOutputStream();
						outp.write(antw.getRohDaten());
						antwsock.close();
					} else {
						// Mist, logischer Fehler vom Server...
						ok = false;
						String wert;
						if ((wert = antw.getFelder().getProperty("setiproxykey-firstline")) != null) {
							con.log(LS.ls("scrn4") + wert, con.LOG_WARNING);
						}
						if (con.getProperty("debug") != null) {
							con.log(new String(antw.getRohDaten()), con.LOG_DEBUG);
						}

						// Schade, wohl keine Workunits mehr vorrtig...
						sendAbbruch(condata.getSocket());
						con.log(LS.ls("scrn9"), con.LOG_WARNING);

					}
				} else {
					// Harter Fehler lesen workunit. Schade, keine Workunit mehr fr den Client
					ok=false;
					sendAbbruch(condata.getSocket());
					con.log(LS.ls("scrn9"), con.LOG_WARNING);
				}
			}
		}
		if (unknown) {
			con.log(LS.ls("scrn10a") + ops + " " + LS.ls("scrn10b"), con.LOG_ERROR);
			con.finishRequest(condata);
		}

		// Und den Socket schliessen.... das aber immer...
		if (condata.getAktiv()) {
			condata.getSocket().close();
			condata.setAktiv(false);
		}
	} catch (Exception e) {
		con.log(LS.ls("scrn11") + e, con.LOG_ERROR);
	}
	con.treeUpdate();
	condata.setInwork(false);
	return ok;
}
/**
 * SetiConnection constructor comment.
 */
public void sendAbbruch(Socket sock) {
	try {
		OutputStream outp=sock.getOutputStream();
		outp.write(("HTTP/1.0 500 Connect failed\n\r\n\r").getBytes());
	} catch(Exception e) {
		con.log(LS.ls("scsa1") + e, con.LOG_ERROR);
	}
}
/**
 * SetiConnection constructor comment.
 */
public ClientConnectionData sendRequest() {
	// Hier jetzt den Request absetzen...
	if (!con.allow_seticonnect()) {
		return null;
	}

	try {
		ByteArrayOutputStream data = new ByteArrayOutputStream();
		Properties felder = condata.getFelder();
		String firstline=felder.getProperty("setiproxykey-firstline");
		data.write(firstline.toString().getBytes());
		//data.write(new String("POST http://shserver.ssl.berkeleyy.edu:80 HTTP/1.0").getBytes());
		data.write(0xd);
		data.write(0xa);
		String auth = con.getProxyAuthent();
		if (auth != null) {
			sun.misc.BASE64Encoder dec = new sun.misc.BASE64Encoder();
			auth = new String(dec.encode(auth.toString().getBytes()));
			data.write(("Proxy-authorization: Basic " + auth + "\r\n").getBytes());
		}
		
		Enumeration enum = felder.keys();
		while (enum.hasMoreElements()) {
			String key = enum.nextElement().toString();
			if ((key != null) && (!key.equals("setiproxykey-firstline")) && (!key.equals("setiproxykey-contentsdata")) && (!key.equals("setiproxykey-operation"))) {
				Object value = felder.get(key);
				if (value != null) {
					data.write((key + ": " + felder.get(key).toString() + "\r\n").getBytes());
				} else {
					data.write((key + "\r\n").getBytes());
				}
			}
		}
		data.write(0xd);
		data.write(0xa);

		// Der Server steht in dem Feld Host
		String setiserver=felder.getProperty("Host");
		if (setiserver==null) {
			setiserver=felder.getProperty("host");
			if (setiserver==null) {
				setiserver=con.getProperty("setiserver");
			}
		}
		
		// SOOOO, jetzt ist der Request wieder rekonstruiert.... also loschicken...
		int proxyport = con.getProxyport();
		data.close();
		try {
			con.open_connection();
			Socket inetsock = null;
			InetAddress adr = null;
			if (proxyport != 0) {
				adr = InetAddress.getByName((con.getProxyAdress()));
				if (adr == null) {
					throw new Exception(LS.ls("scsr2"));
				}
			} else {
				proxyport = 80;
				adr = InetAddress.getByName(setiserver);
				if (adr == null) {
					throw new Exception(LS.ls("scsr3"));
				}
			}
			inetsock = new Socket(adr, proxyport);
			OutputStream out = inetsock.getOutputStream();
			out.write(data.toByteArray());
			try {
				Thread.sleep(500);
			} catch(Exception e) {};

			byte cont[] = (byte[]) felder.get("setiproxykey-contentsdata");
			if (cont != null) {
				out.write(cont);
			} else {
				con.log(LS.ls("scsr1"), con.LOG_WARNING);
			}

			ClientConnection antw = new ClientConnection(inetsock, condata.getClient(), con, false);
			ClientConnectionData antwdata = antw.getData();
			inetsock.close();
			con.close_connection();
			if (antwdata != null) {
				if (antwdata.getRohDaten().length == 0) {
					con.log(LS.ls("scsr4"), con.LOG_WARNING);
					return null;
				}
				antwdata.setAktiv(false);
			}
			return antwdata;
		} catch (Exception e) {
			// Es ist ein Fehler beim versenden aufgetreten... dumm...
			con.log(LS.ls("scsr5") + e, con.LOG_WARNING);
			con.close_connection();
		}
	} catch (Exception e) {
		con.log(LS.ls("scsr6") + e, con.LOG_ERROR);
	}
	return null;
}
}
