package SetiHome;

import java.util.zip.*;
import java.net.*;
import java.io.*;
import java.text.*;
import java.util.*;
import SetiWebAdmin.*;

/**
 * Copyright 1999,2000,2001 Stefan Hoffmann<br>
 *
 * This File is part of SetiProxy.<br>
 *
 *	SetiProxy is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.<br>
 *
 *	SetiProxy is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.<br>
 *
 *	You should have received a copy of the GNU General Public License
 *	along with SetiProxy; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
public class MainController implements Logger, Runnable {
	GUIController gui;
	DataHandler data;
	LS ls;
	//ClientTreeHandler thandle;

	WorkunitController wu;

	AdminServer adminserver;

  protected FileOutputStream LogFile;
  protected PrintWriter LogPrintWriter=null;

  Listener listen;
  int waiter;

  Thread thread;

  boolean run;
  boolean stopped;

  boolean reconnect=false;
  boolean manual_reconnect=false;

  Properties admininfo;

  public static final String LogFileName="setiproxy.log";

  public static final String version="SetiProxy v2.4 12.12.2001";

  public static final String ADMSETICONNECTDATE="SETICONNECTDATE";
  public static final String ADMSETICONNECTTRYDATE="SETICONNECTTRYDATE";
  public static final String ADMANZWORKUNITS="ANZWORKUNITS";
  public static final String ADMANZREQUESTS="ANZREQUESTS";
  public static final String ADMANZPROCESSES="ANZPROCESSES";
  public static final String ADMCLIENTCONNECTDATE="CLIENTCONNTECTDATE";
  public static final String ADMCLIENTCONNECT="CLIENTCONNECT";

 	public static final int SETISUCCESS=1;
	public static final int SETICONNECT=2;
  public static final int CLIENTCONNECT=3;

  public static int MAX_WORKUNITS=200;

/**
 * MainController constructor comment.
 */
public MainController(GUIController gui) {
	super();
	this.gui=gui;
	init();
}
/**
 * Diese Routine liest die Online-Datei vom Online-Proxy, findet also OFFLINE statt. Daher die
 * Namensgebung. Es werden WU's sowie Clients geladen. Es werden nur Clients bernommen, die
 * auch im Proxy existieren.
 * @return java.lang.String
 * @param anz int
 * @param fname java.lang.String
 */
public boolean abgleich_offline_read(String fname) {
	byte puffer[]=new byte[32768];

	Hashtable elemente=new Hashtable();
	Properties doublefiles=new Properties();
	Random rand=new Random(new Date().getTime());


	// Schritt eins, die bergebene Datei einladen und die Results rausziehen...
	try {
		FileInputStream finp=new FileInputStream(fname);
		ZipInputStream zipin=new ZipInputStream(finp);
		ZipEntry entry=zipin.getNextEntry();
		while (entry!=null) {
			// Erstmal den Eintrag in ein Byte-Array laden...
			ByteArrayOutputStream byteout=new ByteArrayOutputStream();
			int len=zipin.read(puffer);
			while (len>=0) {
				byteout.write(puffer, 0, len);
				len=zipin.read(puffer);
			}
			// Ist es eine WU-Datei ?
			String endung=entry.getName().substring(entry.getName().indexOf('.'));
			if (endung.equals(".wu")) {
				// Checken ob die Datei schon existiert...
				String wuname=entry.getName();
				boolean found=true;
				while (found) {
					found=false;
			 	 try {
					  File f=new File(wuname);
					  if (f.exists()) {
						  found=true;
					  }
				  } catch(Exception e) {
				  }
				  if (found==true) {
					  // Hier einen neuen Dateinamen generieren...
					  wuname="s";
					  for(int i=0;i<7;i++) {
					    wuname=""+wuname+Math.abs((rand.nextInt()%10));
						}
					  wuname=wuname+".wu";
				  }
				}
				if (!wuname.equals(entry.getName())) {
					log("IMPORT: OFFLINE: Die Datendatei " + entry.getName() + " existiert schon. Datei wird nach " + wuname + " umbenannt.", LOG_WARNING);
				}
				
				FileOutputStream fout=new FileOutputStream(wuname);
				doublefiles.put(entry.getName(), wuname);
				fout.write(byteout.toByteArray());
				fout.close();
			} else {
				// Ansonsten ist es ein serialisiertes Objekt.... in den Elements-Hashtable schieben..
				ByteArrayInputStream bytein=new ByteArrayInputStream(byteout.toByteArray());
				byteout.close();
				ObjectInputStream objin=new ObjectInputStream(bytein);
				elemente.put(entry.getName(), objin.readObject());
				objin.close();
			}
			entry=zipin.getNextEntry();
		}
		zipin.close();
		

		// Erstmal die Info aus der Property-Datei.....
		Properties props=(java.util.Properties)elemente.get("infos.prp");
		if (props==null) {
			throw new Exception("INFOS.PRP Datei fehlt.");
		}
		// Schauen wir uns doch mal an, was die Datei zu bieten hat.
		log("IMPORT: OFFLINE: Lade Abgleichdatei von Rechner " + props.getProperty("rechnerid") +
			  " generiert am " + props.getProperty("datum"), LOG_INFO);
		String id=props.getProperty("id");
		if (id==null) {
			throw new Exception("ID-Information ungltig/nicht gesetzt");
		}
		if (!id.equals("onlinewrite1.0")) {
			throw new Exception("Falscher Dateityp fr Operation. Gewnscht: onlinewrite1.0, bekommen: "+id);
		}

		// bernehmen der Workunits...
		Vector wus=(java.util.Vector)elemente.get("workunits.vector");
		if (wus==null) {
			log("IMPORT: OFFLINE: Es sind keine WU's bergeben worden.", LOG_WARNING);
		} else {
			// Ok, dann mal alle WU's eintragen... ich hoffe das klappt...
			Enumeration wuenum=wus.elements();
			while (wuenum.hasMoreElements()) {
				Workunit wu=(Workunit)wuenum.nextElement();
				String newname=doublefiles.getProperty(wu.getFilename());
				if (newname==null) {
					log("IMPORT: OFFLINE: Datenfile " + wu.getFilename() + " nicht vorhanden. WU gelscht.", LOG_ERROR);
				} else {
					wu.setFilename(newname);
					File file=new File(newname);
					if (file.exists()) {
						// Workunit eintragen.
						addWorkUnit(wu);
					} else {
						log("IMPORT: OFFLINE: Datenfile " + wu.getFilename() + " nicht vorhanden. WU gelscht.", LOG_ERROR);
					}
				}
			}
		}

		// Jetzt die Clients einladen...
		Vector clients=(java.util.Vector)elemente.get("clients.vector");
		if (clients!=null) {
			Enumeration clientenum=clients.elements();
			while (clientenum.hasMoreElements()) {
				Client cl=(Client)clientenum.nextElement();
				Client oldcl=data.getClient(cl.getClientName());
				if (oldcl!=null) {
					oldcl.setClientName(cl.getClientName());
					oldcl.setLastZugriff(cl.getLastZugriff());
					oldcl.setLookupAnswer(cl.getLookupAnswer());
					oldcl.setLookupProperties(cl.getLookupProperties());
					oldcl.setStatus(cl.getStatus());
					oldcl.setUnitsBisher(cl.getUnitsBisher());
				}
			}
		} else {
			log("IMPORT: OFFLINE: Es wurden keine Client-Profile bergeben.", LOG_WARNING);
		}
	} catch(Exception e) {
		log("IMPORT: OFFLINE: Fehler beim laden der Datei: " + e, LOG_ERROR);
		return false;
	}
	return true;
}
/**
 * Diese Routine schreibt die Results dieses Proxys in die Abgleichs-Datei.
 */
public boolean abgleich_offline_write(String fname) {

	try {
		// Kleiner Test, ob wir berhaupt schreiben drfen... ;-)
		FileOutputStream fout=new FileOutputStream(fname);
		fout.write(10);
		fout.close();
		fout=new FileOutputStream(fname);
		ZipOutputStream zipout=new ZipOutputStream(fout);
		// Ok, wir erzeugen Properties... mal sehen, wie das tut...
		Properties props=new Properties();
		Vector wus=new Vector();
	
		props.put("rechnerid", InetAddress.getLocalHost().toString());
		props.put("id", "offlinewrite1.0");
		props.put("datum", new Date().toString());

		Vector tempdata=new Vector();
		Enumeration warter=data.getWaitingRequests();
		while ((warter.hasMoreElements())) {
			tempdata.addElement(warter.nextElement());
		}

		Vector results=new Vector();
		Enumeration dataenum=tempdata.elements();
		while (dataenum.hasMoreElements()) {
			ClientConnectionData condata=(ClientConnectionData)dataenum.nextElement();
			if ((!condata.getAktiv()) && (!condata.getInwork())) {
				condata.setSocket(null);
				results.addElement(condata);
				finishRequest(condata);
				add_workunit(-1);
			}
		}

		// Abspeichern der Properties...
		ByteArrayOutputStream byteout=new ByteArrayOutputStream();
		ObjectOutputStream objout=new ObjectOutputStream(byteout);
		objout.writeObject(props);
		objout.close();
		
		ZipEntry infos=new ZipEntry("infos.prp");
		zipout.putNextEntry(infos);
		zipout.write(byteout.toByteArray());
		byteout.close();

		// Abspeichern des Results-Vectors..
		byteout=new ByteArrayOutputStream();
		objout=new ObjectOutputStream(byteout);
		objout.writeObject(results);
		objout.close();
		
		infos=new ZipEntry("results.data");
		zipout.putNextEntry(infos);
		zipout.write(byteout.toByteArray());
		byteout.close();
		zipout.finish();
		zipout.close();
	} catch(Exception e) {
		log("EXPORT: ONLINE: Fehler aufgetreten, eventuell WU's verloren: " + e, LOG_ERROR);
	}
	
	return true;
}
/**
 * Diese Routine liest die Offline-Datei vom Offline-Proxy, findet also ONLINE statt. Daher die
 * Namensgebung. Eingelesen werden nur die Results. Die Clients werden umbenannt in die OFFLINE:xxx
 * Clients und falls noch nicht vorhanden in die Clientliste des Proxys aufgenommen.
 * @return java.lang.String
 * @param anz int
 * @param fname java.lang.String
 */
public boolean abgleich_online_read(String fname) {
	byte puffer[]=new byte[32768];

	Hashtable elemente=new Hashtable();

	// Schritt eins, die bergebene Datei einladen und die Results rausziehen...
	try {
		FileInputStream finp=new FileInputStream(fname);
		ZipInputStream zipin=new ZipInputStream(finp);
		ZipEntry entry=zipin.getNextEntry();
		while (entry!=null) {
			// In diesem Stream sind (theoretisch) nur Objekte gekapselt... Also knnen wir direkt
			// laden...
			ByteArrayOutputStream byteout=new ByteArrayOutputStream();
			int len=zipin.read(puffer);
			while (len>=0) {
				byteout.write(puffer, 0, len);
				len=zipin.read(puffer);
			}
			ByteArrayInputStream bytein=new ByteArrayInputStream(byteout.toByteArray());
			byteout.close();
			ObjectInputStream objin=new ObjectInputStream(bytein);
			elemente.put(entry.getName(), objin.readObject());
			objin.close();
			entry=zipin.getNextEntry();
		}
		zipin.close();

		// Erstmal die Info aus der Property-Datei.....
		Properties props=(java.util.Properties)elemente.get("infos.prp");
		if (props==null) {
			throw new Exception("INFOS.PRP Datei fehlt.");
		}
		// Schauen wir uns doch mal an, was die Datei zu bieten hat.
		log("IMPORT: ONLINERECHNER: Lade Abgleichdatei von Rechner " + props.getProperty("rechnerid") +
			  " generiert am " + props.getProperty("datum"), LOG_INFO);
		String id=props.getProperty("id");
		if (id==null) {
			throw new Exception("ID-Information ungltig/nicht gesetzt");
		}
		if (!id.equals("offlinewrite1.0")) {
			throw new Exception("Falscher Dateityp fr Operation. Gewnscht: offlinewrite1.0, bekommen: "+id);
		}
		
		// Jetzt ziehen wir die Ergebnisse raus:
		Vector results=(java.util.Vector)elemente.get("results.data");
		log("IMPORT: ONLINERECHNER: Importdatei enthlt " + results.size()+ " Results.", LOG_INFO);
		
		// Gut, jetzt haben wir alle Results..
		Enumeration enumresults=results.elements();
		while(enumresults.hasMoreElements()) {
			ClientConnectionData condata=(ClientConnectionData)enumresults.nextElement();
			// Jetzt mssen wir noch die Clients setzen..
			// Erstmal den Client aus der Verbindung laden...
			Client akclient=condata.getClient();
			// Und dem aktuellen Proxy anpassen.....
			// Existiert schon ein Client dieser Art im Proxy ?
			Client oldclient=data.getClient("OFFLINE_"+akclient.getClientName());
			if (oldclient==null) {
				// Wenn nicht, nehmen erzeugen wir einen neuen...
				Client newcl=new Client();
				newcl.setClientName("OFFLINE_"+akclient.getClientName());
				newcl.setLastZugriff(akclient.getLastZugriff());
				newcl.setLookupAnswer(akclient.getLookupAnswer());
				newcl.setLookupProperties(akclient.getLookupProperties());
				newcl.setStatus(akclient.getStatus());
				newcl.setUnitsBisher(akclient.getUnitsBisher());
				condata.setClient(newcl);
				data.addClient(newcl);
				gui.addClient(newcl);
			} else {
				// Wenn doch, dann ist das unser aktueller auch fr diesen Request..
				condata.setClient(oldclient);
			}
			// Und in den Proxy berspielen...
			addRequest(condata);
		  add_workunit(1);
		}
	} catch(Exception e) {
		log("IMPORT: ONLINERECHNER: Fehler beim laden der Datei: " + e, LOG_ERROR);
		return false;
	}

	return true;
}
/**
 * Diese Routine liest schreibt WU's sowie die Daten der Offline-Clients raus in einen ZIP-Stream.
 * @return java.lang.String
 * @param anz int
 * @param fname java.lang.String
 */
public boolean abgleich_online_write(int anz, String fname) {
	byte puffer[]=new byte[32768];

	if ((anz<=0) || (anz>wu.getAnzWorkunits())) {
		log("Export_wus: Inkorrekte Anzahl Workunits: gefordert: " + anz + ", haben: " + wu.getAnzWorkunits(), LOG_ERROR);
		log("Reduziere Anzahl auf " + wu.getAnzWorkunits(), LOG_ERROR);
		anz=wu.getAnzWorkunits();
	}

	try {
		// Kleiner Test, ob wir berhaupt schreiben drfen... ;-)
		FileOutputStream fout=new FileOutputStream(fname);
		fout.write(10);
		fout.close();
		fout=new FileOutputStream(fname);
		ZipOutputStream zipout=new ZipOutputStream(fout);
		// Ok, wir erzeugen Properties... mal sehen, wie das tut...
		Properties props=new Properties();
		Vector wus=new Vector();
	
		int counter=0;
		for(int i=0;i<anz;i++) {
			Workunit mywu=wu.getWorkunit(false);
			if (mywu==null) {
				log("EXPORT: ONLINE: Fehler exportieren, keine WU's mehr verfgbar. Abbruch", LOG_ERROR);
				break;
			}
			wus.addElement(mywu);
			counter++;
		}

		props.put("rechnerid", InetAddress.getLocalHost().toString());
		props.put("id", "onlinewrite1.0");
		props.put("datum", new Date().toString());

		Vector clients=new Vector();
		Enumeration clientenum=data.getClients(Client.ALLE);
		while (clientenum.hasMoreElements()) {
			Client cl=(Client)clientenum.nextElement();
			if (cl.getClientName().substring(0,8).equals("OFFLINE_")) {
				// Daten in ein neues Objekt kopieren, damit der Name gendert werden kann.
				Client newcl=new Client();
				newcl.setClientName(cl.getClientName().substring(8));
				newcl.setLastZugriff(cl.getLastZugriff());
				newcl.setLookupAnswer(cl.getLookupAnswer());
				newcl.setLookupProperties(cl.getLookupProperties());
				newcl.setStatus(cl.getStatus());
				newcl.setUnitsBisher(cl.getUnitsBisher());
				clients.addElement(newcl);
			}
		}

		// Abspeichern der Properties...
		ByteArrayOutputStream byteout=new ByteArrayOutputStream();
		ObjectOutputStream objout=new ObjectOutputStream(byteout);
		objout.writeObject(props);
		objout.close();
		
		ZipEntry infos=new ZipEntry("infos.prp");
		zipout.putNextEntry(infos);
		zipout.write(byteout.toByteArray());
		byteout.close();

		// Abspeichern des WU-Vectors..
		byteout=new ByteArrayOutputStream();
		objout=new ObjectOutputStream(byteout);
		objout.writeObject(wus);
		objout.close();
		
		infos=new ZipEntry("workunits.vector");
		zipout.putNextEntry(infos);
		zipout.write(byteout.toByteArray());
		byteout.close();

		// Abspeichern des Client-Vectors..
		byteout=new ByteArrayOutputStream();
		objout=new ObjectOutputStream(byteout);
		objout.writeObject(clients);
		objout.close();
		
		infos=new ZipEntry("clients.vector");
		zipout.putNextEntry(infos);
		zipout.write(byteout.toByteArray());
		byteout.close();

		// Jetzt die Datendateien der jeweiligen WU's sichern...
		Enumeration enum=wus.elements();
		while (enum.hasMoreElements()) {
			Workunit mywu=(Workunit)enum.nextElement();
			ZipEntry entry=new ZipEntry(mywu.getFilename());
			zipout.putNextEntry(entry);
			zipout.write(mywu.getDaten());
			// Und die Workunkit austragen. Wir wollen ja nicht, das die verdoppelt werden...
			mywu.delete_unit();
		}
		
		// FETTISCH !!
		zipout.finish();
		zipout.close();
		log("EXPORT: ONLINE: Es wurden erfolgreich " + counter + " Workunits in die Datei " + fname + " exportiert.", LOG_INFO);
	} catch(Exception e) {
		log("EXPORT: ONLINE: Fehler aufgetreten, eventuell WU's verloren: " + e, LOG_ERROR);
	}
	
	return true;
}
/**
 */

synchronized void add_saveworkunit(int val) {
	admininfo.put(ADMANZWORKUNITS, new Integer(gui.addWorkunits(val)).toString());
	
}
/**
 */

synchronized public void add_workunit(int val) {
	admininfo.put(ADMANZREQUESTS, new Integer(gui.addRequests(val)).toString());
}
/**
 */
public void addClient(String ip) {
	ip=ip.trim().toLowerCase();

	try {
		InetAddress adr=InetAddress.getByName(ip);
		if (getProperty("nonameresolution")==null) {
			ip=adr.getHostName().toLowerCase();
		} else {
			ip=adr.getHostAddress();
		}
	
		if (data.getClient(ip)==null) {
			Client cl=new Client();
			cl.setClientName(ip);
			cl.setLastZugriff("1900.00.00 00:00:00");
			cl.setStatus(Client.WARTET);
			cl.setUnitsBisher(0);
			data.addClient(cl);
			gui.addClient(cl);
		}
	} catch(Exception e) {
		log(LS.ls("mcaddcl1") + e, LOG_ERROR);
	}
  data.saveClients();
}
/**
 */

public synchronized void addRequest(ClientConnectionData condata) {
	data.addWaitingRequest(condata);
	reset_timer(false);
}
/**
 * MainController constructor comment.
 */
public void addWorkUnit(Workunit unit) {
	wu.addWorkunit(unit);
}
/**
 * Die Beschreibung der Methode hier eingeben.
 * Erstellungsdatum: (25.11.99 10:48:33)
 */
public boolean allow_seticonnect() {
	String test = data.getProperty("connectonlymanual");
	if (test == null) {
		test = "nein";
	}
	if (test.equals("nein")) {
		return true;
	}
	if (test.equals("time")) {
		Calendar time=Calendar.getInstance();
		int akminute = time.get(time.HOUR_OF_DAY) * 60 + time.get(time.MINUTE);
		String txt = data.getProperty("connecttime1");
		if (txt != null) {
			Integer startst = MainController.getTimeElement(txt, 0);
			Integer startmi = MainController.getTimeElement(txt, 1);
			Integer stopst = MainController.getTimeElement(txt, 2);
			Integer stopmi = MainController.getTimeElement(txt, 3);
			if ((startst != null) && (startmi != null) && (stopst != null) && (stopmi != null)) {
				int startm = startst.intValue() * 60 + startmi.intValue();
				int stopm = stopst.intValue() * 60 + stopmi.intValue();
				if (startm <= stopm) {
					// Ok, bereich von z.B. 6-8, da start kleiner ist als stop
					if ((akminute >= startm) && (akminute <= stopm)) {
						return true;
					}
				} else {
					// Jetzt Bereich von z.B. 22 - 2, da start grer als stop...
					if (!((akminute > stopm) && (akminute < startm))) {
						return true;
					}
				}
			}
		}
		txt = data.getProperty("connecttime2");
		if (txt != null) {
			Integer startst = MainController.getTimeElement(txt, 0);
			Integer startmi = MainController.getTimeElement(txt, 1);
			Integer stopst = MainController.getTimeElement(txt, 2);
			Integer stopmi = MainController.getTimeElement(txt, 3);
			if ((startst != null) && (startmi != null) && (stopst != null) && (stopmi != null)) {
				int startm = startst.intValue() * 60 + startmi.intValue();
				int stopm = stopst.intValue() * 60 + stopmi.intValue();
				if (startm <= stopm) {
					// Ok, bereich von z.B. 6-8, da start kleiner ist als stop
					if ((akminute >= startm) && (akminute <= stopm)) {
						return true;
					}
				} else {
					// Jetzt Bereich von z.B. 22 - 2, da start grer als stop...
					if (!((akminute > stopm) && (akminute < startm))) {
						return true;
					}
				}
			}
		}
		return manual_reconnect;
	}
	if (test.equals("ja")) {
		return manual_reconnect;
	}
	// Default bei falschen Paras ist JA, verbinde dich, trau dich !
	return true;
}
/**
 * Die Beschreibung der Methode hier eingeben.
 * Erstellungsdatum: (24.1.2000 19:55:12)
 * @return boolean
 * @param cl SetiHome.Client
 */
public static Date clientdata_complete(Client cl) {
/*	Properties p=cl.getLookupProperties();
	/*
user_id=-1
user_key=0
major_version=2
minor_version=0
platform=Pentium/Windows
cpu_type=Intel Pentium
system=Windows NT: 4.0
id=0
key0=79aea7be
key1=6329330a
end_request_header


	if (p.get("user_id")==null) return false;
	if (p.get("user_key")==null) return false;
	if (p.get("minor_version")==null) return false;
	if (p.get("minor_version")==null) return false;
	if (p.get("platform")==null) return false;
	if (p.get("cpu_type")==null) return false;
	if (p.get("system")==null) return false;
	if (p.get("key0")==null) return false;
	if (p.get("key1")==null) return false;
			antw.getClient().getLookupProperties().put("setiproxykey-get_work_unit", (byte[])condata.getFelder().get("setiproxykey-contentsdata"));
			antw.getClient().getLookupProperties().put("setiproxykey-get_work_unit_date", new Date().toString());
	*/


	if (cl.getLookupProperties().get("setiproxykey-get_work_unit")!=null) {
		return (Date)(cl.getLookupProperties().get("setiproxykey-get_work_unit_date"));
	} else {
		return null;
	}
}
/**
 */

synchronized void close_connection() {
	admininfo.put(ADMANZPROCESSES, new Integer(gui.addProcess(-1)).toString());
}
/**
 */

synchronized void decrease_counter() {
	if (waiter>0) {
		waiter--;
	}
}
/**
 * Deinitialisiert die Logging-Datei
 */

protected synchronized void deinit_logging()
{
  if (LogPrintWriter!=null) 
  	try {
  		LogPrintWriter.close();
  	} catch(Exception eee) {
  	  System.out.println("Dumm, log kann nicht geschrieben werden: "+eee);
		}

  if (LogFile!=null)
  	try {
  		LogFile.close();
  	} catch(Exception ee) {
  	  System.out.println("Fehler schliessen logfile: "+ee);
  	}
	LogPrintWriter=null;
  LogFile=null;
}
/**
 */
public void deleteClient(String ip) {
	Client cl=data.getClient(ip);
	if (cl!=null) {
		deleteClient(cl);
	}
}
/**
 */
public void deleteClient(Client cl) {
	if (cl!=null) {
		data.deleteClient(cl);
	  data.saveClients();
		gui.deleteClient(cl);
	}
}
/**
 * Insert the method's description here.
 * Creation date: (24.09.2000 16:38:53)
 * @param fname java.lang.String
 */
public void deleteWorkunit(String fname) {
	wu.deleteWorkunit(fname)	;
}
/**
 */

public Enumeration enumWorkunits() {
	return wu.enumWorkunits();
}
/**
 */

public synchronized void finishRequest(ClientConnectionData condata) {

	data.deleteWaitingRequest(condata);

}
/**
 * MainController constructor comment.
 */
public String getAdmininfo(String wert) {
	String str=(String)admininfo.getProperty(wert);
	if (str==null) {
		//return "unbekannt";
		return LS.ls("mcadminfo1");
	} else {
		return str;
	}
}
/**
 */
public Client getClient(String ip) {
	return data.getClient(ip);
}
/**
 */
public Enumeration getClients(int value) {
	return data.getClients(value);
}
/**
 */
public int getLocalPort() {
	int wert=0;
	
	try {
		String txt=data.getProperty("port");
		if (txt!=null) {
			wert=new Integer(txt).intValue();
		}
	} catch(Exception e) {
		//log("Fehler getLocalPort: " + e, LOG_ERROR);
		log(LS.ls("mcglp1") + e, LOG_ERROR);
	}

	return wert;
}
public String getlogentries(int vontag, int vonmonat, int vonjahr, int bistag, int bismonat, int bisjahr,  int loglevel)
{
	String fromdat, todat, line, checkline;
	boolean theend;
	Object[] arg=new Object[3];
	FileReader datei=null;
	LineNumberReader lread;
	StringBuffer erg;

	try {
		datei=new FileReader(LogFileName);
	} catch(Exception e) {
	  //return new String("Error reading logfile: " + e);
	  return new String(LS.ls("mcgl1") + e);
	}



	MessageFormat form = new MessageFormat("{0,number,0000}.{1,number,00}.{2,number,00}");
	arg[0]=new Integer(vonjahr);
  arg[1]=new Integer(vonmonat);
	arg[2]=new Integer(vontag);
	fromdat=form.format(arg);
	arg[0]=new Integer(bisjahr);
  arg[1]=new Integer(bismonat);
	arg[2]=new Integer(bistag);
	todat=form.format(arg);
	
	lread=new LineNumberReader(datei);
	theend=false;
	erg=new StringBuffer();
	
	while (!theend)
	{
		try {
			line=lread.readLine();
		} catch (Exception ee) {
		  line=null;
		}

		if (line!=null)
		{
			try {
				line.substring(line.length()-2);
			  char z=line.charAt(20);
			  int lev=(byte)z- 48;
		  
		 	  if (lev>=loglevel)
			  {
		      checkline=line.substring(0, 10);
	  			if ((fromdat.compareTo(checkline)<=0) &&
	  	 			(todat.compareTo(checkline)>=0))
			  	{
				  	//erg.append(line+"\r\n");
				  	erg.append(line+"\r");
			  	}
				}
			} catch(Exception e) { };
		}
		else
		{
			theend=true;
		}
	}
	
	return erg.toString();
}
/**
 * This method was created in VisualAge.
 * @param value boolean
 */
public String getProperty(String key) {
	Object obj=data.getProperty(key);
	if (obj!=null) {
		return obj.toString();
	}
	return null;
}
/**
 */
public String getProxyAdress() {
	return data.getProperty("proxyadresse");
}
/**
 */
public String getProxyAuthent() {

	String txt=data.getProperty("proxyauth");
	if ((txt!=null) && (txt.equals("ja"))) {
		txt=data.getProperty("proxyuser");
		if ((txt!=null) && (txt.length()>0)) {
			String txt2=data.getProxyPasswort();
			if ((txt2!=null) && (txt2.length()>0)) {
				return txt+":" + txt2;
			}
		}
	}
	return null;
}
/**
 */

public String getProxyPassword() {
	return data.getProxyPasswort();
}
/**
 */
public int getProxyport() {
	int wert=0;

	try {
		String txt=(String)data.getProperty("proxy");
		if ((txt!=null) && (txt.equals("ja"))) {
			txt=data.getProperty("proxyport");
			if (txt!=null) {
				wert=new Integer(txt).intValue();
			}
		}
	} catch(Exception e) {
	};

	return wert;
}
/**
 * Die Beschreibung der Methode hier eingeben.
 * Erstellungsdatum: (22.2.2000 10:29:20)
 * @return java.lang.Integer
 * @param i java.lang.String
 * @param pos int
 */
public static Integer getTimeElement(String txt, int pos) {

	for(int i=0;i<4;i++) {
		String zahltxt;
		if (i==3) {
			zahltxt=txt;
		} else {
			int fp=txt.indexOf(':');
			if (fp>=0) {
			zahltxt=txt.substring(0, fp);
			txt=txt.substring(fp+1);
			} else {
				return null;
			}
		}
		try {
			Integer zahl=new Integer(zahltxt);
			int value=zahl.intValue();
			if ((i==0) || (i==2)) {
				if ((value<0) || (value>=24)) {
					return null;
				}
			} else {
				if ((value<0) || (value>=60)) {
					return null;
				} else {
					value=(value/5)*5;
					zahl=new Integer(value);
				}
			}
			if (i==pos) {
				return zahl;	
			}
		} catch(Exception e) {
			return null;
		}
	}
	return null;
}
/**
 * MainController constructor comment.
 */
public Enumeration getWaitingUnits() {
	return data.getWaitingRequests();
	/*
	Vector vect=new Vector();

	Enumeration org=data.getWaitingRequests();
	while(org.hasMoreElements()) {
		ClientConnectionData cond=(ClientConnectionData)org.nextElement();
		try {
			String ops=cond.getFelder().get("setiproxykey-operation").toString();
			if (ops.equals("send_result")) {
				Workunit neu=new Workunit();
				neu.setClient(cond.getClient().getClientName());
				neu.setDatum(cond.getDatum());
				vect.addElement(neu);
			}
		} catch(Exception e) {};
	}
		
	return vect.elements();
	*/
}
/**
 * MainController constructor comment.
 */
public Workunit getWorkUnit() {
	return wu.getWorkunit(true);
}
/**
 */

public void init() {
	ls=new LS();
	log(ls.loadLanguage("default.lng"), LOG_DEBUG);

  admininfo=new Properties();

	data=new DataHandler(this);
	log(ls.loadLanguage(data.getProperty("language")), LOG_DEBUG);

	log(this.version, LOG_INFO);
	log(LS.ls("mcinit1"), LOG_DEBUG);
	Properties sysprops=System.getProperties();
	log("os.name: " + sysprops.getProperty("os.name"), LOG_INFO);
	log("os.version: " + sysprops.getProperty("os.version"), LOG_INFO);
	log("os.arch: " + sysprops.getProperty("os.arch"), LOG_INFO);
	log("java.version: " + sysprops.getProperty("java.version"), LOG_INFO);
	log("java.vm.version: " + sysprops.getProperty("java.vm.version"), LOG_INFO);
	log("java.vm.vendor: " + sysprops.getProperty("java.vm.vendor"), LOG_INFO);
	log("java.vm.name: " + sysprops.getProperty("java.vm.name"), LOG_INFO);
	

	wu=new WorkunitController(this);
	
	add_workunit(data.anzWaitingRequests());

  listen=new Listener(this);
	admininfo.put(ADMANZPROCESSES, new Integer(gui.addProcess(0)).toString());

	String txt=data.getProperty("adminport");
	int port=8083;
	try {
		port=new Integer(txt).intValue();
	} catch(Exception e) {
		data.setProperty("adminport", ""+port);
	}

	txt=data.getProperty("adminservice");
	if ((txt==null) || (txt.toLowerCase().equals("ja"))) {
	  try {
			adminserver=new AdminServer(this, port);
		  adminserver.start();
	  } catch(Exception e) {
		  log(ls.ls("mcinit2"), LOG_WARNING);
	  }
		data.setProperty("adminservice", "ja");
	};


	txt=data.getProperty("maxworkunits");
	if (txt!=null) {
		try {
			int value=Integer.parseInt(txt);
			MAX_WORKUNITS=value;
		} catch(Exception e) {};
	}

  waiter=100;

  stopped=false;
  run=true;
  thread=new Thread(this, "MainCon");
  thread.start();

}
protected synchronized void init_logging()
{
	try {
		LogFile=new FileOutputStream(LogFileName, true);
	} catch(Exception ee) {
	  //System.out.println("LogFile kann nicht geoeffnet werden:"+ee);
	  System.out.println(LS.ls("mcil1") + ee);
	}

	if (LogFile==null) return;

  try {
		LogPrintWriter=new PrintWriter(LogFile, true);
	} catch(Exception eee) {
	  //System.out.println("PrintWrite kann nicht generiert werden:"+eee);
	  System.out.println(LS.ls("mcil2") + eee);
	}

}
/**
 */

public synchronized boolean isRunning() {
	return !stopped;
}
/**
 */

public synchronized boolean loadNewUnit() {
	int sollvorrat, istvorrat;
	String vorstr = data.getProperty("lagerunits");
	if (vorstr.equals("aus")) {
		sollvorrat = 0;
	} else {
		sollvorrat = new Integer(vorstr).intValue();
	}
	istvorrat = wu.getAnzWorkunits();
	if (istvorrat >= sollvorrat) {
		return false;
	} else {
		return true;
	}
}
synchronized public void log(String txt, int level) {
	try {
		init_logging();
		if (LogPrintWriter!=null)
		{
			SimpleDateFormat datform=new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
			String out=datform.format(new Date()) + "/"+level+": " + txt;
			LogPrintWriter.println(out);
			gui.log(datform.format(new Date()) + ": " + txt, level);
		}
		deinit_logging();
	} catch(Exception e) {};
}
/**
 */

synchronized void open_connection() {
	admininfo.put(ADMANZPROCESSES, new Integer(gui.addProcess(1)).toString());
}
/**
 */

private synchronized void reconnect() {
	boolean linear=false;
	boolean success=true;
	reconnect=true;

	//log("Reconnect angestossen.", LOG_DEBUG);
	log(LS.ls("mcrc1"), LOG_DEBUG);

	String txt=data.getProperty("worklinear");
	if ((txt==null) || (txt.toLowerCase().equals("ja"))) {
		linear=true;
	}


	if (linear) {
		// Erst alle aktiven rausholen, und die auf jeden Fall starten....
		Enumeration warter=data.getWaitingRequests();
		Vector tempdata=new Vector();
		while ((warter.hasMoreElements())) {
			ClientConnectionData task=(ClientConnectionData)warter.nextElement();
			if (task.getAktiv()) {
				tempdata.addElement(task);
			}
		}
		warter=tempdata.elements();
	
		while (warter.hasMoreElements()) {
			try {
				ClientConnectionData task=(ClientConnectionData)warter.nextElement();
				if (!sendRequest(task, false)) {
					success=false;
				}
			} catch(Exception e) {
				//log("Fehler reconnect linear: " + e, LOG_ERROR);
				log(LS.ls("mcrc2") + e, LOG_ERROR);
			}
		}

		// Jetzt, wenn alle aktiven bearbeitet sind, noch die restlichen, falls wir
		// keinen Fehler hatten....
		if (success) {
			tempdata=new Vector();
			warter=data.getWaitingRequests();
			while ((warter.hasMoreElements())) {
				tempdata.addElement(warter.nextElement());
			}

			int max=tempdata.size();
			Random rand=new Random(new Date().getTime());
			
			for(int i=0;i<max;i++) {
				int indx1=Math.abs(rand.nextInt())%max;
				int indx2=Math.abs(rand.nextInt())%max;
				if (indx1!=indx2) {
					Object obj1=tempdata.elementAt(indx1);
					Object obj2=tempdata.elementAt(indx2);
					if ((obj1!=null) && (obj2!=null)) {
						tempdata.setElementAt(obj1, indx2);
						tempdata.setElementAt(obj2, indx1);
					}
				}
			}

			warter=tempdata.elements();
			while ((warter.hasMoreElements()) && (success)) {
				ClientConnectionData task=(ClientConnectionData)warter.nextElement();
				success=sendRequest(task, false);
			}
		}
	} else {
		// Hier die behandlung, falls nicht linear...
		Vector tempdata=new Vector();
		Enumeration warter=data.getWaitingRequests();
		while ((warter.hasMoreElements())) {
			tempdata.addElement(warter.nextElement());
		}

		warter=tempdata.elements();
		while (warter.hasMoreElements()) {
			try {
				ClientConnectionData task=(ClientConnectionData)warter.nextElement();
				sendRequest(task, true);
			} catch(Exception e) {
			//log("Fehler reconnect: " + e, Logger.LOG_ERROR);
				log(LS.ls("mcrc3") + e, LOG_ERROR);
			}
		}
	}


	if (!allow_seticonnect()) {
		success=false;
	}
	try {
		if ((!data.getProperty("lagerunits").equals("aus")) && (success)) {
			// Ok, es werden WU's auf vorrat gehalten... also laden, dafr aber erstmal
			// einen gnstigen Client finden, der schon mal Connect mit dem Netz hatte..
			Enumeration enum=data.getClients(Client.ALLE);
			Client usecl=null;
			Date altdate=null;
			while (enum.hasMoreElements()) {
				Client cl=(Client)enum.nextElement();
				// Wenn diese beiden Felder gefllt sind, sind die restlichen auch
				// vollstndig und fr diesen Client haben wir alle ntigen Daten...
				Date dat=clientdata_complete(cl);
				if (dat!=null) {
					if (altdate!=null) {
						if (dat.after(altdate)) {
							usecl=cl;
							altdate=dat;
						}
					} else {
						usecl=cl;
						altdate=dat;
					}
				}
			}
			if (usecl!=null) {
				wu.refreshWorkunits(usecl.getClientName());
			} else {
				//log("Es existiert noch kein User mit vollstaendigen Lookup-Daten. Vorrat kann nicht aufgebaut werden.", LOG_WARNING);
				log(LS.ls("mcrc4"), LOG_WARNING);
			}
		}
	} catch(Exception e) {
		//log("Fehler reconnect: Workunits laden: " + e, LOG_ERROR);
		log(LS.ls("mcrc5") + e, LOG_ERROR);
	}
	reconnect=false;
	manual_reconnect=false;
}
/**
 */

synchronized void reset_timer(boolean status) {

	if (status) {
	  String waittxt=data.getProperty("reconnect");
	  try {
		  int wert=new Integer(waittxt).intValue();
		  if (wert<=0) {
			  waiter=-1;
		  }
		  waiter=wert;
	  } catch(Exception e) {
		  // Altes Verfahren ??
		  waiter=-1;
		  if (waittxt.equals("aus")) {
			  waiter=-1;
		  };
		  if (waittxt.equals("10 Minuten")) {
			  waiter=10*60*10;
		  };
		  if (waittxt.equals("30 Minuten")) {
			  waiter=10*60*30;
		  };
		  if (waittxt.equals("1 Stunde")) {
			  waiter=10*60*60;
		  };
		  if (waittxt.equals("6 Stunden")) {
			  waiter=10*60*60*6;
		  };
		  if (waittxt.equals("24 Stunden")) {
			  waiter=10*60*60*24;
		  };
	  }
	} else {
		waiter=0;
	}
}
/**
 */

public void run() {
	boolean timemark1=false;
	boolean timemark2=false;

	while (run) {

		// Warten auf Aktion....
		while ((waiter!=0) && (run)) {
			decrease_counter();
			String txt=data.getProperty("connectonlymanual");
			if (txt.equals("time")) {
				txt=data.getProperty("autotimereconnect");
				if ((txt!=null) && (txt.equals("ja"))) {
					// Hier jetzt noch das automatische erreichen der definierten Zeitmarken prfen...
					Calendar time=Calendar.getInstance();
					int akminute = time.get(time.HOUR_OF_DAY) * 60 + time.get(time.MINUTE);
					txt = data.getProperty("connecttime1");
					if (txt != null) {
						Integer startst = MainController.getTimeElement(txt, 0);
						Integer startmi = MainController.getTimeElement(txt, 1);
						if ((startst != null) && (startmi != null)) {
							int startm = startst.intValue() * 60 + startmi.intValue();
							if (startm==akminute) {
								// Marke ist erreicht, haben wir eventuell schon connected ??
								if (!timemark1) {
									waiter=0;
									timemark1=true;
								} 
							} else {
								timemark1=false;
							}
						}
					}
					txt = data.getProperty("connecttime2");
					if (txt != null) {
						Integer startst = MainController.getTimeElement(txt, 0);
						Integer startmi = MainController.getTimeElement(txt, 1);
						if ((startst != null) && (startmi != null)) {
							int startm = startst.intValue() * 60 + startmi.intValue();
							if (startm==akminute) {
								// Marke ist erreicht, haben wir eventuell schon connected ??
								if (!timemark2) {
									waiter=0;
									timemark2=true;
								} 
							} else {
								timemark2=false;
							}
						}
					}
				}
			}
			
			try { Thread.sleep(100); } catch(Exception e) {};
		}
		reset_timer(true);

		if (run) {
			reconnect();
		}
	}
}
/**
 */

public synchronized boolean sendRequest(ClientConnectionData condata, boolean run) {
	if (run) {
		SetiConnection send=new SetiConnection(condata, this, true);
		return true;
	} else {
		SetiConnection send=new SetiConnection(condata, this, false);
		return send.runit();
	}
}
/**
 * This method was created in VisualAge.
 * @param value boolean
 */
public void setProperty(Object key, Object value) {
	data.setProperty(key.toString(), value.toString());
	data.saveProperties();
}
/**
 */

public void setProxyPassword(String pass) {
	data.setProxyPasswort(pass);
}
/**
 */

void setzeLastZugriff(int typ, String clname) {
	SimpleDateFormat datform=new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
	String out=datform.format(new Date());
	
	switch(typ) {
		case SETISUCCESS:
			admininfo.put(ADMSETICONNECTTRYDATE, out);
			admininfo.put(ADMSETICONNECTDATE, out);
			gui.setLastSetiAccess(out);
			gui.setLastSetiTry(out);
		  break;
		case SETICONNECT:
			admininfo.put(ADMSETICONNECTTRYDATE, out);
			gui.setLastSetiTry(out);
		  break;
  	case CLIENTCONNECT:
			admininfo.put(ADMCLIENTCONNECTDATE, out);
			admininfo.put(ADMCLIENTCONNECT, clname);
  		gui.setLastClientAccessDate(out);
  		gui.setLastClientAccess(clname);
		  break;
	}
}
/**
 */

synchronized public void start_connect() {
	manual_reconnect=true;
	reset_timer(false);
}
/**
 * This method was created in VisualAge.
 */
public void stop() {
	if (!stopped) {
		listen.stop();
		data.stop();
		wu.saveWorkunits();

		if (adminserver!=null) {
			adminserver.stop();
		}

		int wait=50;
		run=false;
		while ((thread.isAlive()) && (wait>0)) {
			try { Thread.sleep(100); } catch(Exception e) {};
			wait--;
		}
		if (wait==0) {
			try {
				thread.destroy();
			} catch(Exception e) {};
			
			//log("MainControllerThread wird hart zerstoert.", LOG_WARNING);
			log(LS.ls("mcstp1"), LOG_WARNING);
		}
		//log("Programm gestoppt.", LOG_INFO);
		log(LS.ls("mcstp2"), LOG_INFO);
		stopped=true;
		gui.shutDown();
	}
	
	
	
}
/**
 */

public void treeUpdate() {
	gui.refreshClients();
	data.saveClients();
}
}
