package SetiHome;

import java.net.*;
import java.io.*;
/**
 * Copyright 1999,2000,2001 Stefan Hoffmann<br>
 *
 * This File is part of SetiProxy.<br>
 *
 *	SetiProxy is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.<br>
 *
 *	SetiProxy is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.<br>
 *
 *	You should have received a copy of the GNU General Public License
 *	along with SetiProxy; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
public class Listener implements Runnable {
	MainController con;
	Thread thread;
	boolean working;
	ServerSocket sock;

	int port;
/**
 * Netzwerk constructor comment.
 */
public Listener(MainController con) {
	super();
	this.con=con;
	working=true;
	thread=new Thread(this, "PortListener");
	thread.start();
	
}
/**
 * Netzwerk constructor comment.
 */
public void run() {

	port=con.getLocalPort();
	
	con.log(LS.ls("lstlb1a") + port + " " + LS.ls("lstlb1b"), con.LOG_INFO);
		
	try {
		sock=new ServerSocket(port);

		while (working)
		{
			Socket getsock=sock.accept();
			InetAddress adr=getsock.getInetAddress();
			con.log(LS.ls("lstlb2a") + adr + " " + LS.ls("lstlb2b"), con.LOG_DEBUG);
			Client client=con.getClient(adr.getHostName().toLowerCase());
			if (client==null) {
				client=con.getClient(adr.getHostAddress().toLowerCase());
			}
			if (client!=null)
			{
				ClientConnection clientcon=new ClientConnection(getsock, client, con, true);
			} else {
				String check=con.getProperty("autoclientinsert");
				if ((check!=null) && (check.equalsIgnoreCase("ja"))) {
					con.addClient(adr.getHostAddress());
					client=con.getClient(adr.getHostName().toLowerCase());
					if (client==null) {
						client=con.getClient(adr.getHostAddress().toLowerCase());
					}
					ClientConnection clientcon=new ClientConnection(getsock, client, con, true);
				} else {
					con.log(LS.ls("lstlb3")+" " + adr, con.LOG_ERROR);
					sendAbbruch(getsock);
				}
			}
		}
	} catch(Exception e) {
		if (e.getMessage()!=null) {
			if ((!e.getMessage().equals("socket was closed")) &&
			   (!e.getMessage().equals("Interrupts system call"))) {
				con.log(LS.ls("lstlb4") +e, con.LOG_ERROR);
  		}
		} else {
				con.log(LS.ls("lstlb4") +e, con.LOG_ERROR);
		}
	}
	con.log(LS.ls("lstlb5a") + " " + port + " " + LS.ls("lstlb5b"), con.LOG_INFO);
}
public void sendAbbruch(Socket sock) {
	try {
		OutputStream outp=sock.getOutputStream();
		outp.write("HTTP/1.0 407 Proxy authorization required\n\r".getBytes());
		outp.write(("Proxy-agent: "+MainController.version+"\n\r").getBytes());
		outp.write("Proxy-connection: close\n\r\n\r".getBytes());
		sock.close();
	} catch(Exception e) {
		con.log(LS.ls("lstlb4") + e, con.LOG_ERROR);
	}
}
/**
 * Netzwerk constructor comment.
 */
public void stop() {
	try {
		sock.close();
	} catch(Exception e) { };
	int wait=50;
	while ((thread.isAlive()) && (wait>0)) {
		try { Thread.sleep(100); } catch(Exception e) {};
		wait--;
	}
	if (wait==0) {
		/*
		try {
			thread.destroy(); } catch(Exception e) {};*/
		//con.log(LS."Listenerthread auf " + port + " wird hart zerstoert.", con.LOG_WARNING);
	}
}
}
