package SetiHome;

import java.util.*;
import java.text.*;
/**
 * Copyright 1999,2000,2001 Stefan Hoffmann<br>
 *
 * This File is part of SetiProxy.<br>
 *
 *	SetiProxy is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.<br>
 *
 *	SetiProxy is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.<br>
 *
 *	You should have received a copy of the GNU General Public License
 *	along with SetiProxy; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
public class Konsole implements GUIController {
	int prozesse;
	int wus;
	int ergs;
	MainController con;
	public boolean silentMode=false;
/**
 * Konsole constructor comment.
 */
public Konsole() {
	super();
}
/**
 * addClient method comment.
 */
public void addClient(Client cl) {
	output(datum(LS.ls("konlb1") + cl.getClientName()));
}
/**
 * addProcess method comment.
 */
public int addProcess(int wert) {
	prozesse+=wert;
	output(datum(LS.ls("konlb2") + prozesse));
	return prozesse;
}
/**
 * addRequests method comment.
 */
public int addRequests(int wert) {
	ergs+=wert;
	output(datum(LS.ls("konlb3") + ergs));
	return ergs;
}
/**
 * addWorkunits method comment.
 */
public int addWorkunits(int value) {
	wus+=value;
	output(datum(LS.ls("konlb4") + wus));
	return wus;
}
/**
 * This method was created in VisualAge.
 * @return java.lang.String
 */
public String datum(String txt) {
	SimpleDateFormat datform=new SimpleDateFormat("yyyy.MM.dd HH:mm:ss: ");
	return datform.format(new Date())+txt;
}
/**
 * deleteClient method comment.
 */
public void deleteClient(Client cl) {
	output(datum(LS.ls("konlb5a") + cl.getClientName() +" " + LS.ls("konlb5b")));
}
/**
 * log method comment.
 */
public void log(String txt, int level) {
	output(txt);
}
/**
 * This method was created in VisualAge.
 * @param args java.lang.String[]
 */
public static void main(String args[]) {
	boolean server=false;
	boolean silentMode=false;
	for(int i=0;i<args.length;i++) {
		String txt=args[i];
		
		if (txt.trim().equalsIgnoreCase("nokeys")) {
			server=true;
		}
		if (txt.trim().equalsIgnoreCase("silent")) {
			silentMode=true;
		}
	}

	if (!silentMode) {
		System.out.println("-----------------------------------------------------------------------");
		System.out.println(MainController.version);
		System.out.println("");
		if (!server) {
			System.out.println("Stopping with <q+Enter>");
		}
		System.out.println("-----------------------------------------------------------------------");
	}
	
	Konsole kon=new Konsole();
	kon.silentMode=silentMode;
	MainController con=new MainController(kon);
	kon.setMainController(con);

	if (!server) {
			
		int zeichen=0;
		try {
			while (zeichen!='q') {
				zeichen=System.in.read();
			}
		} catch(Exception e) {};
		con.stop();
		try {
			while (System.in.available()>0) {
				zeichen=System.in.read();
			}
		} catch(Exception e) {};
	}
}
/**
 * log method comment.
 */
public void output(String txt) {
	if (!silentMode) {
		System.out.println(txt);
	}
}
/**
 * refreshClients method comment.
 */
public void refreshClients() {

}
/**
 * setLastClientAccess method comment.
 */
public void setLastClientAccess(String value) {
	output(datum(LS.ls("konlb6a") + value + " " + LS.ls("konlb6b")));
}
/**
 * setLastClientAccessDate method comment.
 */
public void setLastClientAccessDate(String date) {
}
/**
 * setLastSetiAccess method comment.
 */
public void setLastSetiAccess(String date) {
}
/**
 * setLastSetiTry method comment.
 */
public void setLastSetiTry(String date) {
}
/**
 * addClient method comment.
 */
public void setMainController(MainController con) {
	this.con=con;
}
/**
 * Insert the method's description here.
 * Creation date: (27.09.2000 19:21:39)
 */
public void shutDown() {
	System.exit(0);	
}
}
