package SetiHome;

import java.text.*;
import java.util.*;
/**
 * Copyright 1999,2000,2001 Stefan Hoffmann<br>
 *
 * This File is part of SetiProxy.<br>
 *
 *	SetiProxy is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.<br>
 *
 *	SetiProxy is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.<br>
 *
 *	You should have received a copy of the GNU General Public License
 *	along with SetiProxy; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */public class Client implements java.io.Serializable {
	protected String clientName;
	protected int status;
	protected int unitsBisher;
	protected String lastZugriff;

	public static final int RECHNET=1;
	public static final int WARTET=2;
	public static final int NETZ=4;
	public static final int DRAW=8;
	public static final int ALLE=15;
	
	protected Properties lookupProperties;
	protected byte[] lookupAnswer;
/**
 * Client constructor comment.
 */
public Client() {
	super();
}
/**
 * Client constructor comment.
 */
public Client(String data) throws java.lang.Exception {
	super();

	int p1, p2;
	p1=0;
	p2=data.indexOf(',');
	if (p2>p1+1) {
		clientName=data.substring(p1, p2);
	}
	p1=p2+1;
	p2=data.indexOf(',', p1);
	if (p2>p1) {
		status=new Integer(data.substring(p1, p2)).intValue();
	}
	p1=p2+1;
	p2=data.indexOf(',', p1);
	if (p2>p1) {
		unitsBisher=new Integer(data.substring(p1, p2)).intValue();
	}
	lastZugriff=data.substring(p2+1);
	
}
/**
 * This method was created in VisualAge.
 * @return java.lang.String
 */
public String getClientName() {
	return clientName;
}
/**
 * This method was created in VisualAge.
 * @return java.lang.String
 */
public String getLastZugriff() {
	return lastZugriff;
}
/**
 * This method was created in VisualAge.
 * @return byte[]
 */
public byte[] getLookupAnswer() {
	return lookupAnswer;
}
/**
 * This method was created in VisualAge.
 * @return int
 */
public boolean getLookupKomplett() {
	// Wenn diese beiden Felder gefllt sind, sind die restlichen auch
	// vollstndig und fr diesen Client haben wir alle ntigen Daten...
	if ((getLookupProperties().get("id")!=null) && (getLookupProperties().get("major_version")!=null)) {
		return true;
	} else {
		return false;
	}
}
/**
 * This method was created in VisualAge.
 * @return java.util.Properties
 */
public Properties getLookupProperties() {
	if (lookupProperties==null) {
		lookupProperties=new Properties();
	}
	return lookupProperties;
}
/**
 * This method was created in VisualAge.
 * @return java.lang.String
 */
public String getSaveString() {
	StringBuffer str=new StringBuffer();
	if (clientName!=null) {
		str.append(clientName);
	}
	str.append(",");
	str.append(status);
	str.append(",");
	str.append(unitsBisher);
	str.append(",");
	str.append(lastZugriff);
	return str.toString();
}
/**
 * This method was created in VisualAge.
 * @return int
 */
public int getStatus() {
	return status;
}
/**
 * This method was created in VisualAge.
 * @return int
 */
public String getStatusText() {
	StringBuffer buf=new StringBuffer();
	if ((status&RECHNET)!=0) {
		buf.append("Rechnet ");
	}
	if ((status&WARTET)!=0) {
		buf.append("wartet ");
	}
	if ((status&NETZ)!=0) {
		buf.append("bertrgt ");
	}
	return buf.toString();
}
/**
 * This method was created in VisualAge.
 * @return int
 */
public int getUnitsBisher() {
	return unitsBisher;
}
/**
 * This method was created in VisualAge.
 * @param newValue int
 */
public void resetDraw() {
	status&= ALLE-DRAW;
}
/**
 * This method was created in VisualAge.
 * @param newValue java.lang.String
 */
public void setClientName(String newValue) {
	this.clientName = newValue;
}
/**
 * This method was created in VisualAge.
 * @param newValue java.lang.String
 */
public void setLastZugriff() {
	SimpleDateFormat datform=new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");	
	this.lastZugriff = datform.format(new Date());
	this.status|=DRAW;
}
/**
 * This method was created in VisualAge.
 * @param newValue java.lang.String
 */
public void setLastZugriff(String newValue) {
	this.lastZugriff = newValue;
	this.status|=DRAW;
}
/**
 * This method was created in VisualAge.
 * @param newValue byte[]
 */
public void setLookupAnswer(byte[] newValue) {
	this.lookupAnswer = newValue;
}
/**
 * This method was created in VisualAge.
 * @param newValue java.util.Properties
 */
public void setLookupProperties(Properties newValue) {
	this.lookupProperties = newValue;
}
/**
 * This method was created in VisualAge.
 * @param newValue int
 */
public void setStatus(int newValue) {
	this.status = newValue;
	this.status|=DRAW;

}
/**
 * This method was created in VisualAge.
 * @param newValue int
 */
public void setUnitsBisher(int newValue) {
	this.unitsBisher = newValue;
	this.status|=DRAW;

}
/**
 * This method was created in VisualAge.
 * @return java.lang.String
 */
public String toString() {
	return clientName+": " + getStatusText();
}
}
