#!/bin/sh
##-----------------------------------------------------------------------------
## imonc2do_conf.cgi                                                        0.5
##
## Creation:     ??.??.2002  tc
## Last Update:  13.05.2002  tc
##
## Copyright (c) 2002 Thomas Creutz <thomas.creutz@epost.de>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##-----------------------------------------------------------------------------
#----------------------------------------------------------------------------
# /etc/ppp/ip-up.register - fli4l registration (and refresh)
#
# Creation:     14.02.2002  fm
# Last Update:  $Id: register.sh,v 1.3 2002/02/17 23:13:05 fm Exp $
#----------------------------------------------------------------------------
interface=$1				    # from /etc/ppp/ip-up.register
					            # may be empty

day=`date +%d.%m.%Y`
last_day=`cat /var/run/last-register 2>/dev/null`
. /var/run/register.cfg

if [ "$register_always" = "yes" -o "$day" != "$last_day" ]
then
    port=5003

    circuit_valid='false'

    if [ "$interface" != "" ]
    then
	for j in $register_circuits
	do
	    file=/var/run/circuit-$j		# created by etc/rc.d/circuits

	    if [ -f $file ]
	    then
		dev=`cat $file`

		if [ "$dev" = "$interface" ]
		then				# created by etc/rc.d/rc.time
		    circuit_valid='true'
		    break
		fi
	    fi
	done
    else
	circuit_valid='true'
    fi

    if [ "$circuit_valid" = "true" -a -f /var/run/register ]
    then
	set -- `cat /var/run/register`

	key=$1
	use_uptime=$2
	id=$3

	if [ "$id" = "" ]		    # 1st time after boot
	then
	    id=0
	fi

	if [ "$use_uptime" = "yes" ]
	then
	    set -- `cat /proc/uptime`
	    uptime=$1
	else
	    uptime=0
	fi

	if [ "$register_version" = "yes" ]
	then
	    version=`cat /etc/version`
	else
	    version='-'
	fi

	if [ "$register_nick" = "" ]
	then
	    register_nick='-'
	fi

	if [ $id = 0 -o $uptime != 0 ]	# don't connect if uptime not wanted
	then				# and fli4l-id already known
	    answer=`echo register $key $id $uptime $version $register_nick | /usr/local/bin/netcat -w 15 $register_server $port`

	    if [ $? = 0 ]
	    then
		set -- $answer

		case "$1"
		in
		    OK*)
			id=$2
			rank=$3

			if [ "$rank" != "" ]
			then
			    message="Deine fli4l-id ist $id  und du stehst in der Highscore auf Platz $rank"
			else
			    message="Deine fli4l-id: $id"
			fi
			echo "$key $use_uptime $id" >/var/run/register
			echo "$day" >/var/run/last-register
			echo "$id" >/var/run/fli4l-id
			;;
		    ERR*)
			message="$*"
			;;
		    *)
			message="$*"
			;;
		esac

		if [ "$message" = "" ]
		then
		    message="Sorry, aber es kam keine Antwort vom Server!"
		fi

		message=$message
	    else
		message="register: connect error" >&2
	    fi
	fi
    else
	if [ "$circuit_valid" = "true" ]
	then
	    message="no user registration data found" >&2
	fi
    fi
fi

# HTML-Header
echo "Content-Type: text/html; charset=iso-8859-1"
echo "Cache-control: no-store" # HTTP/1.1 (or no-cache?)
echo "Pragma: no-cache"        # HTTP/1.0
echo "Expires: `date -Ru`"     # Expires now!
echo
echo "<html><head>"
echo "<LINK REL=STYLESHEET TYPE="text/css" HREF="main.css">"
echo "<title>OPT Register Plus</title>"
echo "</head><body link=blue alink=blue vlink=blue>"
echo "<center>"
echo "<h1>OPT RegisterPlus v0.5</h1>"
echo "<b><font size="1">Erstellt von Thomas Creutz</font></b>"
echo "<br>"
echo "<b>`echo $message`</b>"
uptime=`cat /proc/uptime | cut -f1 -d"." `
tage=`expr $uptime / 86400`
stunden=`expr $uptime % 86400 / 3600 `
minuten=`expr $uptime % 3600 / 60`
sekunden=`expr $uptime % 60`
echo "<div align="center">"
echo "<p><font size="2">Nick: `echo $register_nick` | Uptime: `echo $tage` Tage `echo $stunden` Stunden `echo $minuten` Minuten `echo $sekunden` Sekunden | Version: `echo $version`</font></p>"
echo "<b><font size="2">Aktueller Stand</font></b>"
echo "<br>"
echo "<b><a target="Unten" href="http://eisler.fet.uni-hannover.de:5003">TOP 20</a> |
<a target="Unten" href="http://eisler.fet.uni-hannover.de:5003/top-50">TOP 50</a>
| <a target="Unten" href="http://eisler.fet.uni-hannover.de:5003/top-100">TOP
100</a> |
<a target="Unten" href="http://eisler.fet.uni-hannover.de:5003/top-200">TOP 200</a>
| <a target="Unten" href="http://eisler.fet.uni-hannover.de:5003/top-300">TOP
300</a> |
<a target="Unten" href="http://eisler.fet.uni-hannover.de:5003/top-500">TOP 500</a>
| <a target="Unten" href="http://eisler.fet.uni-hannover.de:5003/top-1000">TOP
1000</a></b>"
echo "</center>"
echo "</body></html>"
exit 0