#!/bin/sh 
#------------------------------------------------------------------------------
# /usr/local/bin/hangup - fli4l hangup tool
#
# Creation:	13.02.2003  fm
# Last Update:  $Id: hangup.sh,v 1.1.2.1 2003/04/26 21:30:41 fm Exp $
#
# History:
#   - 26.04.2003: Adapted some changes by Gernot Miksch
#------------------------------------------------------------------------------

interface=$1
hangup_timeout=`cat /var/run/hangup_timeout 2>/dev/null` 
echo "Start up hangup-supervisor at $interface with $hangup_timeout sec"

status=unknown
check_interval=5
cnt=0

until [ "$status" = "offline" ]
do
    {
	read title
	read line

	session_found=false

	while [ "$line" != "" ]
	do
	  set $line
	  if [ $8 -gt 10000 ]   # 10000 ticks = 10 seconds
	  then
		status=online
		session_found=true
		cnt=0
		break
	  fi
	  read line
	done

	if [ "$session_found" = "false" -a "$status" != "offline" ]
	then
	    cnt=`expr $cnt + $check_interval`
	    if [ $cnt -ge $hangup_timeout ]
	    then
		/usr/local/bin/fli4lctrl hangup $interface
		status=offline
		cnt=0
	    fi
	fi
    } </proc/net/ip_masquerade

    sleep $check_interval
done 
